/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.utils;

import com.github.tommyettinger.gand.utils.IntComparator;
import java.util.Arrays;
import java.util.Comparator;

public final class IntComparators {
    public static final IntComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final IntComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();
    public static final IntComparator UNSIGNED_COMPARATOR = new UnsignedComparator();
    public static final IntComparator UNSIGNED_OPPOSITE_COMPARATOR = new UnsignedComparator();

    private IntComparators() {
    }

    public static IntComparator oppositeComparator(IntComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static IntComparator asIntComparator(final Comparator<? super Integer> c) {
        if (c instanceof IntComparator) {
            return (IntComparator)c;
        }
        return new IntComparator(){

            @Override
            public int compare(int x, int y) {
                return c.compare(x, y);
            }

            @Override
            public int compare(Integer x, Integer y) {
                return c.compare(x, y);
            }
        };
    }

    private static void swap(int[] items, int first, int second) {
        int firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(int[] items, int from, int mid, int to, IntComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                IntComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = IntComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = IntComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                IntComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                IntComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                IntComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        IntComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        IntComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(int[] items, int from, int to, int pos, IntComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(int[] items, int from, int to, int pos, IntComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(int[] items, IntComparator c) {
        IntComparators.sort(items, 0, items.length, c);
    }

    public static void sort(int[] items, int from, int to, IntComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in IntComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    IntComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        IntComparators.sort(items, from, mid, c);
        IntComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        IntComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements IntComparator {
        final IntComparator comparator;

        protected OppositeComparator(IntComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(int a, int b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final IntComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements IntComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(int a, int b) {
            return Integer.compare(a, b);
        }

        @Override
        public IntComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements IntComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(int a, int b) {
            return Integer.compare(b, a);
        }

        @Override
        public IntComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class UnsignedComparator
    implements IntComparator {
        protected UnsignedComparator() {
        }

        @Override
        public final int compare(int a, int b) {
            return Integer.compare(a + Integer.MIN_VALUE, b + Integer.MIN_VALUE);
        }

        @Override
        public IntComparator reversed() {
            return UNSIGNED_OPPOSITE_COMPARATOR;
        }
    }

    protected static class UnsignedOppositeComparator
    implements IntComparator {
        protected UnsignedOppositeComparator() {
        }

        @Override
        public final int compare(int a, int b) {
            return Integer.compare(b + Integer.MIN_VALUE, a + Integer.MIN_VALUE);
        }

        @Override
        public IntComparator reversed() {
            return UNSIGNED_COMPARATOR;
        }
    }
}

