/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.utils;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.GridPoint3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public class JsonRegistration {
    private JsonRegistration() {
    }

    public static void registerAll(Json json) {
        JsonRegistration.registerVector2(json);
        JsonRegistration.registerVector3(json);
        JsonRegistration.registerVector4(json);
        JsonRegistration.registerGridPoint2(json);
        JsonRegistration.registerGridPoint3(json);
    }

    public static void registerVector2(Json json) {
        json.addClassTag("V2", Vector2.class);
        json.setSerializer(Vector2.class, (Json.Serializer)new Json.Serializer<Vector2>(){

            public void write(Json json, Vector2 object, Class knownType) {
                json.writeObjectStart(Vector2.class, knownType);
                json.writeValue("x", (Object)Float.valueOf(object.x));
                json.writeValue("y", (Object)Float.valueOf(object.y));
                json.writeObjectEnd();
            }

            public Vector2 read(Json json, JsonValue jsonData, Class type) {
                if (jsonData == null || jsonData.isNull()) {
                    return null;
                }
                return new Vector2(jsonData.getFloat("x", 0.0f), jsonData.getFloat("y", 0.0f));
            }
        });
    }

    public static void registerVector3(Json json) {
        json.addClassTag("V3", Vector3.class);
        json.setSerializer(Vector3.class, (Json.Serializer)new Json.Serializer<Vector3>(){

            public void write(Json json, Vector3 object, Class knownType) {
                json.writeObjectStart(Vector3.class, knownType);
                json.writeValue("x", (Object)Float.valueOf(object.x));
                json.writeValue("y", (Object)Float.valueOf(object.y));
                json.writeValue("z", (Object)Float.valueOf(object.z));
                json.writeObjectEnd();
            }

            public Vector3 read(Json json, JsonValue jsonData, Class type) {
                if (jsonData == null || jsonData.isNull()) {
                    return null;
                }
                return new Vector3(jsonData.getFloat("x", 0.0f), jsonData.getFloat("y", 0.0f), jsonData.getFloat("z", 0.0f));
            }
        });
    }

    public static void registerVector4(Json json) {
        json.addClassTag("V4", Vector4.class);
        json.setSerializer(Vector4.class, (Json.Serializer)new Json.Serializer<Vector4>(){

            public void write(Json json, Vector4 object, Class knownType) {
                json.writeObjectStart(Vector4.class, knownType);
                json.writeValue("x", (Object)Float.valueOf(object.x));
                json.writeValue("y", (Object)Float.valueOf(object.y));
                json.writeValue("z", (Object)Float.valueOf(object.z));
                json.writeValue("z", (Object)Float.valueOf(object.w));
                json.writeObjectEnd();
            }

            public Vector4 read(Json json, JsonValue jsonData, Class type) {
                if (jsonData == null || jsonData.isNull()) {
                    return null;
                }
                return new Vector4(jsonData.getFloat("x", 0.0f), jsonData.getFloat("y", 0.0f), jsonData.getFloat("z", 0.0f), jsonData.getFloat("w", 0.0f));
            }
        });
    }

    public static void registerGridPoint2(Json json) {
        json.addClassTag("G2", GridPoint2.class);
        json.setSerializer(GridPoint2.class, (Json.Serializer)new Json.Serializer<GridPoint2>(){

            public void write(Json json, GridPoint2 object, Class knownType) {
                json.writeObjectStart(GridPoint2.class, knownType);
                json.writeValue("x", (Object)object.x);
                json.writeValue("y", (Object)object.y);
                json.writeObjectEnd();
            }

            public GridPoint2 read(Json json, JsonValue jsonData, Class type) {
                if (jsonData == null || jsonData.isNull()) {
                    return null;
                }
                return new GridPoint2(jsonData.getInt("x", 0), jsonData.getInt("y", 0));
            }
        });
    }

    public static void registerGridPoint3(Json json) {
        json.addClassTag("G3", GridPoint3.class);
        json.setSerializer(GridPoint3.class, (Json.Serializer)new Json.Serializer<GridPoint3>(){

            public void write(Json json, GridPoint3 object, Class knownType) {
                json.writeObjectStart(GridPoint3.class, knownType);
                json.writeValue("x", (Object)object.x);
                json.writeValue("y", (Object)object.y);
                json.writeValue("z", (Object)object.z);
                json.writeObjectEnd();
            }

            public GridPoint3 read(Json json, JsonValue jsonData, Class type) {
                if (jsonData == null || jsonData.isNull()) {
                    return null;
                }
                return new GridPoint3(jsonData.getInt("x", 0), jsonData.getInt("y", 0), jsonData.getInt("z", 0));
            }
        });
    }
}

