/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.utils;

import java.util.Comparator;

public class ObjectSort {
    private static <K> void swap(K[] items, int first, int second) {
        K firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static <K> void inPlaceMerge(K[] items, int from, int mid, int to, Comparator<? super K> comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                ObjectSort.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = ObjectSort.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = ObjectSort.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                ObjectSort.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                ObjectSort.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                ObjectSort.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        ObjectSort.inPlaceMerge(items, from, firstCut, mid, comp);
        ObjectSort.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static <K> int lowerBound(K[] items, int from, int to, int pos, Comparator<? super K> comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static <K> int upperBound(K[] items, int from, int to, int pos, Comparator<? super K> comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static <K> void sort(K[] items, Comparator<? super K> c) {
        ObjectSort.sort(items, 0, items.length, c);
    }

    public static <K> void sort(K[] items, int from, int to, Comparator<? super K> c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in Comparators.sort() is invalid.");
        }
        if (c == null) {
            if (items instanceof Comparable[]) {
                ObjectSort.sort(items, from, to, (o1, o2) -> o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : 0);
            }
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    ObjectSort.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ObjectSort.sort(items, from, mid, c);
        ObjectSort.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        ObjectSort.inPlaceMerge(items, from, mid, to, c);
    }
}

