/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gand.utils;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.gand.utils.GwtIncompatible;
import com.github.tommyettinger.gdcrux.Distributor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Random;

public class Taxon32Random
extends Random
implements Json.Serializable,
Externalizable {
    protected int stateA;
    protected int stateB;

    public Taxon32Random() {
        this((int)((Math.random() - 0.5) * 4.294967296E9), (int)((Math.random() - 0.5) * 4.294967296E9));
    }

    public Taxon32Random(int seed) {
        super(seed);
        this.setSeed(seed);
    }

    public Taxon32Random(long seed) {
        super(seed);
        this.setSeed(seed);
    }

    public Taxon32Random(int stateA, int stateB) {
        super(stateA);
        this.stateA = stateA;
        this.stateB = stateB;
    }

    public int getSelectedState(int selection) {
        if (selection == 0) {
            return this.stateA;
        }
        return this.stateB;
    }

    public void setSelectedState(int selection, int value) {
        if (selection == 0) {
            this.stateA = value;
        } else {
            this.stateB = value;
        }
    }

    @Override
    public void setSeed(long seed) {
        this.stateA = (int)seed;
        this.stateB = (int)(seed >>> 32);
    }

    public void setSeed(int seed) {
        this.stateA = seed;
        this.stateB = ~seed;
    }

    public int getStateA() {
        return this.stateA;
    }

    public void setStateA(int stateA) {
        this.stateA = stateA;
    }

    public int getStateB() {
        return this.stateB;
    }

    public void setStateB(int stateB) {
        this.stateB = stateB;
    }

    public void setState(int stateA, int stateB) {
        this.stateA = stateA;
        this.stateB = stateB;
    }

    @Override
    public long nextLong() {
        int x = this.stateA = this.stateA + -1640531523 ^ 0xD1B54A32;
        int t = x & -615576682 - x;
        int y = this.stateB = this.stateB + (t << 1 | t >>> 31) ^ 0xAF723597;
        y += x << y | x >>> 32 - y;
        y = (y ^ y >>> 22 ^ y << 5) * 738797;
        int hi = y ^ y >>> 21;
        x = this.stateA = this.stateA + -1640531523 ^ 0xD1B54A32;
        t = x & -615576682 - x;
        y = this.stateB = this.stateB + (t << 1 | t >>> 31) ^ 0xAF723597;
        y += x << y | x >>> 32 - y;
        y = (y ^ y >>> 22 ^ y << 5) * 738797;
        int lo = y ^ y >>> 21;
        return (long)hi << 32 ^ (long)lo;
    }

    @Override
    public int next(int bits) {
        int x = this.stateA = this.stateA + -1640531523 ^ 0xD1B54A32;
        int t = x & -615576682 - x;
        int y = this.stateB = this.stateB + (t << 1 | t >>> 31) ^ 0xAF723597;
        y += x << y | x >>> 32 - y;
        y = (y ^ y >>> 22 ^ y << 5) * 738797;
        return (y ^ y >>> 21) >>> 32 - bits;
    }

    @Override
    public int nextInt() {
        int x = this.stateA = this.stateA + -1640531523 ^ 0xD1B54A32;
        int t = x & -615576682 - x;
        int y = this.stateB = this.stateB + (t << 1 | t >>> 31) ^ 0xAF723597;
        y += x << y | x >>> 32 - y;
        y = (y ^ y >>> 22 ^ y << 5) * 738797;
        return y ^ y >>> 21;
    }

    public long previousLong() {
        return (long)this.previousInt() ^ (long)this.previousInt() << 32;
    }

    public int previousInt() {
        int y = this.stateB;
        int x = this.stateA;
        int t = x & -615576682 - x;
        this.stateB = (y ^ 0xAF723597) - (t << 1 | t >>> 31) | 0;
        this.stateA = (x ^ 0xD1B54A32) - -1640531523 | 0;
        y += x << y | x >>> 32 - y;
        y = (y ^ y >>> 22 ^ y << 5) * 738797;
        return y ^ y >>> 21;
    }

    @Override
    public int nextInt(int bound) {
        return (int)((long)bound * ((long)this.nextInt() & 0xFFFFFFFFL) >> 32) & ~(bound >> 31);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            int r = this.nextInt();
            int n = Math.min(bytes.length - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)r;
                r >>>= 8;
            }
        }
    }

    @Override
    public long nextLong(long inner, long outer) {
        long randLow = (long)this.nextInt() & 0xFFFFFFFFL;
        long randHigh = (long)this.nextInt() & 0xFFFFFFFFL;
        if (inner >= outer) {
            return inner;
        }
        long bound = outer - inner;
        long boundLow = bound & 0xFFFFFFFFL;
        long boundHigh = bound >>> 32;
        return inner + (randHigh * boundLow >>> 32) + (randLow * boundHigh >>> 32) + randHigh * boundHigh;
    }

    @Override
    public boolean nextBoolean() {
        return (long)this.nextInt() < 0L;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        return Distributor.normal((long)this.nextLong());
    }

    public String serializeToString() {
        return this.stateA + "~" + this.stateB;
    }

    public Taxon32Random deserializeFromString(String data) {
        if (data == null || data.length() < 3) {
            return this;
        }
        int tilde = data.indexOf(126);
        this.stateA = Integer.parseInt(data.substring(0, tilde));
        this.stateB = Integer.parseInt(data.substring(tilde + 1));
        return this;
    }

    public Taxon32Random copy() {
        return new Taxon32Random(this.stateA, this.stateB);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Taxon32Random random = (Taxon32Random)o;
        if (this.stateA != random.stateA) {
            return false;
        }
        return this.stateB == random.stateB;
    }

    public int hashCode() {
        return 31 * this.stateA + this.stateB;
    }

    public String toString() {
        return "Taxon32Random{stateA=" + this.stateA + ", stateB=" + this.stateB + '}';
    }

    public void write(Json json) {
        json.writeObjectStart("taxon");
        json.writeValue("a", (Object)this.stateA);
        json.writeValue("b", (Object)this.stateB);
        json.writeObjectEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        jsonData = jsonData.get("taxon");
        this.stateA = jsonData.getInt("a");
        this.stateB = jsonData.getInt("b");
    }

    @Override
    @GwtIncompatible
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.stateA);
        out.writeInt(this.stateB);
    }

    @Override
    @GwtIncompatible
    public void readExternal(ObjectInput in) throws IOException {
        this.stateA = in.readInt();
        this.stateB = in.readInt();
    }
}

