/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

public final class Distributor {
    private static final double[] TABLE = new double[1024];
    private static final float[] TABLE_F = new float[1024];

    private Distributor() {
    }

    public static double probit(double d) {
        if (d <= 0.0 || d >= 1.0) {
            return Math.copySign(8.375, d - 0.5);
        }
        if (d < 0.02425) {
            double q = Math.sqrt(-2.0 * Math.log(d));
            return (((((-0.007784894002430293 * q - 0.3223964580411365) * q - 2.400758277161838) * q - 2.549732539343734) * q + 4.374664141464968) * q + 2.938163982698783) / ((((0.007784695709041462 * q + 0.3224671290700398) * q + 2.445134137142996) * q + 3.754408661907416) * q + 1.0);
        }
        if (0.97575 < d) {
            double q = Math.sqrt(-2.0 * Math.log(1.0 - d));
            return -(((((-0.007784894002430293 * q - 0.3223964580411365) * q - 2.400758277161838) * q - 2.549732539343734) * q + 4.374664141464968) * q + 2.938163982698783) / ((((0.007784695709041462 * q + 0.3224671290700398) * q + 2.445134137142996) * q + 3.754408661907416) * q + 1.0);
        }
        double q = d - 0.5;
        double r = q * q;
        return (((((-39.69683028665376 * r + 220.9460984245205) * r - 275.9285104469687) * r + 138.357751867269) * r - 30.66479806614716) * r + 2.506628277459239) * q / (((((-54.47609879822406 * r + 161.5858368580409) * r - 155.6989798598866) * r + 66.80131188771972) * r - 13.28068155288572) * r + 1.0);
    }

    private static double erfcBase(double x) {
        return 0.5641895835477563 / (x + 2.0695502313291416) * ((x * (x + 2.710785400451478) + 5.807556131303016) / (x * (x + 3.4795405709951894) + 12.061668872862395)) * ((x * (x + 3.474695137774396) + 12.074020364063815) / (x * (x + 3.720684439602251) + 8.443197810039685)) * ((x * (x + 4.0056150920225955) + 9.305966594858878) / (x * (x + 3.902257040299241) + 6.361616309538805)) * ((x * (x + 5.167227058178126) + 9.126616176736732) / (x * (x + 4.032968931092625) + 5.135785305856816)) * ((x * (x + 5.959087954466333) + 9.194356128869693) / (x * (x + 4.112409429574509) + 4.486403295234087)) * Math.exp(-x * x);
    }

    private static double erfc(double x) {
        return x >= 0.0 ? Distributor.erfcBase(x) : 2.0 - Distributor.erfcBase(-x);
    }

    public static double probitHighPrecision(double d) {
        double x = Distributor.probit(d);
        if (d > 0.0 && d < 1.0 && d != 0.5) {
            double e = 0.5 * Distributor.erfc(x * -0.7071067811865475) - d;
            double u = e * 2.5066282746310002 * Math.exp(x * x * 0.5);
            x -= u / (1.0 + x * u * 0.5);
        }
        return x;
    }

    public static double normal(long n) {
        double v;
        long sign = n >> 63;
        int top10 = (int)((n ^= sign) >>> 53);
        double t = (double)(n & 0x1FFFFFFFFFFFFFL) * (double)1.110223E-16f;
        if (top10 == 1023) {
            v = t * t * 5.077806654308063 + 3.297193345691938;
        } else {
            double s = TABLE[top10];
            v = t * (TABLE[top10 + 1] - s) + s;
        }
        return Math.copySign(v, (double)sign);
    }

    public static float normalF(int n) {
        float v;
        int sign = n >> 31;
        int top10 = (n ^= sign) >>> 21;
        float t = (float)(n & 0x1FFFFF) * 4.7683716E-7f;
        if (top10 == 1023) {
            v = t * t * 5.0778112f + 3.2971933f;
        } else {
            float s = TABLE_F[top10];
            v = t * (TABLE_F[top10 + 1] - s) + s;
        }
        return Math.copySign(v, sign);
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            Distributor.TABLE[i] = Distributor.probitHighPrecision(0.5 + (double)i * 4.8828125E-4);
            Distributor.TABLE_F[i] = (float)Distributor.TABLE[i];
        }
    }
}

