/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.crux.Point2;
import java.util.Random;

public class PointF2
extends Vector2
implements Point2<PointF2>,
Json.Serializable {
    public PointF2() {
    }

    public PointF2(float x, float y) {
        super(x, y);
    }

    public PointF2(Vector2 p) {
        super(p);
    }

    public PointF2(GridPoint2 p) {
        super((float)p.x, (float)p.y);
    }

    public PointF2(PointF2 p) {
        super((Vector2)p);
    }

    public PointF2(Point2<? extends Point2<?>> p) {
        this(p.x(), p.y());
    }

    public boolean floatingPoint() {
        return true;
    }

    public PointF2 cpy() {
        return new PointF2(this);
    }

    public PointF2 set(PointF2 point) {
        super.set((Vector2)point);
        return this;
    }

    public PointF2 sub(PointF2 point) {
        super.sub((Vector2)point);
        return this;
    }

    public PointF2 add(PointF2 point) {
        super.add((Vector2)point);
        return this;
    }

    public PointF2 scl(PointF2 point) {
        super.scl((Vector2)point);
        return this;
    }

    public float dst(PointF2 point) {
        return super.dst((Vector2)point);
    }

    public float dst2(PointF2 point) {
        return super.dst2((Vector2)point);
    }

    public PointF2 setZero() {
        super.setZero();
        return this;
    }

    public float x() {
        return this.x;
    }

    public PointF2 x(float next) {
        this.x = next;
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointF2 y(float next) {
        this.y = next;
        return this;
    }

    public PointF2 set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public PointF2 set(Vector2 v) {
        super.set(v);
        return this;
    }

    public PointF2 sub(Vector2 v) {
        super.sub(v);
        return this;
    }

    public PointF2 sub(float x, float y) {
        super.sub(x, y);
        return this;
    }

    public PointF2 nor() {
        super.nor();
        return this;
    }

    public PointF2 add(Vector2 v) {
        super.add(v);
        return this;
    }

    public PointF2 add(float x, float y) {
        super.add(x, y);
        return this;
    }

    public PointF2 scl(float scalar) {
        super.scl(scalar);
        return this;
    }

    public PointF2 scl(float x, float y) {
        super.scl(x, y);
        return this;
    }

    public PointF2 scl(Vector2 v) {
        super.scl(v);
        return this;
    }

    public PointF2 mulAdd(Vector2 vec, float scalar) {
        super.mulAdd(vec, scalar);
        return this;
    }

    public PointF2 mulAdd(Vector2 vec, Vector2 mulVec) {
        super.mulAdd(vec, mulVec);
        return this;
    }

    public PointF2 limit(float limit) {
        super.limit(limit);
        return this;
    }

    public PointF2 limit2(float limit2) {
        super.limit2(limit2);
        return this;
    }

    public PointF2 clamp(float min, float max) {
        super.clamp(min, max);
        return this;
    }

    public PointF2 setLength(float len) {
        super.setLength(len);
        return this;
    }

    public PointF2 setLength2(float len2) {
        super.setLength2(len2);
        return this;
    }

    public PointF2 mul(Matrix3 mat) {
        super.mul(mat);
        return this;
    }

    public PointF2 setAngleDeg(float degrees) {
        super.setAngleDeg(degrees);
        return this;
    }

    public PointF2 setAngleRad(float radians) {
        super.setAngleRad(radians);
        return this;
    }

    public PointF2 rotateDeg(float degrees) {
        super.rotateDeg(degrees);
        return this;
    }

    public PointF2 rotateRad(float radians) {
        super.rotateRad(radians);
        return this;
    }

    public PointF2 rotateAroundDeg(Vector2 reference, float degrees) {
        super.rotateAroundDeg(reference, degrees);
        return this;
    }

    public PointF2 rotateAroundRad(Vector2 reference, float radians) {
        super.rotateAroundRad(reference, radians);
        return this;
    }

    public PointF2 rotate90(int dir) {
        super.rotate90(dir);
        return this;
    }

    public PointF2 lerp(Vector2 target, float alpha) {
        super.lerp(target, alpha);
        return this;
    }

    public PointF2 interpolate(Vector2 target, float alpha, Interpolation interpolation) {
        super.interpolate(target, alpha, interpolation);
        return this;
    }

    public PointF2 setToRandomDirection() {
        return this.setToRandomDirection(MathUtils.random);
    }

    public PointF2 setToRandomDirection(Random random) {
        float theta = random.nextFloat() * ((float)Math.PI * 2);
        return this.set(MathUtils.cos((float)theta), MathUtils.sin((float)theta));
    }

    public PointF2 clampEach(float min, float max) {
        this.x = Math.min(Math.max(this.x, min), max);
        this.y = Math.min(Math.max(this.y, min), max);
        return this;
    }

    public PointF2 fract() {
        this.x -= (float)MathUtils.floor((float)this.x);
        this.y -= (float)MathUtils.floor((float)this.y);
        return this;
    }

    public int hashCode() {
        int h = NumberUtils.floatToIntBits((float)this.x) + 53 * NumberUtils.floatToIntBits((float)this.y);
        return h ^ h >>> 16;
    }

    public void write(Json json) {
        json.writeValue("x", (Object)Float.valueOf(this.x), Float.TYPE);
        json.writeValue("y", (Object)Float.valueOf(this.y), Float.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getFloat("x");
        this.y = jsonData.getFloat("y");
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public PointF2 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        if (s0 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            float x = Float.parseFloat(s.substring(1, s0));
            float y = Float.parseFloat(s.substring(s0 + 1, s.length() - 1));
            return this.set(x, y);
        }
        throw new IllegalArgumentException("Not a valid format for a PointF2: " + s);
    }
}

