/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.GridPoint3;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.crux.Point3;
import java.util.Random;

public class PointF3
extends Vector3
implements Point3<PointF3>,
Json.Serializable {
    public PointF3() {
    }

    public PointF3(float x, float y, float z) {
        super(x, y, z);
    }

    public PointF3(Vector3 p) {
        super(p);
    }

    public PointF3(GridPoint3 p) {
        super((float)p.x, (float)p.y, (float)p.z);
    }

    public PointF3(PointF3 p) {
        super((Vector3)p);
    }

    public PointF3(Point3<? extends Point3<?>> p) {
        this(p.x(), p.y(), p.z());
    }

    public PointF3(float[] values) {
        super(values);
    }

    public PointF3(Vector2 vector, float z) {
        super(vector, z);
    }

    public boolean floatingPoint() {
        return true;
    }

    public PointF3 cpy() {
        return new PointF3(this);
    }

    public PointF3 set(PointF3 point) {
        super.set((Vector3)point);
        return this;
    }

    public PointF3 sub(PointF3 point) {
        super.sub((Vector3)point);
        return this;
    }

    public PointF3 add(PointF3 point) {
        super.add((Vector3)point);
        return this;
    }

    public PointF3 scl(PointF3 point) {
        super.scl((Vector3)point);
        return this;
    }

    public float dst(PointF3 point) {
        return super.dst((Vector3)point);
    }

    public float dst2(PointF3 point) {
        return super.dst2((Vector3)point);
    }

    public PointF3 setZero() {
        super.setZero();
        return this;
    }

    public float x() {
        return this.x;
    }

    public PointF3 x(float next) {
        this.x = next;
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointF3 y(float next) {
        this.y = next;
        return this;
    }

    public float z() {
        return this.z;
    }

    public PointF3 z(float next) {
        this.z = next;
        return this;
    }

    public PointF3 set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PointF3 set(Vector3 vector) {
        super.set(vector);
        return this;
    }

    public PointF3 set(float[] values) {
        super.set(values);
        return this;
    }

    public PointF3 set(Vector2 vector, float z) {
        super.set(vector, z);
        return this;
    }

    public PointF3 setFromSpherical(float azimuthalAngle, float polarAngle) {
        super.setFromSpherical(azimuthalAngle, polarAngle);
        return this;
    }

    public PointF3 setToRandomDirection() {
        return this.setToRandomDirection(MathUtils.random);
    }

    public PointF3 setToRandomDirection(Random random) {
        float u = random.nextFloat();
        float v = random.nextFloat();
        float theta = (float)Math.PI * 2 * u;
        float phi = MathUtils.acos((float)(2.0f * (v - 0.5f)));
        return this.setFromSpherical(theta, phi);
    }

    public PointF3 add(Vector3 vector) {
        super.add(vector);
        return this;
    }

    public PointF3 add(float x, float y, float z) {
        super.add(x, y, z);
        return this;
    }

    public PointF3 add(float values) {
        super.add(values);
        return this;
    }

    public PointF3 sub(Vector3 a_vec) {
        super.sub(a_vec);
        return this;
    }

    public PointF3 sub(float x, float y, float z) {
        super.sub(x, y, z);
        return this;
    }

    public PointF3 sub(float value) {
        super.sub(value);
        return this;
    }

    public PointF3 scl(float scalar) {
        super.scl(scalar);
        return this;
    }

    public PointF3 scl(Vector3 other) {
        super.scl(other);
        return this;
    }

    public PointF3 scl(float vx, float vy, float vz) {
        super.scl(vx, vy, vz);
        return this;
    }

    public PointF3 mulAdd(Vector3 vec, float scalar) {
        super.mulAdd(vec, scalar);
        return this;
    }

    public PointF3 mulAdd(Vector3 vec, Vector3 mulVec) {
        super.mulAdd(vec, mulVec);
        return this;
    }

    public PointF3 nor() {
        super.nor();
        return this;
    }

    public PointF3 crs(Vector3 vector) {
        super.crs(vector);
        return this;
    }

    public PointF3 crs(float x, float y, float z) {
        super.crs(x, y, z);
        return this;
    }

    public PointF3 mul4x3(float[] matrix) {
        super.mul4x3(matrix);
        return this;
    }

    public PointF3 mul(Matrix4 matrix) {
        super.mul(matrix);
        return this;
    }

    public PointF3 traMul(Matrix4 matrix) {
        super.traMul(matrix);
        return this;
    }

    public PointF3 mul(Matrix3 matrix) {
        super.mul(matrix);
        return this;
    }

    public PointF3 traMul(Matrix3 matrix) {
        super.traMul(matrix);
        return this;
    }

    public PointF3 mul(Quaternion quat) {
        super.mul(quat);
        return this;
    }

    public PointF3 prj(Matrix4 matrix) {
        super.prj(matrix);
        return this;
    }

    public PointF3 rot(Matrix4 matrix) {
        super.rot(matrix);
        return this;
    }

    public PointF3 unrotate(Matrix4 matrix) {
        super.unrotate(matrix);
        return this;
    }

    public PointF3 untransform(Matrix4 matrix) {
        super.untransform(matrix);
        return this;
    }

    public PointF3 rotate(float degrees, float axisX, float axisY, float axisZ) {
        super.rotate(degrees, axisX, axisY, axisZ);
        return this;
    }

    public PointF3 rotateRad(float radians, float axisX, float axisY, float axisZ) {
        super.rotateRad(radians, axisX, axisY, axisZ);
        return this;
    }

    public PointF3 rotate(Vector3 axis, float degrees) {
        super.rotate(axis, degrees);
        return this;
    }

    public PointF3 rotateRad(Vector3 axis, float radians) {
        super.rotateRad(axis, radians);
        return this;
    }

    public PointF3 lerp(Vector3 target, float alpha) {
        super.lerp(target, alpha);
        return this;
    }

    public PointF3 interpolate(Vector3 target, float alpha, Interpolation interpolator) {
        super.interpolate(target, alpha, interpolator);
        return this;
    }

    public PointF3 slerp(Vector3 target, float alpha) {
        super.slerp(target, alpha);
        return this;
    }

    public PointF3 limit(float limit) {
        super.limit(limit);
        return this;
    }

    public PointF3 setLength(float len) {
        super.setLength(len);
        return this;
    }

    public PointF3 limit2(float limit2) {
        super.limit2(limit2);
        return this;
    }

    public PointF3 setLength2(float len2) {
        super.setLength2(len2);
        return this;
    }

    public PointF3 clamp(float min, float max) {
        super.clamp(min, max);
        return this;
    }

    public PointF3 clampEach(float min, float max) {
        this.x = Math.min(Math.max(this.x, min), max);
        this.y = Math.min(Math.max(this.y, min), max);
        this.z = Math.min(Math.max(this.z, min), max);
        return this;
    }

    public PointF3 fract() {
        this.x -= (float)MathUtils.floor((float)this.x);
        this.y -= (float)MathUtils.floor((float)this.y);
        this.z -= (float)MathUtils.floor((float)this.z);
        return this;
    }

    public int hashCode() {
        int h = NumberUtils.floatToIntBits((float)this.x) + 53 * NumberUtils.floatToIntBits((float)this.y) + 113 * NumberUtils.floatToIntBits((float)this.z);
        return h ^ h >>> 16;
    }

    public void write(Json json) {
        json.writeValue("x", (Object)Float.valueOf(this.x), Float.TYPE);
        json.writeValue("y", (Object)Float.valueOf(this.y), Float.TYPE);
        json.writeValue("z", (Object)Float.valueOf(this.z), Float.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getFloat("x");
        this.y = jsonData.getFloat("y");
        this.z = jsonData.getFloat("z");
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public PointF3 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        int s1 = s.indexOf(44, s0 + 1);
        if (s0 != -1 && s1 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            float x = Float.parseFloat(s.substring(1, s0));
            float y = Float.parseFloat(s.substring(s0 + 1, s1));
            float z = Float.parseFloat(s.substring(s1 + 1, s.length() - 1));
            return this.set(x, y, z);
        }
        throw new IllegalArgumentException("Not a valid format for a PointF3: " + s);
    }
}

