/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.crux.Point4;
import com.github.tommyettinger.gdcrux.Distributor;
import java.util.Random;

public class PointF4
extends Vector4
implements Point4<PointF4>,
Json.Serializable {
    public PointF4() {
    }

    public PointF4(float x, float y, float z, float w) {
        super(x, y, z, w);
    }

    public PointF4(Vector4 p) {
        super(p);
    }

    public PointF4(PointF4 p) {
        super((Vector4)p);
    }

    public PointF4(Point4<? extends Point4<?>> p) {
        this(p.x(), p.y(), p.z(), p.w());
    }

    public PointF4(float[] values) {
        super(values);
    }

    public PointF4(Vector2 vector, float z, float w) {
        super(vector, z, w);
    }

    public PointF4(Vector3 vector, float w) {
        super(vector, w);
    }

    public boolean floatingPoint() {
        return true;
    }

    public PointF4 cpy() {
        return new PointF4(this);
    }

    public PointF4 set(PointF4 point) {
        super.set((Vector4)point);
        return this;
    }

    public PointF4 sub(PointF4 point) {
        super.sub((Vector4)point);
        return this;
    }

    public PointF4 add(PointF4 point) {
        super.add((Vector4)point);
        return this;
    }

    public PointF4 scl(PointF4 point) {
        super.scl((Vector4)point);
        return this;
    }

    public float dst(PointF4 point) {
        return super.dst((Vector4)point);
    }

    public float dst2(PointF4 point) {
        return super.dst2((Vector4)point);
    }

    public PointF4 setZero() {
        super.setZero();
        return this;
    }

    public float x() {
        return this.x;
    }

    public PointF4 x(float next) {
        this.x = next;
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointF4 y(float next) {
        this.y = next;
        return this;
    }

    public float z() {
        return this.z;
    }

    public PointF4 z(float next) {
        this.z = next;
        return this;
    }

    public float w() {
        return this.w;
    }

    public PointF4 w(float next) {
        this.w = next;
        return this;
    }

    public PointF4 set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public PointF4 set(Vector4 vector) {
        super.set(vector);
        return this;
    }

    public PointF4 set(float[] values) {
        super.set(values);
        return this;
    }

    public PointF4 set(Vector2 vector, float z, float w) {
        super.set(vector, z, w);
        return this;
    }

    public PointF4 set(Vector3 vector, float w) {
        super.set(vector, w);
        return this;
    }

    public PointF4 add(Vector4 vector) {
        super.add(vector);
        return this;
    }

    public PointF4 add(float x, float y, float z, float w) {
        super.add(x, y, z, w);
        return this;
    }

    public PointF4 add(float values) {
        super.add(values);
        return this;
    }

    public PointF4 sub(Vector4 a_vec) {
        super.sub(a_vec);
        return this;
    }

    public PointF4 sub(float x, float y, float z, float w) {
        super.sub(x, y, z, w);
        return this;
    }

    public PointF4 sub(float value) {
        super.sub(value);
        return this;
    }

    public PointF4 scl(float scalar) {
        super.scl(scalar);
        return this;
    }

    public PointF4 scl(Vector4 other) {
        super.scl(other);
        return this;
    }

    public PointF4 scl(float vx, float vy, float vz, float vw) {
        super.scl(vx, vy, vz, vw);
        return this;
    }

    public PointF4 mulAdd(Vector4 vec, float scalar) {
        super.mulAdd(vec, scalar);
        return this;
    }

    public PointF4 mulAdd(Vector4 vec, Vector4 mulVec) {
        super.mulAdd(vec, mulVec);
        return this;
    }

    public PointF4 nor() {
        super.nor();
        return this;
    }

    public PointF4 lerp(Vector4 target, float alpha) {
        super.lerp(target, alpha);
        return this;
    }

    public PointF4 interpolate(Vector4 target, float alpha, Interpolation interpolator) {
        super.interpolate(target, alpha, interpolator);
        return this;
    }

    public PointF4 limit(float limit) {
        super.limit(limit);
        return this;
    }

    public PointF4 limit2(float limit2) {
        super.limit2(limit2);
        return this;
    }

    public PointF4 setLength(float len) {
        super.setLength(len);
        return this;
    }

    public PointF4 setLength2(float len2) {
        super.setLength2(len2);
        return this;
    }

    public PointF4 clamp(float min, float max) {
        super.clamp(min, max);
        return this;
    }

    public PointF4 clampEach(float min, float max) {
        this.x = Math.min(Math.max(this.x, min), max);
        this.y = Math.min(Math.max(this.y, min), max);
        this.z = Math.min(Math.max(this.z, min), max);
        this.w = Math.min(Math.max(this.w, min), max);
        return this;
    }

    public PointF4 fract() {
        this.x -= (float)MathUtils.floor((float)this.x);
        this.y -= (float)MathUtils.floor((float)this.y);
        this.z -= (float)MathUtils.floor((float)this.z);
        this.w -= (float)MathUtils.floor((float)this.w);
        return this;
    }

    public PointF4 setToRandomDirection() {
        return this.setToRandomDirection(MathUtils.random);
    }

    public PointF4 setToRandomDirection(Random random) {
        return this.set(Distributor.normalF(random.nextInt()), Distributor.normalF(random.nextInt()), Distributor.normalF(random.nextInt()), Distributor.normalF(random.nextInt())).nor();
    }

    public int hashCode() {
        int h = NumberUtils.floatToIntBits((float)this.x) + 53 * NumberUtils.floatToIntBits((float)this.y) + 113 * NumberUtils.floatToIntBits((float)this.z) + 151 * NumberUtils.floatToIntBits((float)this.w);
        return h ^ h >>> 16;
    }

    public void write(Json json) {
        json.writeValue("x", (Object)Float.valueOf(this.x), Float.TYPE);
        json.writeValue("y", (Object)Float.valueOf(this.y), Float.TYPE);
        json.writeValue("z", (Object)Float.valueOf(this.z), Float.TYPE);
        json.writeValue("w", (Object)Float.valueOf(this.w), Float.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getFloat("x");
        this.y = jsonData.getFloat("y");
        this.z = jsonData.getFloat("z");
        this.w = jsonData.getFloat("w");
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.w + ")";
    }

    public PointF4 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        int s1 = s.indexOf(44, s0 + 1);
        int s2 = s.indexOf(44, s1 + 1);
        if (s0 != -1 && s1 != -1 && s2 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            float x = Float.parseFloat(s.substring(1, s0));
            float y = Float.parseFloat(s.substring(s0 + 1, s1));
            float z = Float.parseFloat(s.substring(s1 + 1, s2));
            float w = Float.parseFloat(s.substring(s2 + 1, s.length() - 1));
            return this.set(x, y, z, w);
        }
        throw new IllegalArgumentException("Not a valid format for a PointF4: " + s);
    }
}

