/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.crux.Point5;
import com.github.tommyettinger.gdcrux.Vector5;
import java.util.Random;

public class PointF5
extends Vector5
implements Point5<PointF5>,
Json.Serializable {
    public PointF5() {
    }

    public PointF5(float x, float y, float z, float w, float u) {
        super(x, y, z, w, u);
    }

    public PointF5(Vector5 p) {
        super(p);
    }

    public PointF5(PointF5 p) {
        super(p);
    }

    public PointF5(Point5<? extends Point5<?>> p) {
        this(p.x(), p.y(), p.z(), p.w(), p.u());
    }

    public PointF5(float[] values) {
        super(values);
    }

    public PointF5(Vector2 vector, float z, float w, float u) {
        super(vector, z, w, u);
    }

    public PointF5(Vector3 vector, float w, float u) {
        super(vector, w, u);
    }

    public PointF5(Vector4 vector, float u) {
        super(vector, u);
    }

    public boolean floatingPoint() {
        return true;
    }

    @Override
    public PointF5 cpy() {
        return new PointF5(this);
    }

    public PointF5 set(PointF5 point) {
        super.set(point);
        return this;
    }

    public PointF5 sub(PointF5 point) {
        super.sub(point);
        return this;
    }

    public PointF5 add(PointF5 point) {
        super.add(point);
        return this;
    }

    public PointF5 scl(PointF5 point) {
        super.scl(point);
        return this;
    }

    public float dst(PointF5 point) {
        return super.dst(point);
    }

    public float dst2(PointF5 point) {
        return super.dst2(point);
    }

    @Override
    public PointF5 setZero() {
        super.setZero();
        return this;
    }

    public float x() {
        return this.x;
    }

    public PointF5 x(float next) {
        this.x = next;
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointF5 y(float next) {
        this.y = next;
        return this;
    }

    public float z() {
        return this.z;
    }

    public PointF5 z(float next) {
        this.z = next;
        return this;
    }

    public float w() {
        return this.w;
    }

    public PointF5 w(float next) {
        this.w = next;
        return this;
    }

    public float u() {
        return this.u;
    }

    public PointF5 u(float next) {
        this.u = next;
        return this;
    }

    @Override
    public PointF5 set(float x, float y, float z, float w, float u) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.u = u;
        return this;
    }

    @Override
    public PointF5 set(Vector5 vector) {
        super.set(vector);
        return this;
    }

    @Override
    public PointF5 set(float[] values) {
        super.set(values);
        return this;
    }

    @Override
    public PointF5 set(Vector2 vector, float z, float w, float u) {
        super.set(vector, z, w, u);
        return this;
    }

    @Override
    public PointF5 set(Vector3 vector, float w, float u) {
        super.set(vector, w, u);
        return this;
    }

    @Override
    public PointF5 set(Vector4 vector, float u) {
        super.set(vector, u);
        return this;
    }

    @Override
    public PointF5 add(Vector5 vector) {
        super.add(vector);
        return this;
    }

    @Override
    public PointF5 add(float x, float y, float z, float w, float u) {
        super.add(x, y, z, w, u);
        return this;
    }

    @Override
    public PointF5 add(float value) {
        super.add(value);
        return this;
    }

    @Override
    public PointF5 sub(Vector5 vector) {
        super.sub(vector);
        return this;
    }

    @Override
    public PointF5 sub(float x, float y, float z, float w, float u) {
        super.sub(x, y, z, w, u);
        return this;
    }

    @Override
    public PointF5 sub(float value) {
        super.sub(value);
        return this;
    }

    @Override
    public PointF5 scl(float scalar) {
        super.scl(scalar);
        return this;
    }

    @Override
    public PointF5 scl(Vector5 other) {
        super.scl(other);
        return this;
    }

    @Override
    public PointF5 scl(float vx, float vy, float vz, float vw, float vu) {
        super.scl(vx, vy, vz, vw, vu);
        return this;
    }

    @Override
    public PointF5 mulAdd(Vector5 vec, float scalar) {
        super.mulAdd(vec, scalar);
        return this;
    }

    @Override
    public PointF5 mulAdd(Vector5 vec, Vector5 mulVec) {
        super.mulAdd(vec, mulVec);
        return this;
    }

    @Override
    public PointF5 nor() {
        super.nor();
        return this;
    }

    @Override
    public PointF5 lerp(Vector5 target, float alpha) {
        super.lerp(target, alpha);
        return this;
    }

    @Override
    public PointF5 interpolate(Vector5 target, float alpha, Interpolation interpolator) {
        super.interpolate(target, alpha, interpolator);
        return this;
    }

    @Override
    public PointF5 limit(float limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public PointF5 limit2(float limit2) {
        super.limit2(limit2);
        return this;
    }

    @Override
    public PointF5 setLength(float len) {
        super.setLength(len);
        return this;
    }

    @Override
    public PointF5 setLength2(float len2) {
        super.setLength2(len2);
        return this;
    }

    @Override
    public PointF5 clamp(float min, float max) {
        super.clamp(min, max);
        return this;
    }

    @Override
    public PointF5 setToRandomDirection() {
        super.setToRandomDirection();
        return this;
    }

    @Override
    public PointF5 setToRandomDirection(Random random) {
        super.setToRandomDirection(random);
        return this;
    }

    @Override
    public PointF5 clampEach(float min, float max) {
        super.clampEach(min, max);
        return this;
    }

    @Override
    public PointF5 fract() {
        super.fract();
        return this;
    }

    @Override
    public int hashCode() {
        int h = NumberUtils.floatToIntBits((float)this.x) + 53 * NumberUtils.floatToIntBits((float)this.y) + 113 * NumberUtils.floatToIntBits((float)this.z) + 151 * NumberUtils.floatToIntBits((float)this.w) + 211 * NumberUtils.floatToIntBits((float)this.u);
        return h ^ h >>> 16;
    }

    public void write(Json json) {
        json.writeValue("x", (Object)Float.valueOf(this.x), Float.TYPE);
        json.writeValue("y", (Object)Float.valueOf(this.y), Float.TYPE);
        json.writeValue("z", (Object)Float.valueOf(this.z), Float.TYPE);
        json.writeValue("w", (Object)Float.valueOf(this.w), Float.TYPE);
        json.writeValue("u", (Object)Float.valueOf(this.u), Float.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getFloat("x");
        this.y = jsonData.getFloat("y");
        this.z = jsonData.getFloat("z");
        this.w = jsonData.getFloat("w");
        this.u = jsonData.getFloat("u");
    }

    @Override
    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.w + "," + this.u + ")";
    }

    @Override
    public PointF5 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        int s1 = s.indexOf(44, s0 + 1);
        int s2 = s.indexOf(44, s1 + 1);
        int s3 = s.indexOf(44, s2 + 1);
        if (s0 != -1 && s1 != -1 && s2 != -1 && s3 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            float x = Float.parseFloat(s.substring(1, s0));
            float y = Float.parseFloat(s.substring(s0 + 1, s1));
            float z = Float.parseFloat(s.substring(s1 + 1, s2));
            float w = Float.parseFloat(s.substring(s2 + 1, s3));
            float u = Float.parseFloat(s.substring(s3 + 1, s.length() - 1));
            return this.set(x, y, z, w, u);
        }
        throw new IllegalArgumentException("Not a valid format for a PointF5: " + s);
    }
}

