/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.crux.Point2;

public class PointI2
extends GridPoint2
implements Point2<PointI2>,
Json.Serializable {
    public PointI2() {
    }

    public PointI2(int x, int y) {
        super(x, y);
    }

    public PointI2(float x, float y) {
        super(MathUtils.round((float)x), MathUtils.round((float)y));
    }

    public PointI2(GridPoint2 p) {
        super(p);
    }

    public PointI2(Vector2 p) {
        super(MathUtils.round((float)p.x), MathUtils.round((float)p.y));
    }

    public PointI2(PointI2 p) {
        super((GridPoint2)p);
    }

    public PointI2(Point2<? extends Point2<?>> p) {
        this(p.xi(), p.yi());
    }

    public boolean floatingPoint() {
        return false;
    }

    public PointI2 cpy() {
        return new PointI2(this);
    }

    public float len2() {
        return this.x * this.x + this.y * this.y;
    }

    public PointI2 set(PointI2 point) {
        super.set((GridPoint2)point);
        return this;
    }

    public PointI2 sub(PointI2 point) {
        super.sub((GridPoint2)point);
        return this;
    }

    public PointI2 add(PointI2 point) {
        super.add((GridPoint2)point);
        return this;
    }

    public PointI2 scl(PointI2 point) {
        this.x *= point.x;
        this.y *= point.y;
        return this;
    }

    public float dst(PointI2 point) {
        return super.dst((GridPoint2)point);
    }

    public float dst2(PointI2 point) {
        return super.dst2((GridPoint2)point);
    }

    public boolean isUnit() {
        return Math.abs(this.x) + Math.abs(this.y) == 1;
    }

    public boolean isUnit(float tolerance) {
        return MathUtils.isEqual((float)(Math.abs(this.x) + Math.abs(this.y)), (float)1.0f, (float)tolerance);
    }

    public boolean isZero() {
        return (this.x | this.y) == 0;
    }

    public boolean isZero(float tolerance) {
        return MathUtils.isZero((float)this.x, (float)tolerance) && MathUtils.isZero((float)this.y, (float)tolerance);
    }

    public PointI2 setZero() {
        this.set(0, 0);
        return this;
    }

    public float x() {
        return this.x;
    }

    public PointI2 x(float next) {
        this.x = MathUtils.round((float)next);
        return this;
    }

    public int xi() {
        return this.x;
    }

    public PointI2 xi(int next) {
        this.x = next;
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointI2 y(float next) {
        this.y = MathUtils.round((float)next);
        return this;
    }

    public int yi() {
        return this.y;
    }

    public PointI2 yi(int next) {
        this.y = next;
        return this;
    }

    public PointI2 set(float x, float y) {
        this.x = MathUtils.round((float)x);
        this.y = MathUtils.round((float)y);
        return this;
    }

    public PointI2 seti(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public PointI2 set(GridPoint2 point) {
        super.set(point);
        return this;
    }

    public PointI2 set(int x, int y) {
        return this.seti(x, y);
    }

    public PointI2 set(Point2<?> pt) {
        this.x = pt.xi();
        this.y = pt.yi();
        return this;
    }

    public PointI2 add(GridPoint2 other) {
        super.add(other);
        return this;
    }

    public PointI2 add(int x, int y) {
        super.add(x, y);
        return this;
    }

    public PointI2 sub(GridPoint2 other) {
        super.sub(other);
        return this;
    }

    public PointI2 sub(int x, int y) {
        super.sub(x, y);
        return this;
    }

    public int hashCode() {
        return this.x * 1583093 ^ this.y * 1195041;
    }

    public void write(Json json) {
        json.writeValue("x", (Object)this.x, Integer.TYPE);
        json.writeValue("y", (Object)this.y, Integer.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getInt("x");
        this.y = jsonData.getInt("y");
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public PointI2 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        if (s0 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            int x = Integer.parseInt(s.substring(1, s0));
            int y = Integer.parseInt(s.substring(s0 + 1, s.length() - 1));
            return this.set(x, y);
        }
        throw new IllegalArgumentException("Not a valid format for a PointI2: " + s);
    }
}

