/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.GridPoint3;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.crux.Point3;

public class PointI3
extends GridPoint3
implements Point3<PointI3>,
Json.Serializable {
    public PointI3() {
    }

    public PointI3(int x, int y, int z) {
        super(x, y, z);
    }

    public PointI3(float x, float y, float z) {
        super(MathUtils.round((float)x), MathUtils.round((float)y), MathUtils.round((float)z));
    }

    public PointI3(GridPoint3 p) {
        super(p);
    }

    public PointI3(Vector3 p) {
        super(MathUtils.round((float)p.x), MathUtils.round((float)p.y), MathUtils.round((float)p.z));
    }

    public PointI3(PointI3 p) {
        super((GridPoint3)p);
    }

    public PointI3(Point3<? extends Point3<?>> p) {
        this(p.xi(), p.yi(), p.zi());
    }

    public boolean floatingPoint() {
        return false;
    }

    public PointI3 cpy() {
        return new PointI3(this);
    }

    public float len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public PointI3 set(PointI3 point) {
        super.set((GridPoint3)point);
        return this;
    }

    public PointI3 sub(PointI3 point) {
        super.sub((GridPoint3)point);
        return this;
    }

    public PointI3 add(PointI3 point) {
        super.add((GridPoint3)point);
        return this;
    }

    public PointI3 scl(PointI3 point) {
        this.x *= point.x;
        this.y *= point.y;
        this.z *= point.z;
        return this;
    }

    public float dst(PointI3 point) {
        return super.dst((GridPoint3)point);
    }

    public float dst2(PointI3 point) {
        return super.dst2((GridPoint3)point);
    }

    public boolean isUnit() {
        return Math.abs(this.x) + Math.abs(this.y) + Math.abs(this.z) == 1;
    }

    public boolean isUnit(float tolerance) {
        return MathUtils.isEqual((float)(Math.abs(this.x) + Math.abs(this.y) + Math.abs(this.z)), (float)1.0f, (float)tolerance);
    }

    public boolean isZero() {
        return (this.x | this.y | this.z) == 0;
    }

    public boolean isZero(float tolerance) {
        return MathUtils.isZero((float)this.x, (float)tolerance) && MathUtils.isZero((float)this.y, (float)tolerance) && MathUtils.isZero((float)this.z, (float)tolerance);
    }

    public PointI3 setZero() {
        this.set(0, 0, 0);
        return this;
    }

    public float x() {
        return this.x;
    }

    public PointI3 x(float next) {
        this.x = MathUtils.round((float)next);
        return this;
    }

    public int xi() {
        return this.x;
    }

    public PointI3 xi(int next) {
        this.x = next;
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointI3 y(float next) {
        this.y = MathUtils.round((float)next);
        return this;
    }

    public int yi() {
        return this.y;
    }

    public PointI3 yi(int next) {
        this.y = next;
        return this;
    }

    public float z() {
        return this.z;
    }

    public PointI3 z(float next) {
        this.z = MathUtils.round((float)next);
        return this;
    }

    public int zi() {
        return this.z;
    }

    public PointI3 zi(int next) {
        this.z = next;
        return this;
    }

    public int hashCode() {
        return this.x * 1717929 ^ this.y * 1407281 ^ this.z * 1152805;
    }

    public PointI3 set(float x, float y, float z) {
        this.x = MathUtils.round((float)x);
        this.y = MathUtils.round((float)y);
        this.z = MathUtils.round((float)z);
        return this;
    }

    public PointI3 seti(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PointI3 set(GridPoint3 point) {
        super.set(point);
        return this;
    }

    public PointI3 set(int x, int y, int z) {
        return this.seti(x, y, z);
    }

    public PointI3 set(Point3<?> pt) {
        this.x = pt.xi();
        this.y = pt.yi();
        this.z = pt.zi();
        return this;
    }

    public PointI3 add(GridPoint3 other) {
        super.add(other);
        return this;
    }

    public PointI3 add(int x, int y, int z) {
        super.add(x, y, z);
        return this;
    }

    public PointI3 sub(GridPoint3 other) {
        super.sub(other);
        return this;
    }

    public PointI3 sub(int x, int y, int z) {
        super.sub(x, y, z);
        return this;
    }

    public void write(Json json) {
        json.writeValue("x", (Object)this.x, Integer.TYPE);
        json.writeValue("y", (Object)this.y, Integer.TYPE);
        json.writeValue("z", (Object)this.z, Integer.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getInt("x");
        this.y = jsonData.getInt("y");
        this.z = jsonData.getInt("z");
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public PointI3 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        int s1 = s.indexOf(44, s0 + 1);
        if (s0 != -1 && s1 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            int x = Integer.parseInt(s.substring(1, s0));
            int y = Integer.parseInt(s.substring(s0 + 1, s1));
            int z = Integer.parseInt(s.substring(s1 + 1, s.length() - 1));
            return this.set(x, y, z);
        }
        throw new IllegalArgumentException("Not a valid format for a PointI3: " + s);
    }
}

