/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.crux.Point4;

public class PointI4
implements Point4<PointI4>,
Json.Serializable {
    public int x;
    public int y;
    public int z;
    public int w;

    public PointI4() {
    }

    public PointI4(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public PointI4(float x, float y, float z, float w) {
        this(MathUtils.round((float)x), MathUtils.round((float)y), MathUtils.round((float)z), MathUtils.round((float)w));
    }

    public PointI4(Vector4 p) {
        this(MathUtils.round((float)p.x), MathUtils.round((float)p.y), MathUtils.round((float)p.z), MathUtils.round((float)p.w));
    }

    public PointI4(PointI4 p) {
        this(p.x, p.y, p.z, p.w);
    }

    public PointI4(Point4<? extends Point4<?>> p) {
        this(p.xi(), p.yi(), p.zi(), p.zi());
    }

    public float x() {
        return this.x;
    }

    public PointI4 x(float f) {
        this.x = MathUtils.round((float)f);
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointI4 y(float f) {
        this.y = MathUtils.round((float)f);
        return this;
    }

    public float z() {
        return this.z;
    }

    public PointI4 z(float f) {
        this.z = MathUtils.round((float)f);
        return this;
    }

    public float w() {
        return this.w;
    }

    public PointI4 w(float f) {
        this.w = MathUtils.round((float)f);
        return this;
    }

    public int xi() {
        return this.x;
    }

    public PointI4 xi(int next) {
        this.x = next;
        return this;
    }

    public int yi() {
        return this.y;
    }

    public PointI4 yi(int next) {
        this.y = next;
        return this;
    }

    public int zi() {
        return this.z;
    }

    public PointI4 zi(int next) {
        this.z = next;
        return this;
    }

    public int wi() {
        return this.w;
    }

    public PointI4 wi(int next) {
        this.w = next;
        return this;
    }

    public PointI4 set(float fx, float fy, float fz, float fw) {
        this.x = MathUtils.round((float)fx);
        this.y = MathUtils.round((float)fy);
        this.z = MathUtils.round((float)fz);
        this.w = MathUtils.round((float)fw);
        return this;
    }

    public PointI4 seti(int ix, int iy, int iz, int iw) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.w = iw;
        return this;
    }

    public boolean floatingPoint() {
        return false;
    }

    public boolean mutable() {
        return true;
    }

    public PointI4 cpy() {
        return new PointI4(this.x, this.y, this.z, this.w);
    }

    public float len2() {
        return (float)this.x * (float)this.x + (float)(this.y * this.y) + (float)(this.z * this.z) + (float)(this.w * this.w);
    }

    public PointI4 set(PointI4 pt) {
        this.x = pt.x;
        this.y = pt.y;
        this.z = pt.z;
        this.w = pt.w;
        return this;
    }

    public PointI4 setZero() {
        this.w = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        return this;
    }

    public PointI4 sub(PointI4 pt) {
        this.x -= pt.x;
        this.y -= pt.y;
        this.z -= pt.z;
        this.w -= pt.w;
        return this;
    }

    public PointI4 sub(int ox, int oy, int oz, int ow) {
        this.x -= ox;
        this.y -= oy;
        this.z -= oz;
        this.w -= ow;
        return this;
    }

    public PointI4 sub(int value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        this.w -= value;
        return this;
    }

    public PointI4 add(PointI4 pt) {
        this.x += pt.x;
        this.y += pt.y;
        this.z += pt.z;
        this.w += pt.w;
        return this;
    }

    public PointI4 add(int ox, int oy, int oz, int ow) {
        this.x += ox;
        this.y += oy;
        this.z += oz;
        this.w += ow;
        return this;
    }

    public PointI4 add(int value) {
        this.x += value;
        this.y += value;
        this.z += value;
        this.w += value;
        return this;
    }

    public PointI4 scl(PointI4 pt) {
        this.x *= pt.x;
        this.y *= pt.y;
        this.z *= pt.z;
        this.w *= pt.w;
        return this;
    }

    public PointI4 scl(int value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        this.w *= value;
        return this;
    }

    public PointI4 scl(int ox, int oy, int oz, int ow) {
        this.x *= ox;
        this.y *= oy;
        this.z *= oz;
        this.w *= ow;
        return this;
    }

    public float dst2(PointI4 pt) {
        float x = pt.x - this.x;
        float y = pt.y - this.y;
        float z = pt.z - this.z;
        float w = pt.w - this.w;
        return x * x + y * y + z * z + w * w;
    }

    public float dst2(int ox, int oy, int oz, int ow) {
        float x = ox - this.x;
        float y = oy - this.y;
        float z = oz - this.z;
        float w = ow - this.w;
        return x * x + y * y + z * z + w * w;
    }

    public float dst(int ox, int oy, int oz, int ow) {
        return (float)Math.sqrt(this.dst2(ox, oy, oz, ow));
    }

    public void write(Json json) {
        json.writeValue("x", (Object)this.x, Integer.TYPE);
        json.writeValue("y", (Object)this.y, Integer.TYPE);
        json.writeValue("z", (Object)this.z, Integer.TYPE);
        json.writeValue("w", (Object)this.w, Integer.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getInt("x");
        this.y = jsonData.getInt("y");
        this.z = jsonData.getInt("z");
        this.w = jsonData.getInt("w");
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.w + ")";
    }

    public PointI4 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        int s1 = s.indexOf(44, s0 + 1);
        int s2 = s.indexOf(44, s1 + 1);
        if (s0 != -1 && s1 != -1 && s2 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            int x = Integer.parseInt(s.substring(1, s0));
            int y = Integer.parseInt(s.substring(s0 + 1, s1));
            int z = Integer.parseInt(s.substring(s1 + 1, s2));
            int w = Integer.parseInt(s.substring(s2 + 1, s.length() - 1));
            return this.set(x, y, z, w);
        }
        throw new IllegalArgumentException("Not a valid format for a PointI4: " + s);
    }
}

