/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.github.tommyettinger.crux.Point6;

public class PointI6
implements Point6<PointI6>,
Json.Serializable {
    public int x;
    public int y;
    public int z;
    public int w;
    public int u;
    public int v;

    public PointI6() {
    }

    public PointI6(int x, int y, int z, int w, int u, int v) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.u = u;
        this.v = v;
    }

    public PointI6(float x, float y, float z, float w, float u, float v) {
        this(MathUtils.round((float)x), MathUtils.round((float)y), MathUtils.round((float)z), MathUtils.round((float)w), MathUtils.round((float)u), MathUtils.round((float)v));
    }

    public PointI6(PointI6 p) {
        this(p.x, p.y, p.z, p.w, p.u, p.v);
    }

    public PointI6(Point6<? extends Point6<?>> p) {
        this(p.xi(), p.yi(), p.zi(), p.zi(), p.ui(), p.vi());
    }

    public float x() {
        return this.x;
    }

    public PointI6 x(float f) {
        this.x = MathUtils.round((float)f);
        return this;
    }

    public float y() {
        return this.y;
    }

    public PointI6 y(float f) {
        this.y = MathUtils.round((float)f);
        return this;
    }

    public float z() {
        return this.z;
    }

    public PointI6 z(float f) {
        this.z = MathUtils.round((float)f);
        return this;
    }

    public float w() {
        return this.w;
    }

    public PointI6 w(float f) {
        this.w = MathUtils.round((float)f);
        return this;
    }

    public float u() {
        return this.u;
    }

    public PointI6 u(float f) {
        this.u = MathUtils.round((float)f);
        return this;
    }

    public float v() {
        return this.v;
    }

    public PointI6 v(float f) {
        this.v = MathUtils.round((float)f);
        return this;
    }

    public int xi() {
        return this.x;
    }

    public PointI6 xi(int next) {
        this.x = next;
        return this;
    }

    public int yi() {
        return this.y;
    }

    public PointI6 yi(int next) {
        this.y = next;
        return this;
    }

    public int zi() {
        return this.z;
    }

    public PointI6 zi(int next) {
        this.z = next;
        return this;
    }

    public int wi() {
        return this.w;
    }

    public PointI6 wi(int next) {
        this.w = next;
        return this;
    }

    public int ui() {
        return this.u;
    }

    public PointI6 ui(int next) {
        this.u = next;
        return this;
    }

    public int vi() {
        return this.v;
    }

    public PointI6 vi(int next) {
        this.v = next;
        return this;
    }

    public PointI6 set(float fx, float fy, float fz, float fw, float fu, float fv) {
        this.x = MathUtils.round((float)fx);
        this.y = MathUtils.round((float)fy);
        this.z = MathUtils.round((float)fz);
        this.w = MathUtils.round((float)fw);
        this.u = MathUtils.round((float)fu);
        this.v = MathUtils.round((float)fv);
        return this;
    }

    public PointI6 seti(int ix, int iy, int iz, int iw, int iu, int iv) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.w = iw;
        this.u = iu;
        this.v = iv;
        return this;
    }

    public boolean floatingPoint() {
        return false;
    }

    public boolean mutable() {
        return true;
    }

    public PointI6 cpy() {
        return new PointI6(this.x, this.y, this.z, this.w, this.u, this.v);
    }

    public float len2() {
        return (float)this.x * (float)this.x + (float)(this.y * this.y) + (float)(this.z * this.z) + (float)(this.w * this.w) + (float)(this.u * this.u) + (float)(this.v * this.v);
    }

    public PointI6 set(PointI6 pt) {
        this.x = pt.x;
        this.y = pt.y;
        this.z = pt.z;
        this.w = pt.w;
        this.u = pt.u;
        this.v = pt.v;
        return this;
    }

    public PointI6 setZero() {
        this.v = 0;
        this.u = 0;
        this.w = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        return this;
    }

    public PointI6 sub(PointI6 pt) {
        this.x -= pt.x;
        this.y -= pt.y;
        this.z -= pt.z;
        this.w -= pt.w;
        this.u -= pt.u;
        this.v -= pt.v;
        return this;
    }

    public PointI6 sub(int ox, int oy, int oz, int ow, int ou, int ov) {
        this.x -= ox;
        this.y -= oy;
        this.z -= oz;
        this.w -= ow;
        this.u -= ou;
        this.v -= ov;
        return this;
    }

    public PointI6 sub(int value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        this.w -= value;
        this.u -= value;
        this.v -= value;
        return this;
    }

    public PointI6 add(PointI6 pt) {
        this.x += pt.x;
        this.y += pt.y;
        this.z += pt.z;
        this.w += pt.w;
        this.u += pt.u;
        this.v += pt.v;
        return this;
    }

    public PointI6 add(int ox, int oy, int oz, int ow, int ou, int ov) {
        this.x += ox;
        this.y += oy;
        this.z += oz;
        this.w += ow;
        this.u += ou;
        this.v += ov;
        return this;
    }

    public PointI6 add(int value) {
        this.x += value;
        this.y += value;
        this.z += value;
        this.w += value;
        this.u += value;
        this.v += value;
        return this;
    }

    public PointI6 scl(PointI6 pt) {
        this.x *= pt.x;
        this.y *= pt.y;
        this.z *= pt.z;
        this.w *= pt.w;
        this.u *= pt.u;
        this.v *= pt.v;
        return this;
    }

    public PointI6 scl(int value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        this.w *= value;
        this.u *= value;
        this.v *= value;
        return this;
    }

    public PointI6 scl(int ox, int oy, int oz, int ow, int ou, int ov) {
        this.x *= ox;
        this.y *= oy;
        this.z *= oz;
        this.w *= ow;
        this.u *= ou;
        this.v *= ov;
        return this;
    }

    public float dst2(PointI6 pt) {
        float x = pt.x - this.x;
        float y = pt.y - this.y;
        float z = pt.z - this.z;
        float w = pt.w - this.w;
        float u = pt.u - this.u;
        float v = pt.v - this.v;
        return x * x + y * y + z * z + w * w + u * u + v * v;
    }

    public float dst2(int ox, int oy, int oz, int ow, int ou, int ov) {
        float x = ox - this.x;
        float y = oy - this.y;
        float z = oz - this.z;
        float w = ow - this.w;
        float u = ou - this.u;
        float v = ov - this.v;
        return x * x + y * y + z * z + w * w + u * u + v * v;
    }

    public float dst(int ox, int oy, int oz, int ow, int ou, int ov) {
        return (float)Math.sqrt(this.dst2(ox, oy, oz, ow, ou, ov));
    }

    public void write(Json json) {
        json.writeValue("x", (Object)this.x, Integer.TYPE);
        json.writeValue("y", (Object)this.y, Integer.TYPE);
        json.writeValue("z", (Object)this.z, Integer.TYPE);
        json.writeValue("w", (Object)this.w, Integer.TYPE);
        json.writeValue("u", (Object)this.u, Integer.TYPE);
        json.writeValue("v", (Object)this.v, Integer.TYPE);
    }

    public void read(Json json, JsonValue jsonData) {
        this.x = jsonData.getInt("x");
        this.y = jsonData.getInt("y");
        this.z = jsonData.getInt("z");
        this.w = jsonData.getInt("w");
        this.u = jsonData.getInt("u");
        this.v = jsonData.getInt("v");
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.w + "," + this.u + "," + this.v + ")";
    }

    public PointI6 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        int s1 = s.indexOf(44, s0 + 1);
        int s2 = s.indexOf(44, s1 + 1);
        int s3 = s.indexOf(44, s2 + 1);
        int s4 = s.indexOf(44, s3 + 1);
        if (s0 != -1 && s1 != -1 && s2 != -1 && s3 != -1 && s4 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            int x = Integer.parseInt(s.substring(1, s0));
            int y = Integer.parseInt(s.substring(s0 + 1, s1));
            int z = Integer.parseInt(s.substring(s1 + 1, s2));
            int w = Integer.parseInt(s.substring(s2 + 1, s3));
            int u = Integer.parseInt(s.substring(s3 + 1, s4));
            int v = Integer.parseInt(s.substring(s4 + 1, s.length() - 1));
            return this.set(x, y, z, w, u, v);
        }
        throw new IllegalArgumentException("Not a valid format for a PointI6: " + s);
    }
}

