/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.gdcrux;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.gdcrux.Distributor;
import java.util.Random;

public class Vector5
implements Vector<Vector5> {
    public float x;
    public float y;
    public float z;
    public float w;
    public float u;
    public static final Vector5 X = new Vector5(1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector5 Y = new Vector5(0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector5 Z = new Vector5(0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector5 W = new Vector5(0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector5 U = new Vector5(0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector5 Zero = new Vector5(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);

    public Vector5() {
    }

    public Vector5(float x, float y, float z, float w, float u) {
        this.set(x, y, z, w, u);
    }

    public Vector5(Vector5 vector) {
        this.set(vector.x, vector.y, vector.z, vector.w, vector.u);
    }

    public Vector5(float[] values) {
        this.set(values[0], values[1], values[2], values[3], values[4]);
    }

    public Vector5(Vector2 vector, float z, float w, float u) {
        this.set(vector.x, vector.y, z, w, u);
    }

    public Vector5(Vector3 vector, float w, float u) {
        this.set(vector.x, vector.y, vector.z, w, u);
    }

    public Vector5(Vector4 vector, float u) {
        this.set(vector.x, vector.y, vector.z, vector.w, u);
    }

    public Vector5 set(float x, float y, float z, float w, float u) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.u = u;
        return this;
    }

    public Vector5 set(Vector5 vector) {
        return this.set(vector.x, vector.y, vector.z, vector.w, vector.u);
    }

    public Vector5 set(float[] values) {
        return this.set(values[0], values[1], values[2], values[3], values[4]);
    }

    public Vector5 set(Vector2 vector, float z, float w, float u) {
        return this.set(vector.x, vector.y, z, w, u);
    }

    public Vector5 set(Vector3 vector, float w, float u) {
        return this.set(vector.x, vector.y, vector.z, w, u);
    }

    public Vector5 set(Vector4 vector, float u) {
        return this.set(vector.x, vector.y, vector.z, vector.w, u);
    }

    public Vector5 setToRandomDirection() {
        return this.setToRandomDirection(MathUtils.random);
    }

    public Vector5 setToRandomDirection(Random random) {
        this.x = Distributor.normalF(random.nextInt());
        this.y = Distributor.normalF(random.nextInt());
        this.z = Distributor.normalF(random.nextInt());
        this.w = Distributor.normalF(random.nextInt());
        this.u = Distributor.normalF(random.nextInt());
        return this.nor();
    }

    public Vector5 cpy() {
        return new Vector5(this);
    }

    public Vector5 add(Vector5 vector) {
        return this.add(vector.x, vector.y, vector.z, vector.w, vector.u);
    }

    public Vector5 add(float x, float y, float z, float w, float u) {
        return this.set(this.x + x, this.y + y, this.z + z, this.w + w, this.u + u);
    }

    public Vector5 add(float value) {
        return this.set(this.x + value, this.y + value, this.z + value, this.w + value, this.u + value);
    }

    public Vector5 sub(Vector5 vector) {
        return this.sub(vector.x, vector.y, vector.z, vector.w, vector.u);
    }

    public Vector5 sub(float x, float y, float z, float w, float u) {
        return this.set(this.x - x, this.y - y, this.z - z, this.w - w, this.u - u);
    }

    public Vector5 sub(float value) {
        return this.set(this.x - value, this.y - value, this.z - value, this.w - value, this.u - value);
    }

    public Vector5 scl(float scalar) {
        return this.set(this.x * scalar, this.y * scalar, this.z * scalar, this.w * scalar, this.u * scalar);
    }

    public Vector5 scl(Vector5 other) {
        return this.set(this.x * other.x, this.y * other.y, this.z * other.z, this.w * other.w, this.u * other.u);
    }

    public Vector5 scl(float vx, float vy, float vz, float vw, float vu) {
        return this.set(this.x * vx, this.y * vy, this.z * vz, this.w * vw, this.w * vu);
    }

    public Vector5 mulAdd(Vector5 vec, float scalar) {
        this.x += vec.x * scalar;
        this.y += vec.y * scalar;
        this.z += vec.z * scalar;
        this.w += vec.w * scalar;
        this.u += vec.u * scalar;
        return this;
    }

    public Vector5 mulAdd(Vector5 vec, Vector5 mulVec) {
        this.x += vec.x * mulVec.x;
        this.y += vec.y * mulVec.y;
        this.z += vec.z * mulVec.z;
        this.w += vec.w * mulVec.w;
        this.u += vec.u * mulVec.u;
        return this;
    }

    public static float len(float x, float y, float z, float w, float u) {
        return (float)Math.sqrt(x * x + y * y + z * z + w * w + u * u);
    }

    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w + this.u * this.u);
    }

    public static float len2(float x, float y, float z, float w, float u) {
        return x * x + y * y + z * z + w * w + u * u;
    }

    public float len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w + this.u * this.u;
    }

    public boolean idt(Vector5 vector) {
        return this.x == vector.x && this.y == vector.y && this.z == vector.z && this.w == vector.w && this.u == vector.u;
    }

    public static float dst(float x1, float y1, float z1, float w1, float u1, float x2, float y2, float z2, float w2, float u2) {
        float a = x2 - x1;
        float b = y2 - y1;
        float c = z2 - z1;
        float d = w2 - w1;
        float e = u2 - u1;
        return (float)Math.sqrt(a * a + b * b + c * c + d * d + e * e);
    }

    public float dst(Vector5 vector) {
        float a = vector.x - this.x;
        float b = vector.y - this.y;
        float c = vector.z - this.z;
        float d = vector.w - this.w;
        float e = vector.u - this.u;
        return (float)Math.sqrt(a * a + b * b + c * c + d * d + e * e);
    }

    public float dst(float x, float y, float z, float w, float u) {
        float a = x - this.x;
        float b = y - this.y;
        float c = z - this.z;
        float d = w - this.w;
        float e = u - this.u;
        return (float)Math.sqrt(a * a + b * b + c * c + d * d + e * e);
    }

    public static float dst2(float x1, float y1, float z1, float w1, float u1, float x2, float y2, float z2, float w2, float u2) {
        float a = x2 - x1;
        float b = y2 - y1;
        float c = z2 - z1;
        float d = w2 - w1;
        float e = u2 - u1;
        return a * a + b * b + c * c + d * d + e * e;
    }

    public float dst2(Vector5 point) {
        float a = point.x - this.x;
        float b = point.y - this.y;
        float c = point.z - this.z;
        float d = point.w - this.w;
        float e = point.u - this.u;
        return a * a + b * b + c * c + d * d + e * e;
    }

    public float dst2(float x, float y, float z, float w, float u) {
        float a = x - this.x;
        float b = y - this.y;
        float c = z - this.z;
        float d = w - this.w;
        float e = u - this.u;
        return a * a + b * b + c * c + d * d + e * e;
    }

    public Vector5 nor() {
        float len2 = this.len2();
        if (len2 == 0.0f || len2 == 1.0f) {
            return this;
        }
        return this.scl(1.0f / (float)Math.sqrt(len2));
    }

    public static float dot(float x1, float y1, float z1, float w1, float u1, float x2, float y2, float z2, float w2, float u2) {
        return x1 * x2 + y1 * y2 + z1 * z2 + w1 * w2 + u1 * u2;
    }

    public float dot(Vector5 vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z + this.w * vector.w + this.u * vector.u;
    }

    public float dot(float x, float y, float z, float w, float u) {
        return this.x * x + this.y * y + this.z * z + this.w * w + this.u * u;
    }

    public boolean isUnit() {
        return this.isUnit(1.0E-9f);
    }

    public boolean isUnit(float margin) {
        return Math.abs(this.len2() - 1.0f) < margin;
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f && this.w == 0.0f && this.u == 0.0f;
    }

    public boolean isZero(float margin) {
        return this.len2() < margin;
    }

    public boolean isOnLine(Vector5 other, float epsilon) {
        int next;
        float left;
        int lowest;
        int flags = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        float dw = 0.0f;
        float du = 0.0f;
        if (MathUtils.isZero((float)this.x, (float)epsilon)) {
            if (!MathUtils.isZero((float)other.x, (float)epsilon)) {
                return false;
            }
        } else {
            dx = this.x / other.x;
            flags |= 1;
        }
        if (MathUtils.isZero((float)this.y, (float)epsilon)) {
            if (!MathUtils.isZero((float)other.y, (float)epsilon)) {
                return false;
            }
        } else {
            dy = this.y / other.y;
            flags |= 2;
        }
        if (MathUtils.isZero((float)this.z, (float)epsilon)) {
            if (!MathUtils.isZero((float)other.z, (float)epsilon)) {
                return false;
            }
        } else {
            dz = this.z / other.z;
            flags |= 4;
        }
        if (MathUtils.isZero((float)this.w, (float)epsilon)) {
            if (!MathUtils.isZero((float)other.w, (float)epsilon)) {
                return false;
            }
        } else {
            dw = this.w / other.w;
            flags |= 8;
        }
        if (MathUtils.isZero((float)this.u, (float)epsilon)) {
            if (!MathUtils.isZero((float)other.u, (float)epsilon)) {
                return false;
            }
        } else {
            du = this.u / other.u;
            flags |= 0x10;
        }
        if ((flags ^= (lowest = flags & -flags)) == 0) {
            return true;
        }
        boolean on = true;
        switch (lowest) {
            case 1: {
                left = dx;
                break;
            }
            case 2: {
                left = dy;
                break;
            }
            case 4: {
                left = dz;
                break;
            }
            default: {
                left = dw;
            }
        }
        do {
            next = flags & -flags;
            switch (next) {
                case 2: {
                    on &= MathUtils.isEqual((float)left, (float)dy, (float)epsilon);
                    break;
                }
                case 4: {
                    on &= MathUtils.isEqual((float)left, (float)dz, (float)epsilon);
                    break;
                }
                case 8: {
                    on &= MathUtils.isEqual((float)left, (float)dw, (float)epsilon);
                    break;
                }
                default: {
                    on &= MathUtils.isEqual((float)left, (float)du, (float)epsilon);
                }
            }
        } while ((flags ^= next) != 0);
        return on;
    }

    public boolean isOnLine(Vector5 other) {
        return this.isOnLine(other, 1.0E-6f);
    }

    public boolean isCollinear(Vector5 other, float epsilon) {
        return this.isOnLine(other, epsilon) && this.hasSameDirection(other);
    }

    public boolean isCollinear(Vector5 other) {
        return this.isOnLine(other) && this.hasSameDirection(other);
    }

    public boolean isCollinearOpposite(Vector5 other, float epsilon) {
        return this.isOnLine(other, epsilon) && this.hasOppositeDirection(other);
    }

    public boolean isCollinearOpposite(Vector5 other) {
        return this.isOnLine(other) && this.hasOppositeDirection(other);
    }

    public boolean isPerpendicular(Vector5 vector) {
        return MathUtils.isZero((float)this.dot(vector));
    }

    public boolean isPerpendicular(Vector5 vector, float epsilon) {
        return MathUtils.isZero((float)this.dot(vector), (float)epsilon);
    }

    public boolean hasSameDirection(Vector5 vector) {
        return this.dot(vector) > 0.0f;
    }

    public boolean hasOppositeDirection(Vector5 vector) {
        return this.dot(vector) < 0.0f;
    }

    public Vector5 lerp(Vector5 target, float alpha) {
        this.x += alpha * (target.x - this.x);
        this.y += alpha * (target.y - this.y);
        this.z += alpha * (target.z - this.z);
        this.w += alpha * (target.w - this.w);
        this.u += alpha * (target.u - this.u);
        return this;
    }

    public Vector5 interpolate(Vector5 target, float alpha, Interpolation interpolator) {
        return this.lerp(target, interpolator.apply(alpha));
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.w + "," + this.u + ")";
    }

    public Vector5 fromString(String s) {
        int s0 = s.indexOf(44, 1);
        int s1 = s.indexOf(44, s0 + 1);
        int s2 = s.indexOf(44, s1 + 1);
        int s3 = s.indexOf(44, s2 + 1);
        if (s0 != -1 && s1 != -1 && s2 != -1 && s3 != -1 && s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')') {
            try {
                float x = Float.parseFloat(s.substring(1, s0));
                float y = Float.parseFloat(s.substring(s0 + 1, s1));
                float z = Float.parseFloat(s.substring(s1 + 1, s2));
                float w = Float.parseFloat(s.substring(s2 + 1, s3));
                float u = Float.parseFloat(s.substring(s3 + 1, s.length() - 1));
                return this.set(x, y, z, w, u);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new GdxRuntimeException("Malformed Vector5: " + s);
    }

    public Vector5 limit(float limit) {
        return this.limit2(limit * limit);
    }

    public Vector5 limit2(float limit2) {
        float len2 = this.len2();
        if (len2 > limit2) {
            this.scl((float)Math.sqrt(limit2 / len2));
        }
        return this;
    }

    public Vector5 setLength(float len) {
        return this.setLength2(len * len);
    }

    public Vector5 setLength2(float len2) {
        float oldLen2 = this.len2();
        return oldLen2 == 0.0f || oldLen2 == len2 ? this : this.scl((float)Math.sqrt(len2 / oldLen2));
    }

    public Vector5 clamp(float min, float max) {
        float len2 = this.len2();
        if (len2 == 0.0f) {
            return this;
        }
        float max2 = max * max;
        if (len2 > max2) {
            return this.scl((float)Math.sqrt(max2 / len2));
        }
        float min2 = min * min;
        if (len2 < min2) {
            return this.scl((float)Math.sqrt(min2 / len2));
        }
        return this;
    }

    public Vector5 clampEach(float min, float max) {
        this.x = Math.min(Math.max(this.x, min), max);
        this.y = Math.min(Math.max(this.y, min), max);
        this.z = Math.min(Math.max(this.z, min), max);
        this.w = Math.min(Math.max(this.w, min), max);
        this.u = Math.min(Math.max(this.u, min), max);
        return this;
    }

    public Vector5 fract() {
        this.x -= (float)MathUtils.floor((float)this.x);
        this.y -= (float)MathUtils.floor((float)this.y);
        this.z -= (float)MathUtils.floor((float)this.z);
        this.w -= (float)MathUtils.floor((float)this.w);
        this.u -= (float)MathUtils.floor((float)this.u);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + NumberUtils.floatToIntBits((float)this.x);
        result = 31 * result + NumberUtils.floatToIntBits((float)this.y);
        result = 31 * result + NumberUtils.floatToIntBits((float)this.z);
        result = 31 * result + NumberUtils.floatToIntBits((float)this.w);
        result = 31 * result + NumberUtils.floatToIntBits((float)this.u);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector5 other = (Vector5)obj;
        if (NumberUtils.floatToIntBits((float)this.x) != NumberUtils.floatToIntBits((float)other.x)) {
            return false;
        }
        if (NumberUtils.floatToIntBits((float)this.y) != NumberUtils.floatToIntBits((float)other.y)) {
            return false;
        }
        if (NumberUtils.floatToIntBits((float)this.z) != NumberUtils.floatToIntBits((float)other.z)) {
            return false;
        }
        if (NumberUtils.floatToIntBits((float)this.w) != NumberUtils.floatToIntBits((float)other.w)) {
            return false;
        }
        return NumberUtils.floatToIntBits((float)this.u) == NumberUtils.floatToIntBits((float)other.u);
    }

    public boolean epsilonEquals(Vector5 other, float epsilon) {
        if (other == null) {
            return false;
        }
        if (Math.abs(other.x - this.x) > epsilon) {
            return false;
        }
        if (Math.abs(other.y - this.y) > epsilon) {
            return false;
        }
        if (Math.abs(other.z - this.z) > epsilon) {
            return false;
        }
        if (Math.abs(other.w - this.w) > epsilon) {
            return false;
        }
        return !(Math.abs(other.u - this.u) > epsilon);
    }

    public boolean epsilonEquals(float x, float y, float z, float w, float u, float epsilon) {
        if (Math.abs(x - this.x) > epsilon) {
            return false;
        }
        if (Math.abs(y - this.y) > epsilon) {
            return false;
        }
        if (Math.abs(z - this.z) > epsilon) {
            return false;
        }
        if (Math.abs(w - this.w) > epsilon) {
            return false;
        }
        return !(Math.abs(u - this.u) > epsilon);
    }

    public boolean epsilonEquals(Vector5 other) {
        return this.epsilonEquals(other, 1.0E-6f);
    }

    public boolean epsilonEquals(float x, float y, float z, float w, float u) {
        return this.epsilonEquals(x, y, z, w, u, 1.0E-6f);
    }

    public Vector5 setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
        this.u = 0.0f;
        return this;
    }
}

