/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.os.Handler;
import com.badlogic.gdx.audio.Sound;

public class AsynchronousSound
implements Sound {
    private final Sound sound;
    private final Handler handler;

    public AsynchronousSound(Sound sound, Handler handler) {
        this.sound = sound;
        this.handler = handler;
    }

    public long play() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AsynchronousSound.this.sound.play();
            }
        });
        return 0L;
    }

    public long play(final float volume) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AsynchronousSound.this.sound.play(volume);
            }
        });
        return 0L;
    }

    public long play(final float volume, final float pitch, final float pan) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AsynchronousSound.this.sound.play(volume, pitch, pan);
            }
        });
        return 0L;
    }

    public long loop() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AsynchronousSound.this.sound.loop();
            }
        });
        return 0L;
    }

    public long loop(final float volume) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AsynchronousSound.this.sound.loop(volume);
            }
        });
        return 0L;
    }

    public long loop(final float volume, final float pitch, final float pan) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AsynchronousSound.this.sound.loop(volume, pitch, pan);
            }
        });
        return 0L;
    }

    public void stop() {
        this.sound.stop();
    }

    public void pause() {
        this.sound.pause();
    }

    public void resume() {
        this.sound.resume();
    }

    public void dispose() {
        this.sound.dispose();
    }

    public void stop(long soundId) {
        throw new UnsupportedOperationException("Asynchronous audio doesn't support sound id based operations.");
    }

    public void pause(long soundId) {
        throw new UnsupportedOperationException("Asynchronous audio doesn't support sound id based operations.");
    }

    public void resume(long soundId) {
        throw new UnsupportedOperationException("Asynchronous audio doesn't support sound id based operations.");
    }

    public void setLooping(long soundId, boolean looping) {
        throw new UnsupportedOperationException("Asynchronous audio doesn't support sound id based operations.");
    }

    public void setPitch(long soundId, float pitch) {
        throw new UnsupportedOperationException("Asynchronous audio doesn't support sound id based operations.");
    }

    public void setVolume(long soundId, float volume) {
        throw new UnsupportedOperationException("Asynchronous audio doesn't support sound id based operations.");
    }

    public void setPan(long soundId, float pan, float volume) {
        throw new UnsupportedOperationException("Asynchronous audio doesn't support sound id based operations.");
    }
}

