/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.backends.gwt.GwtGL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsArrayBoolean;
import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.typedarrays.client.Uint8ArrayNative;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.typedarrays.shared.TypedArrays;
import com.google.gwt.typedarrays.shared.Uint32Array;
import com.google.gwt.webgl.client.WebGL2RenderingContext;
import com.google.gwt.webgl.client.WebGLBuffer;
import com.google.gwt.webgl.client.WebGLFramebuffer;
import com.google.gwt.webgl.client.WebGLProgram;
import com.google.gwt.webgl.client.WebGLQuery;
import com.google.gwt.webgl.client.WebGLSampler;
import com.google.gwt.webgl.client.WebGLTexture;
import com.google.gwt.webgl.client.WebGLTransformFeedback;
import com.google.gwt.webgl.client.WebGLUniformLocation;
import com.google.gwt.webgl.client.WebGLVertexArrayObject;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.HasArrayBufferView;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class GwtGL30
extends GwtGL20
implements GL30 {
    private final GwtGL20.IntMap<WebGLQuery> queries = GwtGL20.IntMap.create();
    private int nextQueryId = 1;
    private final GwtGL20.IntMap<WebGLSampler> samplers = GwtGL20.IntMap.create();
    private int nextSamplerId = 1;
    private final GwtGL20.IntMap<WebGLTransformFeedback> feedbacks = GwtGL20.IntMap.create();
    private int nextFeedbackId = 1;
    private final GwtGL20.IntMap<WebGLVertexArrayObject> vertexArrays = GwtGL20.IntMap.create();
    private int nextVertexArrayId = 1;
    private final Uint32Array uIntBuffer = TypedArrays.createUint32Array((int)12000);
    protected final WebGL2RenderingContext gl;

    protected GwtGL30(WebGL2RenderingContext gl) {
        super(gl);
        this.gl = gl;
    }

    private Uint32Array copyUnsigned(IntBuffer buffer) {
        if (GWT.isProdMode()) {
            return ((Uint32Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
        }
        this.ensureCapacity(buffer);
        int i = buffer.position();
        int j = 0;
        while (i < buffer.limit()) {
            this.uIntBuffer.set(j, (long)buffer.get(i));
            ++i;
            ++j;
        }
        return this.uIntBuffer.subarray(0, buffer.remaining());
    }

    private int allocateQueryId(WebGLQuery query) {
        int id = this.nextQueryId++;
        this.queries.put(id, query);
        return id;
    }

    private void deallocateQueryId(int id) {
        this.queries.remove(id);
    }

    private int allocateSamplerId(WebGLSampler query) {
        int id = this.nextSamplerId++;
        this.samplers.put(id, query);
        return id;
    }

    private void deallocateFeedbackId(int id) {
        this.feedbacks.remove(id);
    }

    private int allocateFeedbackId(WebGLTransformFeedback feedback) {
        int id = this.nextFeedbackId++;
        this.feedbacks.put(id, feedback);
        return id;
    }

    private void deallocateSamplerId(int id) {
        this.samplers.remove(id);
    }

    private int allocateVertexArrayId(WebGLVertexArrayObject vArray) {
        int id = this.nextVertexArrayId++;
        this.vertexArrays.put(id, vArray);
        return id;
    }

    private void deallocateVertexArrayId(int id) {
        this.vertexArrays.remove(id);
    }

    public void glBeginQuery(int target, int id) {
        this.gl.beginQuery(target, this.queries.get(id));
    }

    public void glBeginTransformFeedback(int primitiveMode) {
        this.gl.beginTransformFeedback(primitiveMode);
    }

    public void glBindBufferBase(int target, int index, int buffer) {
        this.gl.bindBufferBase(target, index, (WebGLBuffer)((Object)this.buffers.get(buffer)));
    }

    public void glBindBufferRange(int target, int index, int buffer, int offset, int size) {
        this.gl.bindBufferRange(target, index, (WebGLBuffer)((Object)this.buffers.get(buffer)), offset, size);
    }

    public void glBindSampler(int unit, int sampler) {
        this.gl.bindSampler(unit, this.samplers.get(sampler));
    }

    public void glBindTransformFeedback(int target, int id) {
        this.gl.bindTransformFeedback(target, this.feedbacks.get(id));
    }

    public void glBindVertexArray(int array) {
        this.gl.bindVertexArray(this.vertexArrays.get(array));
    }

    public void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        this.gl.blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }

    public void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil) {
        this.gl.clearBufferfi(buffer, drawbuffer, depth, stencil);
    }

    public void glClearBufferfv(int buffer, int drawbuffer, FloatBuffer value) {
        this.gl.clearBufferfv(buffer, drawbuffer, this.copy(value));
    }

    public void glClearBufferiv(int buffer, int drawbuffer, IntBuffer value) {
        this.gl.clearBufferiv(buffer, drawbuffer, this.copy(value));
    }

    public void glClearBufferuiv(int buffer, int drawbuffer, IntBuffer value) {
        this.gl.clearBufferuiv(buffer, drawbuffer, this.copy(value));
    }

    public void glCopyBufferSubData(int readTarget, int writeTarget, int readOffset, int writeOffset, int size) {
        this.gl.copyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
    }

    public void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        this.gl.copyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    public void glDeleteQueries(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            int id = ids[i];
            WebGLQuery query = this.queries.get(id);
            this.deallocateQueryId(id);
            this.gl.deleteQuery(query);
        }
    }

    public void glDeleteQueries(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            int id = ids.get();
            WebGLQuery query = this.queries.get(id);
            this.deallocateQueryId(id);
            this.gl.deleteQuery(query);
        }
        ids.position(startPosition);
    }

    public void glDeleteSamplers(int count, int[] samplers, int offset) {
        for (int i = offset; i < offset + count; ++i) {
            int id = samplers[i];
            WebGLSampler sampler = this.samplers.get(id);
            this.deallocateSamplerId(id);
            this.gl.deleteSampler(sampler);
        }
    }

    public void glDeleteSamplers(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            int id = ids.get();
            WebGLSampler sampler = this.samplers.get(id);
            this.deallocateSamplerId(id);
            this.gl.deleteSampler(sampler);
        }
        ids.position(startPosition);
    }

    public void glDeleteTransformFeedbacks(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            int id = ids[i];
            WebGLTransformFeedback feedback = this.feedbacks.get(id);
            this.deallocateFeedbackId(id);
            this.gl.deleteTransformFeedback(feedback);
        }
    }

    public void glDeleteTransformFeedbacks(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            int id = ids.get();
            WebGLTransformFeedback feedback = this.feedbacks.get(id);
            this.deallocateFeedbackId(id);
            this.gl.deleteTransformFeedback(feedback);
        }
        ids.position(startPosition);
    }

    public void glDeleteVertexArrays(int n, int[] arrays, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            int id = arrays[i];
            WebGLVertexArrayObject vArray = this.vertexArrays.get(id);
            this.deallocateVertexArrayId(id);
            this.gl.deleteVertexArray(vArray);
        }
    }

    public void glDeleteVertexArrays(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            int id = ids.get();
            WebGLVertexArrayObject vArray = this.vertexArrays.get(id);
            this.deallocateVertexArrayId(id);
            this.gl.deleteVertexArray(vArray);
        }
        ids.position(startPosition);
    }

    public void glDrawArraysInstanced(int mode, int first, int count, int instanceCount) {
        this.gl.drawArraysInstanced(mode, first, count, instanceCount);
    }

    public void glDrawBuffers(int n, IntBuffer bufs) {
        int startPosition = bufs.position();
        this.gl.drawBuffers(this.copy(bufs).subarray(0, n));
        bufs.position(startPosition);
    }

    public void glDrawElementsInstanced(int mode, int count, int type, int indicesOffset, int instanceCount) {
        this.gl.drawElementsInstanced(mode, count, type, indicesOffset, instanceCount);
    }

    public void glDrawRangeElements(int mode, int start, int end, int count, int type, Buffer indices) {
        this.gl.drawRangeElements(mode, start, end, count, type, indices.position());
    }

    public void glDrawRangeElements(int mode, int start, int end, int count, int type, int offset) {
        this.gl.drawRangeElements(mode, start, end, count, type, offset);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, int offset) {
        this.gl.texImage2D(target, level, internalformat, width, height, border, format, type, offset);
    }

    public void glEndQuery(int target) {
        this.gl.endQuery(target);
    }

    public void glEndTransformFeedback() {
        this.gl.endTransformFeedback();
    }

    public void glFlushMappedBufferRange(int target, int offset, int length) {
        throw new UnsupportedOperationException("glFlushMappedBufferRange not supported on WebGL2");
    }

    public void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer) {
        this.gl.framebufferTextureLayer(target, attachment, (WebGLTexture)((Object)this.textures.get(texture)), level, layer);
    }

    public void glGenQueries(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            int id;
            WebGLQuery query = this.gl.createQuery();
            ids[i] = id = this.allocateQueryId(query);
        }
    }

    public void glGenQueries(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            WebGLQuery query = this.gl.createQuery();
            int id = this.allocateQueryId(query);
            ids.put(id);
        }
        ids.position(startPosition);
    }

    public void glGenSamplers(int count, int[] samplers, int offset) {
        for (int i = offset; i < offset + count; ++i) {
            int id;
            WebGLSampler sampler = this.gl.createSampler();
            samplers[i] = id = this.allocateSamplerId(sampler);
        }
    }

    public void glGenSamplers(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            WebGLSampler sampler = this.gl.createSampler();
            int id = this.allocateSamplerId(sampler);
            ids.put(id);
        }
        ids.position(startPosition);
    }

    public void glGenTransformFeedbacks(int n, int[] ids, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            int id;
            WebGLTransformFeedback feedback = this.gl.createTransformFeedback();
            ids[i] = id = this.allocateFeedbackId(feedback);
        }
    }

    public void glGenTransformFeedbacks(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            WebGLTransformFeedback feedback = this.gl.createTransformFeedback();
            int id = this.allocateFeedbackId(feedback);
            ids.put(id);
        }
        ids.position(startPosition);
    }

    public void glGenVertexArrays(int n, int[] arrays, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            int id;
            WebGLVertexArrayObject vArray = this.gl.createVertexArray();
            arrays[i] = id = this.allocateVertexArrayId(vArray);
        }
    }

    public void glGenVertexArrays(int n, IntBuffer ids) {
        int startPosition = ids.position();
        for (int i = 0; i < n; ++i) {
            WebGLVertexArrayObject vArray = this.gl.createVertexArray();
            int id = this.allocateVertexArrayId(vArray);
            ids.put(id);
        }
        ids.position(startPosition);
    }

    public void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        if (pname == 35391 || pname == 35392 || pname == 35394) {
            params.put(this.gl.getActiveUniformBlockParameteri((WebGLProgram)((Object)this.programs.get(program)), uniformBlockIndex, pname));
        } else if (pname == 35395) {
            Uint32Array array = (Uint32Array)this.gl.getActiveUniformBlockParameterv((WebGLProgram)((Object)this.programs.get(program)), uniformBlockIndex, pname);
            for (int i = 0; i < array.length(); ++i) {
                params.put(i, (int)array.get(i));
            }
        } else if (pname == 35396 || pname == 35398) {
            boolean result = this.gl.getActiveUniformBlockParameterb((WebGLProgram)((Object)this.programs.get(program)), uniformBlockIndex, pname);
            params.put(result ? 1 : 0);
        } else {
            throw new GdxRuntimeException("Unsupported pname passed to glGetActiveUniformBlockiv");
        }
        params.flip();
    }

    public String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        return this.gl.getActiveUniformBlockName((WebGLProgram)((Object)this.programs.get(program)), uniformBlockIndex);
    }

    public void glGetActiveUniformBlockName(int program, int uniformBlockIndex, Buffer length, Buffer uniformBlockName) {
        throw new UnsupportedOperationException("glGetActiveUniformBlockName with Buffer parameters not supported on WebGL2");
    }

    public void glGetActiveUniformsiv(int program, int uniformCount, IntBuffer uniformIndices, int pname, IntBuffer params) {
        if (pname == 35390) {
            JsArrayBoolean arr = this.gl.getActiveUniformsb((WebGLProgram)((Object)this.programs.get(program)), this.copy(uniformIndices).subarray(0, uniformCount), pname);
            for (int i = 0; i < uniformCount; ++i) {
                params.put(i, arr.get(i) ? 1 : 0);
            }
        } else {
            JsArrayInteger arr = this.gl.getActiveUniformsi((WebGLProgram)((Object)this.programs.get(program)), this.copy(uniformIndices).subarray(0, uniformCount), pname);
            for (int i = 0; i < uniformCount; ++i) {
                params.put(i, arr.get(i));
            }
        }
        params.flip();
    }

    public void glGetBufferParameteri64v(int target, int pname, LongBuffer params) {
        throw new UnsupportedOperationException("glGetBufferParameteri64v not supported on WebGL2");
    }

    public Buffer glGetBufferPointerv(int target, int pname) {
        throw new UnsupportedOperationException("glGetBufferPointerv not supported on WebGL2");
    }

    @Override
    public void glGetFloatv(int pname, FloatBuffer params) {
        if (pname == 34045) {
            params.put(0, this.gl.getParameterf(pname));
            params.flip();
        } else {
            super.glGetFloatv(pname, params);
        }
    }

    public int glGetFragDataLocation(int program, String name) {
        return this.gl.getFragDataLocation((WebGLProgram)((Object)this.programs.get(program)), name);
    }

    @Override
    public void glGetIntegerv(int pname, IntBuffer params) {
        switch (pname) {
            case 3074: 
            case 3314: 
            case 3315: 
            case 3316: 
            case 3330: 
            case 3331: 
            case 3332: 
            case 32877: 
            case 32878: 
            case 32883: 
            case 33000: 
            case 33001: 
            case 34852: 
            case 34853: 
            case 34854: 
            case 34855: 
            case 34856: 
            case 34857: 
            case 34858: 
            case 34859: 
            case 34860: 
            case 34861: 
            case 34862: 
            case 34863: 
            case 35071: 
            case 35076: 
            case 35077: 
            case 35371: 
            case 35373: 
            case 35375: 
            case 35657: 
            case 35658: 
            case 35659: 
            case 35723: 
            case 35968: 
            case 35978: 
            case 35979: 
            case 36063: 
            case 36183: 
            case 37154: 
            case 37157: {
                params.put(0, this.gl.getParameteri(pname));
                params.flip();
                return;
            }
            case 36006: 
            case 36010: {
                WebGLFramebuffer fbo = (WebGLFramebuffer)((Object)this.gl.getParametero(pname));
                if (fbo == null) {
                    params.put(0);
                } else {
                    params.put(this.frameBuffers.getKey(fbo));
                }
                params.flip();
                return;
            }
            case 32874: 
            case 35869: {
                WebGLTexture tex = (WebGLTexture)((Object)this.gl.getParametero(pname));
                if (tex == null) {
                    params.put(0);
                } else {
                    params.put(this.textures.getKey(tex));
                }
                params.flip();
                return;
            }
            case 34229: {
                WebGLVertexArrayObject obj = (WebGLVertexArrayObject)((Object)this.gl.getParametero(pname));
                if (obj == null) {
                    params.put(0);
                } else {
                    params.put(this.vertexArrays.getKey(obj));
                }
                params.flip();
                return;
            }
        }
        super.glGetIntegerv(pname, params);
    }

    public void glGetInteger64v(int pname, LongBuffer params) {
        switch (pname) {
            case 35376: 
            case 35377: 
            case 35379: 
            case 36203: 
            case 37137: {
                params.put(this.gl.getParameteri64(pname));
                params.flip();
                return;
            }
        }
        throw new UnsupportedOperationException("Given glGetInteger64v enum not supported on WebGL2");
    }

    @Override
    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        switch (pname) {
            case 33296: 
            case 33297: 
            case 33298: 
            case 33299: 
            case 33300: 
            case 33301: 
            case 33302: 
            case 33303: 
            case 36052: {
                params.put(0, this.gl.getFramebufferAttachmentParameteri(target, attachment, pname));
                params.flip();
                break;
            }
            default: {
                super.glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
            }
        }
    }

    public void glGetQueryiv(int target, int pname, IntBuffer params) {
        WebGLQuery query = this.gl.getQuery(target, pname);
        if (query == null) {
            params.put(0);
        } else {
            params.put(this.queries.getKey(query));
        }
        params.flip();
    }

    public void glGetQueryObjectuiv(int id, int pname, IntBuffer params) {
        if (pname == 34918) {
            params.put(this.gl.getQueryParameteri(this.queries.get(id), pname));
        } else if (pname == 34919) {
            boolean result = this.gl.getQueryParameterb(this.queries.get(id), pname);
            params.put(result ? 1 : 0);
        } else {
            throw new GdxRuntimeException("Unsupported pname passed to glGetQueryObjectuiv");
        }
        params.flip();
    }

    public void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        params.put(this.gl.getSamplerParameterf(this.samplers.get(sampler), pname));
        params.flip();
    }

    public void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        params.put(this.gl.getSamplerParameteri(this.samplers.get(sampler), pname));
        params.flip();
    }

    public String glGetStringi(int name, int index) {
        throw new UnsupportedOperationException("glGetStringi not supported on WebGL2");
    }

    public int glGetUniformBlockIndex(int program, String uniformBlockName) {
        return this.gl.getUniformBlockIndex((WebGLProgram)((Object)this.programs.get(program)), uniformBlockName);
    }

    public void glGetUniformIndices(int program, String[] uniformNames, IntBuffer uniformIndices) {
        JsArrayInteger array = this.gl.getUniformIndices((WebGLProgram)((Object)this.programs.get(program)), uniformNames);
        for (int i = 0; i < array.length(); ++i) {
            uniformIndices.put(i, array.get(i));
        }
        uniformIndices.flip();
    }

    public void glGetUniformuiv(int program, int location, IntBuffer params) {
        throw new UnsupportedOperationException("glGetUniformuiv not implemented on WebGL2");
    }

    public void glGetVertexAttribIiv(int index, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("glGetVertexAttribIiv not implemented on WebGL2");
    }

    public void glGetVertexAttribIuiv(int index, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("glGetVertexAttribIuiv not implemented on WebGL2");
    }

    public void glInvalidateFramebuffer(int target, int numAttachments, IntBuffer attachments) {
        int startPosition = attachments.position();
        this.gl.invalidateFramebuffer(target, this.copy(attachments).subarray(0, numAttachments));
        attachments.position(startPosition);
    }

    public void glInvalidateSubFramebuffer(int target, int numAttachments, IntBuffer attachments, int x, int y, int width, int height) {
        int startPosition = attachments.position();
        this.gl.invalidateSubFramebuffer(target, this.copy(attachments).subarray(0, numAttachments), x, y, width, height);
        attachments.position(startPosition);
    }

    public boolean glIsQuery(int id) {
        return this.gl.isQuery(this.queries.get(id));
    }

    public boolean glIsSampler(int id) {
        return this.gl.isSampler(this.samplers.get(id));
    }

    public boolean glIsTransformFeedback(int id) {
        return this.gl.isTransformFeedback(this.feedbacks.get(id));
    }

    public boolean glIsVertexArray(int id) {
        return this.gl.isVertexArray(this.vertexArrays.get(id));
    }

    public Buffer glMapBufferRange(int target, int offset, int length, int access) {
        throw new UnsupportedOperationException("glMapBufferRange not supported on WebGL2");
    }

    public void glPauseTransformFeedback() {
        this.gl.pauseTransformFeedback();
    }

    public void glProgramParameteri(int program, int pname, int value) {
        throw new UnsupportedOperationException("glProgramParameteri not supported on WebGL2");
    }

    public void glReadBuffer(int mode) {
        this.gl.readBuffer(mode);
    }

    public void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height) {
        this.gl.renderbufferStorageMultisample(target, samples, internalformat, width, height);
    }

    public void glResumeTransformFeedback() {
        this.gl.resumeTransformFeedback();
    }

    public void glSamplerParameterf(int sampler, int pname, float param) {
        this.gl.samplerParameterf(this.samplers.get(sampler), pname, param);
    }

    public void glSamplerParameterfv(int sampler, int pname, FloatBuffer param) {
        this.gl.samplerParameterf(this.samplers.get(sampler), pname, param.get());
    }

    public void glSamplerParameteri(int sampler, int pname, int param) {
        this.gl.samplerParameteri(this.samplers.get(sampler), pname, param);
    }

    public void glSamplerParameteriv(int sampler, int pname, IntBuffer param) {
        this.gl.samplerParameterf(this.samplers.get(sampler), pname, param.get());
    }

    public void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, Buffer pixels) {
        if (pixels == null) {
            this.gl.texImage3D(target, level, internalformat, width, height, depth, border, format, type, (ArrayBufferView)null);
            return;
        }
        if (pixels.limit() > 1) {
            ArrayBufferView buffer;
            HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)pixels);
            ArrayBufferView webGLArray = arrayHolder.getTypedArray();
            if (pixels instanceof FloatBuffer) {
                buffer = webGLArray;
            } else {
                int length = pixels.remaining();
                if (!(pixels instanceof ByteBuffer)) {
                    length *= 4;
                }
                int byteOffset = webGLArray.byteOffset() + pixels.position() * 4;
                buffer = Uint8ArrayNative.create((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)length);
            }
            this.gl.texImage3D(target, level, internalformat, width, height, depth, border, format, type, buffer);
        } else {
            Pixmap pixmap = Pixmap.pixmaps.get(((IntBuffer)pixels).get(0));
            if (pixmap.canUseImageElement()) {
                this.gl.texImage3D(target, level, internalformat, width, height, depth, border, format, type, pixmap.getImageElement());
            } else if (pixmap.canUseVideoElement()) {
                this.gl.texImage3D(target, level, internalformat, width, height, depth, border, format, type, pixmap.getVideoElement());
            } else {
                this.gl.texImage3D(target, level, internalformat, width, height, depth, border, format, type, pixmap.getCanvasElement());
            }
        }
    }

    public void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, int offset) {
        this.gl.texImage3D(target, level, internalformat, width, height, depth, border, format, type, offset);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, int offset) {
        this.gl.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, offset);
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, Buffer pixels) {
        if (pixels.limit() > 1) {
            ArrayBufferView buffer;
            HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)pixels);
            ArrayBufferView webGLArray = arrayHolder.getTypedArray();
            if (pixels instanceof FloatBuffer) {
                buffer = webGLArray;
            } else {
                int length = pixels.remaining();
                if (!(pixels instanceof ByteBuffer)) {
                    length *= 4;
                }
                int byteOffset = webGLArray.byteOffset() + pixels.position() * 4;
                buffer = Uint8ArrayNative.create((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)length);
            }
            this.gl.texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, buffer);
        } else {
            Pixmap pixmap = Pixmap.pixmaps.get(((IntBuffer)pixels).get(0));
            this.gl.texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixmap.getCanvasElement());
        }
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int offset) {
        this.gl.texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, offset);
    }

    public void glTransformFeedbackVaryings(int program, String[] varyings, int bufferMode) {
        this.gl.transformFeedbackVaryings((WebGLProgram)((Object)this.programs.get(program)), varyings, bufferMode);
    }

    public void glUniform1uiv(int location, int count, IntBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform1uiv(loc, this.copyUnsigned(value), 0, count);
    }

    public void glUniform3uiv(int location, int count, IntBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform3uiv(loc, this.copyUnsigned(value), 0, count);
    }

    public void glUniform4uiv(int location, int count, IntBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniform4uiv(loc, this.copyUnsigned(value), 0, count);
    }

    public void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        this.gl.uniformBlockBinding((WebGLProgram)((Object)this.programs.get(program)), uniformBlockIndex, uniformBlockBinding);
    }

    public void glUniformMatrix2x3fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix2x3fv(loc, transpose, this.copy(value));
    }

    public void glUniformMatrix2x4fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix2x4fv(loc, transpose, this.copy(value), 0, count);
    }

    public void glUniformMatrix3x2fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix3x2fv(loc, transpose, this.copy(value), 0, count);
    }

    public void glUniformMatrix3x4fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix3x4fv(loc, transpose, this.copy(value), 0, count);
    }

    public void glUniformMatrix4x2fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix4x2fv(loc, transpose, this.copy(value), 0, count);
    }

    public void glUniformMatrix4x3fv(int location, int count, boolean transpose, FloatBuffer value) {
        WebGLUniformLocation loc = this.getUniformLocation(location);
        this.gl.uniformMatrix4x3fv(loc, transpose, this.copy(value), 0, count);
    }

    public boolean glUnmapBuffer(int target) {
        throw new UnsupportedOperationException("glUnmapBuffer not supported on WebGL2");
    }

    public void glVertexAttribDivisor(int index, int divisor) {
        this.gl.vertexAttribDivisor(index, divisor);
    }

    public void glVertexAttribI4i(int index, int x, int y, int z, int w) {
        this.gl.vertexAttribI4i(index, x, y, z, w);
    }

    public void glVertexAttribI4ui(int index, int x, int y, int z, int w) {
        this.gl.vertexAttribI4ui(index, x, y, z, w);
    }

    public void glVertexAttribIPointer(int index, int size, int type, int stride, int offset) {
        this.gl.vertexAttribIPointer(index, size, type, stride, offset);
    }
}

