/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.webaudio;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.gwt.webaudio.AudioControlGraph;
import com.badlogic.gdx.backends.gwt.webaudio.AudioControlGraphPool;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.media.client.Audio;

public class WebAudioAPIMusic
implements Music {
    private final Audio audio;
    private final AudioControlGraphPool audioControlGraphPool;
    private final AudioControlGraph audioControlGraph;
    private Music.OnCompletionListener onCompletionListener;

    public WebAudioAPIMusic(JavaScriptObject audioContext, Audio audio, AudioControlGraphPool audioControlGraphPool) {
        this.audio = audio;
        this.audioControlGraphPool = audioControlGraphPool;
        JavaScriptObject audioSourceNode = this.createMediaElementAudioSourceNode(audioContext, (JavaScriptObject)audio.getAudioElement());
        this.audioControlGraph = (AudioControlGraph)audioControlGraphPool.obtain();
        this.audioControlGraph.setSource(audioSourceNode);
    }

    public void ended() {
        if (this.onCompletionListener != null) {
            this.onCompletionListener.onCompletion((Music)this);
        }
    }

    public native JavaScriptObject createMediaElementAudioSourceNode(JavaScriptObject var1, JavaScriptObject var2);

    public void play() {
        this.audio.play();
    }

    public void pause() {
        this.audio.pause();
    }

    public void stop() {
        this.pause();
        this.audio.setCurrentTime(0.0);
    }

    public boolean isPlaying() {
        return !this.audio.isPaused();
    }

    public void setLooping(boolean isLooping) {
        this.audio.setLoop(isLooping);
    }

    public boolean isLooping() {
        return this.audio.isLoop();
    }

    public void setVolume(float volume) {
        this.audioControlGraph.setVolume(volume);
    }

    public float getVolume() {
        return this.audioControlGraph.getVolume();
    }

    public void setPan(float pan, float volume) {
        this.audioControlGraph.setPan(pan);
        this.audioControlGraph.setVolume(volume);
    }

    public void setPosition(float position) {
        this.audio.setCurrentTime((double)position);
    }

    public float getPosition() {
        return (float)this.audio.getCurrentTime();
    }

    public void dispose() {
        this.pause();
        this.audioControlGraphPool.free(this.audioControlGraph);
    }

    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }
}

