/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.webaudio;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.gwt.webaudio.AudioControlGraph;
import com.badlogic.gdx.backends.gwt.webaudio.AudioControlGraphPool;
import com.badlogic.gdx.backends.gwt.webaudio.WebAudioAPIManager;
import com.badlogic.gdx.utils.IntMap;
import com.google.gwt.core.client.JavaScriptObject;

public class WebAudioAPISound
implements Sound {
    private final JavaScriptObject audioContext;
    private final JavaScriptObject destinationNode;
    private final IntMap<JavaScriptObject> activeSounds;
    private final IntMap<AudioControlGraph> activeAudioControlGraphs;
    private JavaScriptObject audioBuffer;
    private int nextKey = 0;
    private AudioControlGraphPool audioGraphPool;

    public WebAudioAPISound(JavaScriptObject audioContext, JavaScriptObject destinationNode, AudioControlGraphPool audioGraphPool) {
        this.audioContext = audioContext;
        this.destinationNode = destinationNode;
        this.audioGraphPool = audioGraphPool;
        this.activeSounds = new IntMap();
        this.activeAudioControlGraphs = new IntMap();
    }

    public void setAudioBuffer(JavaScriptObject audioBuffer) {
        this.audioBuffer = audioBuffer;
        IntMap.Keys keys = this.activeSounds.keys();
        while (keys.hasNext) {
            int key = keys.next();
            this.pause(key);
            this.resume(key, Float.valueOf(0.0f));
        }
    }

    protected long play(float volume, float pitch, float pan, boolean loop) {
        if (!WebAudioAPIManager.isSoundUnlocked() && WebAudioAPIManager.isAudioContextLocked(this.audioContext)) {
            return -1L;
        }
        AudioControlGraph audioControlGraph = (AudioControlGraph)this.audioGraphPool.obtain();
        JavaScriptObject audioBufferSourceNode = this.createBufferSourceNode(loop, pitch);
        audioControlGraph.setSource(audioBufferSourceNode);
        audioControlGraph.setPan(pan);
        audioControlGraph.setVolume(volume);
        int myKey = this.nextKey++;
        this.playJSNI(audioBufferSourceNode, myKey, 0.0f);
        this.activeSounds.put(myKey, (Object)audioBufferSourceNode);
        this.activeAudioControlGraphs.put(myKey, (Object)audioControlGraph);
        return myKey;
    }

    private void soundDone(int key) {
        if (this.activeSounds.containsKey(key)) {
            this.activeSounds.remove(key);
            this.audioGraphPool.free((AudioControlGraph)this.activeAudioControlGraphs.remove(key));
        }
    }

    public native JavaScriptObject createBufferSourceNode(boolean var1, float var2);

    public native JavaScriptObject playJSNI(JavaScriptObject var1, int var2, float var3);

    public static native JavaScriptObject stopJSNI(JavaScriptObject var0);

    public long play() {
        return this.play(1.0f);
    }

    public long play(float volume) {
        return this.play(volume, 1.0f, 0.0f);
    }

    public long play(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, false);
    }

    public long loop() {
        return this.loop(1.0f);
    }

    public long loop(float volume) {
        return this.loop(volume, 1.0f, 0.0f);
    }

    public long loop(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, true);
    }

    public void stop() {
        IntMap.Keys keys = this.activeSounds.keys();
        while (keys.hasNext) {
            int next = keys.next();
            this.stop(next);
        }
    }

    public void pause() {
        IntMap.Keys keys = this.activeSounds.keys();
        while (keys.hasNext) {
            this.pause(keys.next());
        }
    }

    public void resume() {
        IntMap.Keys keys = this.activeSounds.keys();
        while (keys.hasNext) {
            this.resume(keys.next());
        }
    }

    public void dispose() {
        this.stop();
        this.activeSounds.clear();
    }

    public void stop(long soundId) {
        int soundKey = (int)soundId;
        if (this.activeSounds.containsKey(soundKey)) {
            JavaScriptObject audioBufferSourceNode = (JavaScriptObject)this.activeSounds.remove(soundKey);
            WebAudioAPISound.stopJSNI(audioBufferSourceNode);
            this.audioGraphPool.free((AudioControlGraph)this.activeAudioControlGraphs.remove(soundKey));
        }
    }

    public void pause(long soundId) {
        int soundKey = (int)soundId;
        if (this.activeSounds.containsKey(soundKey)) {
            JavaScriptObject audioBufferSourceNode = (JavaScriptObject)this.activeSounds.get(soundKey);
            this.pauseJSNI(audioBufferSourceNode);
            WebAudioAPISound.stopJSNI(audioBufferSourceNode);
        }
    }

    public void resume(long soundId) {
        this.resume(soundId, null);
    }

    private void resume(long soundId, Float from) {
        int soundKey = (int)soundId;
        if (this.activeSounds.containsKey(soundKey)) {
            JavaScriptObject audioBufferSourceNode = (JavaScriptObject)this.activeSounds.remove(soundKey);
            AudioControlGraph audioControlGraph = (AudioControlGraph)this.activeAudioControlGraphs.get(soundKey);
            boolean loop = WebAudioAPISound.getLoopingJSNI(audioBufferSourceNode);
            float pitch = WebAudioAPISound.getPitchJSNI(audioBufferSourceNode);
            float resumeOffset = WebAudioAPISound.getResumeOffsetJSNI(audioBufferSourceNode);
            if (from != null) {
                resumeOffset = from.floatValue();
            }
            JavaScriptObject newAudioBufferSourceNode = this.createBufferSourceNode(loop, pitch);
            audioControlGraph.setSource(newAudioBufferSourceNode);
            this.activeSounds.put(soundKey, (Object)newAudioBufferSourceNode);
            this.playJSNI(newAudioBufferSourceNode, soundKey, resumeOffset);
        }
    }

    public void setLooping(long soundId, boolean looping) {
        int soundKey = (int)soundId;
        if (this.activeSounds.containsKey(soundKey)) {
            JavaScriptObject sound = (JavaScriptObject)this.activeSounds.get(soundKey);
            WebAudioAPISound.setLoopingJSNI(sound, looping);
        }
    }

    public void setPitch(long soundId, float pitch) {
        int soundKey = (int)soundId;
        if (this.activeSounds.containsKey(soundKey)) {
            JavaScriptObject sound = (JavaScriptObject)this.activeSounds.get(soundKey);
            WebAudioAPISound.setPitchJSNI(sound, pitch);
        }
    }

    public void setVolume(long soundId, float volume) {
        int soundKey = (int)soundId;
        if (this.activeSounds.containsKey(soundKey)) {
            AudioControlGraph audioControlGraph = (AudioControlGraph)this.activeAudioControlGraphs.get(soundKey);
            audioControlGraph.setVolume(volume);
        }
    }

    public void setPan(long soundId, float pan, float volume) {
        int soundKey = (int)soundId;
        if (this.activeSounds.containsKey(soundKey)) {
            AudioControlGraph audioControlGraph = (AudioControlGraph)this.activeAudioControlGraphs.get(soundKey);
            audioControlGraph.setPan(pan);
            audioControlGraph.setVolume(volume);
        }
    }

    public static native JavaScriptObject setPitchJSNI(JavaScriptObject var0, float var1);

    public static native float getPitchJSNI(JavaScriptObject var0);

    public static native JavaScriptObject setLoopingJSNI(JavaScriptObject var0, boolean var1);

    public static native boolean getLoopingJSNI(JavaScriptObject var0);

    public native JavaScriptObject pauseJSNI(JavaScriptObject var1);

    public static native float getResumeOffsetJSNI(JavaScriptObject var0);
}

