/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.corp.compatibility.Endianness;
import com.google.gwt.corp.compatibility.Numbers;
import java.nio.BaseByteBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

abstract class HeapByteBuffer
extends BaseByteBuffer {
    protected final byte[] backingArray;
    protected final int offset;

    HeapByteBuffer(byte[] backingArray) {
        this(backingArray, backingArray.length, 0);
    }

    HeapByteBuffer(int capacity) {
        this(new byte[capacity], capacity, 0);
    }

    HeapByteBuffer(byte[] backingArray, int capacity, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
        if (offset + capacity > backingArray.length) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public final ByteBuffer get(byte[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dest, off, len);
        this.position += len;
        return this;
    }

    @Override
    public final byte get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    @Override
    public final byte get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.backingArray[this.offset + index];
    }

    @Override
    public final double getDouble() {
        return Numbers.longBitsToDouble(this.getLong());
    }

    @Override
    public final double getDouble(int index) {
        return Numbers.longBitsToDouble(this.getLong(index));
    }

    @Override
    public final float getFloat() {
        return Numbers.intBitsToFloat(this.getInt());
    }

    @Override
    public final float getFloat(int index) {
        return Numbers.intBitsToFloat(this.getInt(index));
    }

    @Override
    public final int getInt() {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        int result = this.loadInt(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final int getInt(int index) {
        if (index < 0 || index + 4 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.loadInt(index);
    }

    @Override
    public final long getLong() {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        long result = this.loadLong(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final long getLong(int index) {
        if (index < 0 || index + 8 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.loadLong(index);
    }

    @Override
    public final short getShort() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        short result = this.loadShort(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final short getShort(int index) {
        if (index < 0 || index + 2 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.loadShort(index);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    protected final int loadInt(int index) {
        int baseOffset = this.offset + index;
        int bytes = 0;
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 0; i < 4; ++i) {
                bytes <<= 8;
                bytes |= this.backingArray[baseOffset + i] & 0xFF;
            }
        } else {
            for (int i = 3; i >= 0; --i) {
                bytes <<= 8;
                bytes |= this.backingArray[baseOffset + i] & 0xFF;
            }
        }
        return bytes;
    }

    protected final long loadLong(int index) {
        int baseOffset = this.offset + index;
        long bytes = 0L;
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 0; i < 8; ++i) {
                bytes <<= 8;
                bytes |= (long)(this.backingArray[baseOffset + i] & 0xFF);
            }
        } else {
            for (int i = 7; i >= 0; --i) {
                bytes <<= 8;
                bytes |= (long)(this.backingArray[baseOffset + i] & 0xFF);
            }
        }
        return bytes;
    }

    protected final short loadShort(int index) {
        int baseOffset = this.offset + index;
        short bytes = 0;
        if (this.order == Endianness.BIG_ENDIAN) {
            bytes = (short)(this.backingArray[baseOffset] << 8);
            bytes = (short)(bytes | this.backingArray[baseOffset + 1] & 0xFF);
        } else {
            bytes = (short)(this.backingArray[baseOffset + 1] << 8);
            bytes = (short)(bytes | this.backingArray[baseOffset] & 0xFF);
        }
        return bytes;
    }

    protected final void store(int index, int value) {
        int baseOffset = this.offset + index;
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 3; i >= 0; --i) {
                this.backingArray[baseOffset + i] = (byte)(value & 0xFF);
                value >>= 8;
            }
        } else {
            for (int i = 0; i <= 3; ++i) {
                this.backingArray[baseOffset + i] = (byte)(value & 0xFF);
                value >>= 8;
            }
        }
    }

    protected final void store(int index, long value) {
        int baseOffset = this.offset + index;
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 7; i >= 0; --i) {
                this.backingArray[baseOffset + i] = (byte)(value & 0xFFL);
                value >>= 8;
            }
        } else {
            for (int i = 0; i <= 7; ++i) {
                this.backingArray[baseOffset + i] = (byte)(value & 0xFFL);
                value >>= 8;
            }
        }
    }

    protected final void store(int index, short value) {
        int baseOffset = this.offset + index;
        if (this.order == Endianness.BIG_ENDIAN) {
            this.backingArray[baseOffset] = (byte)(value >> 8 & 0xFF);
            this.backingArray[baseOffset + 1] = (byte)(value & 0xFF);
        } else {
            this.backingArray[baseOffset + 1] = (byte)(value >> 8 & 0xFF);
            this.backingArray[baseOffset] = (byte)(value & 0xFF);
        }
    }
}

