/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.digital.BitConversion;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BinaryHeap<T extends Node>
extends AbstractQueue<T> {
    public int size;
    private Node[] nodes;
    private final boolean isMaxHeap;
    protected transient @Nullable HeapIterator<T> iterator1 = null;
    protected transient @Nullable HeapIterator<T> iterator2 = null;

    public BinaryHeap() {
        this(16, false);
    }

    public BinaryHeap(int capacity, boolean isMaxHeap) {
        this.isMaxHeap = isMaxHeap;
        this.nodes = new Node[capacity];
    }

    public BinaryHeap(Collection<? extends T> coll) {
        this(false, coll);
    }

    public BinaryHeap(boolean isMaxHeap, Collection<? extends T> coll) {
        this.isMaxHeap = isMaxHeap;
        this.nodes = new Node[coll.size()];
        this.addAll((Collection<? extends T>)coll);
    }

    public BinaryHeap(T[] arr) {
        this(false, (Node[])arr);
    }

    public BinaryHeap(boolean isMaxHeap, T[] arr) {
        this.isMaxHeap = isMaxHeap;
        this.nodes = new Node[arr.length];
        this.addAll((Node[])arr);
    }

    public boolean isMaxHeap() {
        return this.isMaxHeap;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == this) {
            throw new IllegalArgumentException("A BinaryHeap cannot be added to itself.");
        }
        boolean modified = false;
        for (Node t : c) {
            modified |= this.offer((T)t);
        }
        return modified;
    }

    public boolean addAll(T[] c) {
        return this.addAll((Node[])c, 0, c.length);
    }

    public boolean addAll(T[] c, int offset, int length) {
        boolean modified = false;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            modified |= this.offer(c[i]);
        }
        return modified;
    }

    @Override
    public boolean add(T node) {
        if (this.size == this.nodes.length) {
            Node[] newNodes = new Node[this.size << 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.size);
            this.nodes = newNodes;
        }
        ((Node)node).index = this.size;
        this.nodes[this.size] = node;
        this.up(this.size++);
        return true;
    }

    @Override
    public boolean offer(T node) {
        if (this.size == this.nodes.length) {
            Node[] newNodes = new Node[this.size << 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.size);
            this.nodes = newNodes;
        }
        ((Node)node).index = this.size;
        this.nodes[this.size] = node;
        try {
            this.up(this.size++);
        }
        catch (IllegalStateException ise) {
            return false;
        }
        return true;
    }

    @Override
    public @Nullable T poll() {
        if (this.size == 0) {
            return null;
        }
        Node removed = this.nodes[0];
        if (--this.size > 0) {
            this.nodes[0] = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.down(0);
        } else {
            this.nodes[0] = null;
        }
        return (T)removed;
    }

    @Override
    public T remove() {
        if (this.size == 0) {
            throw new NoSuchElementException("A BinaryHeap cannot be empty when remove() is called.");
        }
        Node removed = this.nodes[0];
        if (--this.size > 0) {
            this.nodes[0] = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.down(0);
        } else {
            this.nodes[0] = null;
        }
        return (T)removed;
    }

    public boolean add(T node, float value) {
        ((Node)node).value = value;
        return this.add(node);
    }

    @Override
    public boolean contains(Object node) {
        for (Node other : this.nodes) {
            if (!other.equals(node)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object node, boolean identity) {
        if (identity) {
            for (Node n : this.nodes) {
                if (n != node) continue;
                return true;
            }
        } else {
            for (Node other : this.nodes) {
                if (!other.equals(node)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public T element() {
        if (this.size == 0) {
            throw new NoSuchElementException("The heap is empty.");
        }
        return (T)this.nodes[0];
    }

    @Override
    public @Nullable T peek() {
        if (this.size == 0) {
            return null;
        }
        return (T)this.nodes[0];
    }

    public @Nullable T pop() {
        if (this.size == 0) {
            return null;
        }
        Node removed = this.nodes[0];
        if (--this.size > 0) {
            this.nodes[0] = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.down(0);
        } else {
            this.nodes[0] = null;
        }
        return (T)removed;
    }

    public T remove(T node) {
        if (--this.size > 0) {
            Node moved = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.nodes[((Node)node).index] = moved;
            if (moved.value < ((Node)node).value ^ this.isMaxHeap) {
                this.up(((Node)node).index);
            } else {
                this.down(((Node)node).index);
            }
        } else {
            this.nodes[0] = null;
        }
        return node;
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.nodes, 0, this.size, null);
        this.size = 0;
    }

    public void setValue(T node, float value) {
        float oldValue = ((Node)node).value;
        ((Node)node).value = value;
        if (value < oldValue ^ this.isMaxHeap) {
            this.up(((Node)node).index);
        } else {
            this.down(((Node)node).index);
        }
    }

    private void up(int index) {
        Node[] nodes = this.nodes;
        Node node = nodes[index];
        float value = node.value;
        while (index > 0) {
            int parentIndex = index - 1 >> 1;
            Node parent = nodes[parentIndex];
            if (node == parent) {
                throw new IllegalStateException("Duplicate nodes are not allowed in a BinaryHeap.");
            }
            if (!(value < parent.value ^ this.isMaxHeap)) break;
            nodes[index] = parent;
            parent.index = index;
            index = parentIndex;
        }
        nodes[index] = node;
        node.index = index;
    }

    private void down(int index) {
        int leftIndex;
        Node[] nodes = this.nodes;
        int size = this.size;
        Node node = nodes[index];
        float value = node.value;
        while ((leftIndex = 1 + (index << 1)) < size) {
            float rightValue;
            Node rightNode;
            int rightIndex = leftIndex + 1;
            Node leftNode = nodes[leftIndex];
            float leftValue = leftNode.value;
            if (rightIndex >= size) {
                rightNode = null;
                rightValue = this.isMaxHeap ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            } else {
                rightNode = nodes[rightIndex];
                rightValue = rightNode.value;
            }
            if (leftValue < rightValue ^ this.isMaxHeap) {
                if (leftValue == value || leftValue > value ^ this.isMaxHeap) break;
                nodes[index] = leftNode;
                leftNode.index = index;
                index = leftIndex;
                continue;
            }
            if (rightValue == value || rightValue > value ^ this.isMaxHeap) break;
            nodes[index] = rightNode;
            if (rightNode != null) {
                rightNode.index = index;
            }
            index = rightIndex;
        }
        while (index > 0) {
            int parentIndex = index - 1 >> 1;
            Node parent = nodes[parentIndex];
            if (!(value < parent.value ^ this.isMaxHeap)) break;
            nodes[index] = parent;
            parent.index = index;
            index = parentIndex;
        }
        nodes[index] = node;
        node.index = index;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryHeap)) {
            return false;
        }
        BinaryHeap other = (BinaryHeap)obj;
        if (other.size != this.size) {
            return false;
        }
        Node[] nodes1 = this.nodes;
        Node[] nodes2 = other.nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (nodes1[i].value == nodes2[i].value) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 1;
        Node[] nodes = this.nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += BitConversion.floatToRawIntBits((float)nodes[i].value);
            h ^= h >>> 15;
        }
        return h;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Node[] nodes = this.nodes;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(nodes[0].value);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(nodes[i].value);
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public HeapIterator<T> iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new HeapIterator(this);
            this.iterator2 = new HeapIterator(this);
        }
        if (!((HeapIterator)this.iterator1).valid) {
            this.iterator1.reset();
            ((HeapIterator)this.iterator1).valid = true;
            ((HeapIterator)this.iterator2).valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        ((HeapIterator)this.iterator2).valid = true;
        ((HeapIterator)this.iterator1).valid = false;
        return this.iterator2;
    }

    @SafeVarargs
    public static <T extends Node> BinaryHeap<T> with(T ... array) {
        return new BinaryHeap(false, array);
    }

    @SafeVarargs
    public static <T extends Node> BinaryHeap<T> minHeapWith(T ... array) {
        return new BinaryHeap(false, array);
    }

    @SafeVarargs
    public static <T extends Node> BinaryHeap<T> maxHeapWith(T ... array) {
        return new BinaryHeap(true, array);
    }

    public static class Node {
        public float value;
        public int index;

        public Node(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        public String toString() {
            return Float.toString(this.value);
        }
    }

    public static class HeapIterator<T extends Node>
    implements Iterator<T> {
        private final BinaryHeap<T> heap;
        private int index;
        private boolean valid = true;

        public HeapIterator(BinaryHeap<T> binaryHeap) {
            this.heap = binaryHeap;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.heap.size;
        }

        @Override
        public T next() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index >= this.heap.size) {
                throw new NoSuchElementException();
            }
            return (T)((BinaryHeap)this.heap).nodes[this.index++];
        }

        public void reset() {
            this.index = 0;
        }
    }
}

