/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.BooleanList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;

public class BooleanBag
extends BooleanList {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public BooleanBag() {
    }

    public BooleanBag(int capacity) {
        super(capacity);
    }

    public BooleanBag(BooleanList list) {
        super(list);
    }

    public BooleanBag(boolean[] array) {
        super(array);
    }

    public BooleanBag(boolean[] array, int startIndex, int count) {
        super(array, startIndex, count);
    }

    public BooleanBag(PrimitiveCollection.OfBoolean coll) {
        super(coll);
    }

    public BooleanBag(Ordered.OfBoolean other) {
        super(other);
    }

    public BooleanBag(Ordered.OfBoolean other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void insert(int index, boolean element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        boolean[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = element;
        ++this.size;
    }

    @Override
    public boolean removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        boolean[] items = this.items;
        boolean value = items[index];
        --this.size;
        items[index] = items[this.size];
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        int lastIndex = n - count;
        int i = Math.max(lastIndex, end);
        System.arraycopy(this.items, i, this.items, start, n - i);
        this.size = n - count;
    }

    @Override
    public int hashCode() {
        boolean[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += items[i] ? 421 : 5;
        }
        return h;
    }

    public static BooleanBag with(boolean item) {
        BooleanBag list = new BooleanBag(1);
        list.add(item);
        return list;
    }

    public static BooleanBag with(boolean ... array) {
        return new BooleanBag(array);
    }
}

