/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.support.sort.BooleanComparator;
import com.github.tommyettinger.ds.support.sort.BooleanComparators;
import com.github.tommyettinger.ds.support.util.BooleanIterator;
import com.github.tommyettinger.function.BooleanToBooleanFunction;
import java.util.NoSuchElementException;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BooleanList
implements PrimitiveCollection.OfBoolean,
Ordered.OfBoolean,
Arrangeable {
    public boolean[] items;
    protected int size;
    protected transient @Nullable BooleanListIterator iterator1;
    protected transient @Nullable BooleanListIterator iterator2;

    public boolean keepsOrder() {
        return true;
    }

    public BooleanList() {
        this(10);
    }

    public BooleanList(int capacity) {
        this.items = new boolean[capacity];
    }

    @Deprecated
    public BooleanList(boolean ordered, int capacity) {
        this(capacity);
    }

    public BooleanList(BooleanList list) {
        this.size = list.size;
        this.items = new boolean[this.size];
        System.arraycopy(list.items, 0, this.items, 0, this.size);
    }

    public BooleanList(boolean[] array) {
        this(array, 0, array.length);
    }

    public BooleanList(boolean[] array, int startIndex, int count) {
        this(count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    @Deprecated
    public BooleanList(boolean ordered, boolean[] array, int startIndex, int count) {
        this(array, startIndex, count);
    }

    public BooleanList(PrimitiveCollection.OfBoolean coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public BooleanList(Ordered.OfBoolean other) {
        this(other.order());
    }

    public BooleanList(Ordered.OfBoolean other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(boolean value) {
        boolean[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value;
        return true;
    }

    public void add(boolean value1, boolean value2) {
        boolean[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(boolean value1, boolean value2, boolean value3) {
        boolean[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(boolean value1, boolean value2, boolean value3, boolean value4) {
        boolean[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize(Math.max(9, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public boolean addAll(BooleanList list) {
        return this.addAll(list.items, 0, list.size);
    }

    public boolean addAll(BooleanList list, int offset, int count) {
        if (offset + count > list.size) {
            throw new IllegalArgumentException("offset + count must be <= list.size: " + offset + " + " + count + " <= " + list.size);
        }
        return this.addAll(list.items, offset, count);
    }

    public boolean addAll(Ordered.OfBoolean other, int offset, int count) {
        return this.addAll(this.size(), other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered.OfBoolean other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.insert(insertionIndex++, other.order().get(i));
            changed = true;
        }
        return changed;
    }

    public boolean addAll(boolean ... array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(boolean[] array, int offset, int length) {
        int sizeNeeded = this.size + length;
        boolean[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(array, offset, items, this.size, length);
        this.size += length;
        return true;
    }

    public boolean get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, boolean value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void and(int index, boolean value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] & value;
    }

    public void or(int index, boolean value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] | value;
    }

    public void xor(int index, boolean value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] ^ value;
    }

    public void not(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] ^ true;
    }

    public void insert(int index, boolean value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        boolean[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(items, index, items, index + 1, this.size - index);
        ++this.size;
        items[index] = value;
    }

    public boolean duplicateRange(int index, int count) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, index, this.items, index + count, this.size - index);
        this.size = sizeNeeded;
        return count > 0;
    }

    @Override
    public BooleanList order() {
        return this;
    }

    @Override
    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        boolean[] items = this.items;
        boolean firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    @Override
    public boolean contains(boolean value) {
        int i = this.size - 1;
        boolean[] items = this.items;
        while (i >= 0) {
            if (items[i--] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BooleanList other) {
        boolean[] others = other.items;
        int otherSize = other.size;
        for (int i = 0; i < otherSize; ++i) {
            if (this.contains(others[i])) continue;
            return false;
        }
        return true;
    }

    public int indexOf(boolean value) {
        boolean[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(boolean value) {
        boolean[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(boolean value) {
        boolean[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public boolean removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        boolean[] items = this.items;
        boolean value = items[index];
        --this.size;
        System.arraycopy(items, index + 1, items, index, this.size - index);
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        System.arraycopy(this.items, start + count, this.items, start, n - (start + count));
        this.size = n - count;
    }

    @Override
    public boolean removeAll(PrimitiveCollection.OfBoolean c) {
        int size;
        int startSize = size = this.size;
        boolean[] items = this.items;
        BooleanIterator it = c.iterator();
        int n = c.size();
        for (int i = 0; i < n; ++i) {
            boolean item = it.nextBoolean();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii--);
                --size;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean removeEach(PrimitiveCollection.OfBoolean c) {
        int size;
        int startSize = size = this.size;
        boolean[] items = this.items;
        BooleanIterator it = c.iterator();
        int n = c.size();
        block0: for (int i = 0; i < n; ++i) {
            boolean item = it.nextBoolean();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii);
                --size;
                continue block0;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean retainAll(PrimitiveCollection.OfBoolean other) {
        int size = this.size;
        boolean[] items = this.items;
        int w = 0;
        for (int r = 0; r < size; ++r) {
            if (!other.contains(items[r])) continue;
            items[w++] = items[r];
        }
        this.size = w;
        return size != this.size;
    }

    public void replaceAll(BooleanToBooleanFunction operator) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.items[i] = operator.applyAsBoolean(this.items[i]);
        }
    }

    public boolean pop() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("BooleanList is empty.");
        }
        return this.items[--this.size];
    }

    public boolean peek() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("BooleanList is empty.");
        }
        return this.items[this.size - 1];
    }

    @Override
    public boolean first() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("BooleanList is empty.");
        }
        return this.items[0];
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public boolean[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public boolean[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public boolean[] setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected boolean[] resize(int newSize) {
        boolean[] newItems = new boolean[newSize];
        boolean[] items = this.items;
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        this.sort(BooleanComparators.NATURAL_COMPARATOR);
    }

    @Override
    public void sort(@Nullable BooleanComparator c) {
        if (c == null) {
            this.sort(0, this.size, BooleanComparators.NATURAL_COMPARATOR);
        } else {
            this.sort(0, this.size, c);
        }
    }

    public void sort(int from, int to, BooleanComparator c) {
        BooleanComparators.sort(this.items, from, to, c);
    }

    @Override
    public void reverse() {
        boolean[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            boolean temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    @Override
    public void shuffle(Random random) {
        boolean[] items = this.items;
        for (int i = this.size - 1; i > 0; --i) {
            int ii = random.nextInt(i + 1);
            boolean temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    @Override
    public boolean random(Random random) {
        if (this.size == 0) {
            return false;
        }
        return this.items[random.nextInt(this.size)];
    }

    @Override
    public boolean[] toArray() {
        boolean[] array = new boolean[this.size];
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public boolean[] toArray(boolean[] array) {
        if (array.length < this.size) {
            array = new boolean[this.size];
        }
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public int hashCode() {
        boolean[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h = h * 31 + (items[i] ? 421 : 5);
        }
        return h;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BooleanList)) {
            return false;
        }
        int n = this.size;
        BooleanList list = (BooleanList)object;
        if (n != list.size()) {
            return false;
        }
        boolean[] items1 = this.items;
        boolean[] items2 = list.items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        boolean[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        boolean[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items[i]);
        }
        return buffer.toString();
    }

    @Override
    public BooleanListIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new BooleanListIterator(this);
            this.iterator2 = new BooleanListIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static BooleanList with(boolean item) {
        BooleanList list = new BooleanList(1);
        list.add(item);
        return list;
    }

    public static BooleanList with(boolean ... array) {
        return new BooleanList(array);
    }

    public static class BooleanListIterator
    implements BooleanIterator {
        protected int index;
        protected int latest = -1;
        protected BooleanList list;
        protected boolean valid = true;

        public BooleanListIterator(BooleanList list) {
            this.list = list;
        }

        public BooleanListIterator(BooleanList list, int index) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException("BooleanListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.list = list;
            this.index = index;
        }

        @Override
        public boolean nextBoolean() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index++;
            return this.list.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.list.size();
        }

        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index > 0 && this.list.notEmpty();
        }

        public boolean previousBoolean() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index <= 0 || this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.latest = --this.index;
            return this.list.get(this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        public void set(boolean t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.set(this.latest, t);
        }

        public void add(boolean t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.insert(this.index, t);
            if (this.list.keepsOrder()) {
                ++this.index;
            }
            this.latest = -1;
        }

        public void reset() {
            this.index = 0;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.list.size()) {
                throw new IndexOutOfBoundsException("BooleanListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        public BooleanListIterator iterator() {
            return this;
        }
    }
}

