/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ByteList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;

public class ByteBag
extends ByteList {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public ByteBag() {
    }

    public ByteBag(int capacity) {
        super(capacity);
    }

    public ByteBag(ByteList list) {
        super(list);
    }

    public ByteBag(byte[] array) {
        super(array);
    }

    public ByteBag(byte[] array, int startIndex, int count) {
        super(array, startIndex, count);
    }

    public ByteBag(PrimitiveCollection.OfByte coll) {
        super(coll);
    }

    public ByteBag(Ordered.OfByte other) {
        super(other);
    }

    public ByteBag(Ordered.OfByte other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void insert(int index, byte element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        byte[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = element;
        ++this.size;
    }

    @Override
    public byte removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        byte[] items = this.items;
        byte value = items[index];
        --this.size;
        items[index] = items[this.size];
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        int lastIndex = n - count;
        int i = Math.max(lastIndex, end);
        System.arraycopy(this.items, i, this.items, start, n - i);
        this.size = n - count;
    }

    @Override
    public int hashCode() {
        byte[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += items[i];
        }
        return h;
    }

    public static ByteBag with(byte item) {
        ByteBag list = new ByteBag(1);
        list.add(item);
        return list;
    }

    public static ByteBag with(byte ... array) {
        return new ByteBag(array);
    }
}

