/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.CaseInsensitiveMap;
import com.github.tommyettinger.ds.ObjectObjectMap;
import com.github.tommyettinger.ds.ObjectObjectOrderedMap;
import com.github.tommyettinger.ds.Utilities;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CaseInsensitiveOrderedMap<V>
extends ObjectObjectOrderedMap<CharSequence, V> {
    public CaseInsensitiveOrderedMap() {
    }

    public CaseInsensitiveOrderedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveOrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveOrderedMap(ObjectObjectOrderedMap<? extends CharSequence, ? extends V> map) {
        super(map);
    }

    public CaseInsensitiveOrderedMap(Map<? extends CharSequence, ? extends V> map) {
        super(map);
    }

    public CaseInsensitiveOrderedMap(CharSequence[] keys, V[] values) {
        super(keys, values);
    }

    public CaseInsensitiveOrderedMap(Collection<? extends CharSequence> keys, Collection<? extends V> values) {
        super(keys, values);
    }

    public CaseInsensitiveOrderedMap(ObjectObjectOrderedMap<CharSequence, ? extends V> other, int offset, int count) {
        this(count);
        this.putAll(0, other, offset, count);
    }

    @Override
    protected int place(Object item) {
        if (item instanceof CharSequence) {
            return (int)Utilities.longHashCodeIgnoreCase((CharSequence)item, this.hashMultiplier) & this.mask;
        }
        return super.place(item);
    }

    @Override
    protected boolean equate(Object left, @Nullable Object right) {
        if (left instanceof CharSequence && right instanceof CharSequence) {
            return Utilities.equalsIgnoreCase((CharSequence)left, (CharSequence)right);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = this.size;
        CharSequence[] keyTable = (CharSequence[])this.keyTable;
        Object[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            CharSequence key = keyTable[i];
            if (key == null) continue;
            h = (int)((long)h ^ Utilities.longHashCodeIgnoreCase(key));
            Object value = valueTable[i];
            if (value == null) continue;
            h ^= value.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CaseInsensitiveOrderedMap)) {
            return false;
        }
        CaseInsensitiveOrderedMap other = (CaseInsensitiveOrderedMap)obj;
        if (other.size != this.size) {
            return false;
        }
        Object[] keyTable = this.keyTable;
        Object[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            Object value;
            Object key = keyTable[i];
            if (key == null || !((value = valueTable[i]) == null ? other.getOrDefault(key, Utilities.neverIdentical) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectObjectMap.Keys<CharSequence, V> keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new CaseInsensitiveMap.Keys(this);
            this.keys2 = new CaseInsensitiveMap.Keys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    public static <V> CaseInsensitiveOrderedMap<V> with(CharSequence key0, V value0) {
        CaseInsensitiveOrderedMap<V> map = new CaseInsensitiveOrderedMap<V>(1);
        map.put(key0, value0);
        return map;
    }

    public static <V> CaseInsensitiveOrderedMap<V> with(CharSequence key0, V value0, Object ... rest) {
        CaseInsensitiveOrderedMap<Object> map = new CaseInsensitiveOrderedMap<Object>(1 + (rest.length >>> 1));
        map.put(key0, value0);
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put((CharSequence)rest[i - 1], rest[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }

    public static class Keys<V>
    extends ObjectObjectOrderedMap.OrderedMapKeys<CharSequence, V> {
        public Keys(ObjectObjectOrderedMap<CharSequence, V> map) {
            super(map);
        }

        @Override
        public int hashCode() {
            int h = 0;
            this.iter.reset();
            while (this.iter.hasNext()) {
                CharSequence obj = (CharSequence)this.iter.next();
                if (obj == null) continue;
                h = (int)((long)h + Utilities.longHashCodeIgnoreCase(obj));
            }
            return h;
        }
    }

    public static class Entry<V>
    extends ObjectObjectMap.Entry<CharSequence, V> {
        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectObjectMap.Entry entry = (ObjectObjectMap.Entry)o;
            if (this.key != null ? entry.key == null || !Utilities.equalsIgnoreCase((CharSequence)this.key, (CharSequence)entry.key) : entry.key != null) {
                return false;
            }
            return Objects.equals(this.value, entry.value);
        }

        @Override
        public int hashCode() {
            int result = this.key != null ? (int)Utilities.longHashCodeIgnoreCase((CharSequence)this.key) : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

