/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectOrderedSet;
import com.github.tommyettinger.ds.ObjectSet;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.Utilities;
import java.util.Collection;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CaseInsensitiveOrderedSet
extends ObjectOrderedSet<CharSequence> {
    public CaseInsensitiveOrderedSet() {
    }

    public CaseInsensitiveOrderedSet(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveOrderedSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveOrderedSet(ObjectSet<? extends CharSequence> set) {
        super(set);
    }

    public CaseInsensitiveOrderedSet(ObjectOrderedSet<? extends CharSequence> set) {
        super(set);
    }

    public CaseInsensitiveOrderedSet(Collection<? extends CharSequence> coll) {
        super(coll);
    }

    public CaseInsensitiveOrderedSet(CharSequence[] array, int offset, int length) {
        super(array, offset, length);
    }

    public CaseInsensitiveOrderedSet(CharSequence[] array) {
        super(array);
    }

    public CaseInsensitiveOrderedSet(Ordered<CharSequence> other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    protected int place(Object item) {
        if (item instanceof CharSequence) {
            return (int)Utilities.longHashCodeIgnoreCase((CharSequence)item, this.hashMultiplier) & this.mask;
        }
        return super.place(item);
    }

    @Override
    protected boolean equate(Object left, @Nullable Object right) {
        if (left instanceof CharSequence && right instanceof CharSequence) {
            return Utilities.equalsIgnoreCase((CharSequence)left, (CharSequence)right);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = this.size;
        for (CharSequence key : (CharSequence[])this.keyTable) {
            if (key == null) continue;
            h = (int)((long)h + Utilities.longHashCodeIgnoreCase(key));
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        if (s.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(s);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    public static CaseInsensitiveOrderedSet with(CharSequence item) {
        CaseInsensitiveOrderedSet set = new CaseInsensitiveOrderedSet(1);
        set.add(item);
        return set;
    }

    public static CaseInsensitiveOrderedSet with(CharSequence ... array) {
        return new CaseInsensitiveOrderedSet(array);
    }
}

