/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectSet;
import com.github.tommyettinger.ds.Utilities;
import java.util.Collection;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CaseInsensitiveSet
extends ObjectSet<CharSequence> {
    public CaseInsensitiveSet() {
    }

    public CaseInsensitiveSet(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveSet(ObjectSet<? extends CharSequence> set) {
        super(set);
    }

    public CaseInsensitiveSet(Collection<? extends CharSequence> coll) {
        super(coll);
    }

    public CaseInsensitiveSet(CharSequence[] array, int offset, int length) {
        super(array, offset, length);
    }

    public CaseInsensitiveSet(CharSequence[] array) {
        super(array);
    }

    @Override
    protected int place(Object item) {
        if (item instanceof CharSequence) {
            return (int)Utilities.longHashCodeIgnoreCase((CharSequence)item, this.hashMultiplier) & this.mask;
        }
        return super.place(item);
    }

    @Override
    protected boolean equate(Object left, @Nullable Object right) {
        if (left instanceof CharSequence && right instanceof CharSequence) {
            return Utilities.equalsIgnoreCase((CharSequence)left, (CharSequence)right);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = this.size;
        for (CharSequence key : (CharSequence[])this.keyTable) {
            if (key == null) continue;
            h = (int)((long)h + Utilities.longHashCodeIgnoreCase(key));
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        if (s.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(s);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    public static CaseInsensitiveSet with(CharSequence item) {
        CaseInsensitiveSet set = new CaseInsensitiveSet(1);
        set.add(item);
        return set;
    }

    public static CaseInsensitiveSet with(CharSequence ... array) {
        return new CaseInsensitiveSet(array);
    }
}

