/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.CharList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;

public class CharBag
extends CharList {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public CharBag() {
    }

    public CharBag(int capacity) {
        super(capacity);
    }

    public CharBag(CharList list) {
        super(list);
    }

    public CharBag(char[] array) {
        super(array);
    }

    public CharBag(char[] array, int startIndex, int count) {
        super(array, startIndex, count);
    }

    public CharBag(PrimitiveCollection.OfChar coll) {
        super(coll);
    }

    public CharBag(Ordered.OfChar other) {
        super(other);
    }

    public CharBag(Ordered.OfChar other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void insert(int index, char element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        char[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = element;
        ++this.size;
    }

    @Override
    public char removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        char[] items = this.items;
        char value = items[index];
        --this.size;
        items[index] = items[this.size];
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        int lastIndex = n - count;
        int i = Math.max(lastIndex, end);
        System.arraycopy(this.items, i, this.items, start, n - i);
        this.size = n - count;
    }

    @Override
    public int hashCode() {
        char[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += items[i];
        }
        return h;
    }

    public static CharBag with(char item) {
        CharBag list = new CharBag(1);
        list.add(item);
        return list;
    }

    public static CharBag with(char ... array) {
        return new CharBag(array);
    }
}

