/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.support.sort.CharComparator;
import com.github.tommyettinger.ds.support.sort.CharComparators;
import com.github.tommyettinger.ds.support.util.CharIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CharDeque
implements PrimitiveCollection.OfChar,
Arrangeable {
    protected char defaultValue = (char)65535;
    protected char[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;
    protected transient @Nullable CharDequeIterator iterator1;
    protected transient @Nullable CharDequeIterator iterator2;
    protected transient @Nullable CharDequeIterator descendingIterator1;
    protected transient @Nullable CharDequeIterator descendingIterator2;

    public CharDeque() {
        this(16);
    }

    public CharDeque(int initialSize) {
        this.values = new char[initialSize];
    }

    public CharDeque(PrimitiveCollection.OfChar coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public CharDeque(CharDeque deque) {
        this.values = Arrays.copyOf(deque.values, deque.values.length);
        this.size = deque.size;
        this.head = deque.head;
        this.tail = deque.tail;
        this.defaultValue = deque.defaultValue;
    }

    public CharDeque(char[] a) {
        this.tail = a.length;
        this.values = Arrays.copyOf(a, this.tail);
        this.size = this.tail;
    }

    public CharDeque(char[] a, int offset, int count) {
        this.values = Arrays.copyOfRange(a, offset, offset + count);
        this.tail = count;
        this.size = count;
    }

    public char getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(char defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void addLast(char item) {
        char[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        if (this.tail == values.length) {
            this.tail = 0;
        }
        values[this.tail++] = item;
        ++this.size;
    }

    public void addFirst(char item) {
        char[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        int head = this.head;
        if (--head == -1) {
            head = values.length - 1;
        }
        values[head] = item;
        this.head = head;
        ++this.size;
    }

    public void ensureCapacity(int additional) {
        int needed = this.size + additional;
        if (this.values.length < needed) {
            this.resize(needed);
        }
    }

    protected void resize(int newSize) {
        char[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        char[] newArray = new char[newSize];
        if (head < tail) {
            System.arraycopy(values, head, newArray, 0, tail - head);
        } else if (this.size > 0) {
            int rest = values.length - head;
            System.arraycopy(values, head, newArray, 0, rest);
            System.arraycopy(values, 0, newArray, rest, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    public char removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("CharDeque is empty.");
        }
        char[] values = this.values;
        char result = values[this.head];
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    public char removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("CharDeque is empty.");
        }
        char[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        char result = values[tail];
        this.tail = tail;
        --this.size;
        return result;
    }

    public boolean offerFirst(char t) {
        int oldSize = this.size;
        this.addFirst(t);
        return oldSize != this.size;
    }

    public boolean offerLast(char t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public char pollFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        char[] values = this.values;
        char result = values[this.head];
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    public char pollLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        char[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        char result = values[tail];
        this.tail = tail;
        --this.size;
        return result;
    }

    public char getFirst() {
        return this.first();
    }

    public char getLast() {
        return this.last();
    }

    public char peekFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        return this.values[this.head];
    }

    public char peekLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        char[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public boolean removeFirstOccurrence(char o) {
        return this.removeValue(o);
    }

    public boolean removeLastOccurrence(char o) {
        return this.removeLastValue(o);
    }

    @Override
    public boolean add(char t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public boolean add(int index, char item) {
        int oldSize = this.size;
        if (index <= 0) {
            this.addFirst(item);
        } else if (index >= oldSize) {
            this.addLast(item);
        } else {
            char[] values = this.values;
            if (this.size == values.length) {
                this.resize(values.length << 1);
                values = this.values;
            }
            if (this.head < this.tail) {
                if ((index += this.head) >= values.length) {
                    index -= values.length;
                }
                System.arraycopy(values, index, values, (index + 1) % values.length, this.tail - index);
                values[index] = item;
                ++this.tail;
                if (this.tail > values.length) {
                    this.tail = 1;
                }
            } else if (this.head + index < values.length) {
                System.arraycopy(values, this.head, values, this.head - 1, index);
                values[this.head - 1 + index] = item;
                --this.head;
            } else {
                System.arraycopy(values, this.head + (index -= values.length - 1), values, this.head + index + 1, this.tail - this.head - index);
                values[this.head + index] = item;
                ++this.tail;
            }
            ++this.size;
        }
        return oldSize != this.size;
    }

    public boolean insert(int index, char element) {
        return this.add(index, element);
    }

    public boolean offer(char t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public char remove() {
        return this.removeFirst();
    }

    public char poll() {
        return this.pollFirst();
    }

    public char element() {
        return this.first();
    }

    public char peek() {
        return this.peekFirst();
    }

    @Override
    public boolean addAll(PrimitiveCollection.OfChar c) {
        int oldSize = this.size;
        CharIterator it = c.iterator();
        while (it.hasNext()) {
            this.addLast(it.nextChar());
        }
        return oldSize != this.size;
    }

    public void push(char t) {
        this.addFirst(t);
    }

    public char pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(char o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean contains(char o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public char[] toArray() {
        char[] next = new char[this.size];
        if (this.head < this.tail) {
            System.arraycopy(this.values, this.head, next, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.values, this.head, next, 0, this.size - this.head);
            System.arraycopy(this.values, 0, next, this.size - this.head, this.tail);
        }
        return next;
    }

    public int indexOf(char value) {
        if (this.size == 0) {
            return -1;
        }
        char[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = head; i < tail; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
        } else {
            int i;
            int n = values.length;
            for (i = head; i < n; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
            for (i = 0; i < tail; ++i) {
                if (values[i] != value) continue;
                return i + values.length - head;
            }
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        if (this.size == 0) {
            return -1;
        }
        char[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = tail - 1; i >= head; --i) {
                if (values[i] != value) continue;
                return i - head;
            }
        } else {
            int i;
            for (i = tail - 1; i >= 0; --i) {
                if (values[i] != value) continue;
                return i + values.length - head;
            }
            for (i = values.length - 1; i >= head; --i) {
                if (values[i] != value) continue;
                return i - head;
            }
        }
        return -1;
    }

    public boolean removeValue(char value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public boolean removeLastValue(char value) {
        int index = this.lastIndexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public char removeAt(int index) {
        char value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        char[] values = this.values;
        int head = this.head++;
        int tail = this.tail--;
        index += head;
        if (head < tail) {
            value = values[index];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
        } else if (index >= values.length) {
            value = values[index -= values.length];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
            --this.tail;
        } else {
            value = values[index];
            System.arraycopy(values, head, values, head + 1, index - head);
            if (this.head == values.length) {
                this.head = 0;
            }
        }
        --this.size;
        return value;
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public char first() {
        if (this.size == 0) {
            throw new NoSuchElementException("CharDeque is empty.");
        }
        return this.values[this.head];
    }

    public char last() {
        if (this.size == 0) {
            throw new NoSuchElementException("CharDeque is empty.");
        }
        char[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public char get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        char[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        return values[i];
    }

    public char set(int index, char item) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        char[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        char old = values[i];
        values[i] = item;
        return old;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    @Override
    public CharDequeIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new CharDequeIterator(this);
            this.iterator2 = new CharDequeIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public CharDequeIterator descendingIterator() {
        if (this.descendingIterator1 == null || this.descendingIterator2 == null) {
            this.descendingIterator1 = new CharDequeIterator(this, true);
            this.descendingIterator2 = new CharDequeIterator(this, true);
        }
        if (!this.descendingIterator1.valid) {
            this.descendingIterator1.reset();
            this.descendingIterator1.valid = true;
            this.descendingIterator2.valid = false;
            return this.descendingIterator1;
        }
        this.descendingIterator2.reset();
        this.descendingIterator2.valid = true;
        this.descendingIterator1.valid = false;
        return this.descendingIterator2;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        char[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(", ").append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        char[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(separator).append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        return sb.toString();
    }

    public String toDenseString() {
        if (this.head < this.tail) {
            return String.valueOf(this.values, this.head, this.size);
        }
        return String.valueOf(this.values, this.head, this.values.length - this.head) + String.valueOf(this.values, 0, this.tail);
    }

    @Override
    public int hashCode() {
        int size = this.size;
        char[] values = this.values;
        int backingLength = values.length;
        int index = this.head;
        int hash = size + 1;
        for (int s = 0; s < size; ++s) {
            char value = values[index];
            hash *= 421;
            hash += value;
            if (++index != backingLength) continue;
            index = 0;
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharDeque)) {
            return false;
        }
        CharDeque q = (CharDeque)o;
        int size = this.size;
        if (q.size != size) {
            return false;
        }
        char[] myValues = this.values;
        int myBackingLength = myValues.length;
        char[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size; ++s) {
            char myValue = myValues[myIndex];
            char itsValue = itsValues[itsIndex];
            if (myValue != itsValue) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    @Override
    public void swap(int first, int second) {
        int s;
        if (first < 0) {
            throw new IndexOutOfBoundsException("first index can't be < 0: " + first);
        }
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first index can't be >= size: " + first + " >= " + this.size);
        }
        if (second < 0) {
            throw new IndexOutOfBoundsException("second index can't be < 0: " + second);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second index can't be >= size: " + second + " >= " + this.size);
        }
        int f = this.head + first;
        char[] values = this.values;
        if (f >= values.length) {
            f -= values.length;
        }
        if ((s = this.head + second) >= values.length) {
            s -= values.length;
        }
        char fv = values[f];
        values[f] = values[s];
        values[s] = fv;
    }

    @Override
    public void reverse() {
        char[] values = this.values;
        int len = values.length;
        int n = this.size >> 1;
        int b = 0;
        for (int t = this.size - 1; b <= n && b != t; ++b, --t) {
            int s;
            int f = this.head + b;
            if (f >= len) {
                f -= len;
            }
            if ((s = this.head + t) >= len) {
                s -= len;
            }
            char fv = values[f];
            values[f] = values[s];
            values[s] = fv;
        }
    }

    public void sort() {
        if (this.head <= this.tail) {
            Arrays.sort(this.values, this.head, this.tail);
        } else {
            System.arraycopy(this.values, this.head, this.values, this.tail, this.values.length - this.head);
            Arrays.sort(this.values, 0, this.size);
            this.tail = this.size;
            this.head = 0;
        }
    }

    public void sort(@Nullable CharComparator c) {
        if (this.head <= this.tail) {
            CharComparators.sort(this.values, this.head, this.tail, c);
        } else {
            System.arraycopy(this.values, this.head, this.values, this.tail, this.values.length - this.head);
            CharComparators.sort(this.values, 0, this.size, c);
            this.tail = this.size;
            this.head = 0;
        }
    }

    public char random(Random random) {
        if (this.size <= 0) {
            throw new NoSuchElementException("CharDeque is empty.");
        }
        return this.get(random.nextInt(this.size));
    }

    public static CharDeque with(char item) {
        CharDeque deque = new CharDeque();
        deque.add(item);
        return deque;
    }

    public static CharDeque with(char ... items) {
        return new CharDeque(items);
    }

    public static class CharDequeIterator
    implements CharIterator {
        protected int index;
        protected int latest = -1;
        protected CharDeque deque;
        protected boolean valid = true;
        private final int direction;

        public CharDequeIterator(CharDeque deque) {
            this(deque, false);
        }

        public CharDequeIterator(CharDeque deque, boolean descendingOrder) {
            this.deque = deque;
            this.direction = descendingOrder ? -1 : 1;
        }

        public CharDequeIterator(CharDeque deque, int index, boolean descendingOrder) {
            if (index < 0 || index >= deque.size()) {
                throw new IndexOutOfBoundsException("CharDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.deque = deque;
            this.index = index;
            this.direction = descendingOrder ? -1 : 1;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index;
            this.index += this.direction;
            return this.deque.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == 1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == -1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        public char previousChar() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index -= this.direction;
            return this.deque.get(this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        public void set(char t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.set(this.latest, t);
        }

        public void add(char t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.insert(this.index, t);
            this.index += this.direction;
            this.latest = -1;
        }

        public void reset() {
            this.index = this.deque.size - 1 & this.direction >> 31;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.deque.size()) {
                throw new IndexOutOfBoundsException("CharDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        public CharDequeIterator iterator() {
            return this;
        }
    }
}

