/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.support.sort.CharComparator;
import com.github.tommyettinger.ds.support.sort.CharComparators;
import com.github.tommyettinger.ds.support.util.CharIterator;
import com.github.tommyettinger.function.CharToCharFunction;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CharList
implements PrimitiveCollection.OfChar,
Ordered.OfChar,
Arrangeable {
    public char[] items;
    protected int size;
    protected transient @Nullable CharListIterator iterator1;
    protected transient @Nullable CharListIterator iterator2;

    public boolean keepsOrder() {
        return true;
    }

    public CharList() {
        this(10);
    }

    public CharList(int capacity) {
        this.items = new char[capacity];
    }

    @Deprecated
    public CharList(boolean ordered, int capacity) {
        this(capacity);
    }

    public CharList(CharList list) {
        this.size = list.size;
        this.items = new char[this.size];
        System.arraycopy(list.items, 0, this.items, 0, this.size);
    }

    public CharList(char[] array) {
        this(array, 0, array.length);
    }

    public CharList(char[] array, int startIndex, int count) {
        this(count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    @Deprecated
    public CharList(boolean ordered, char[] array, int startIndex, int count) {
        this(array, startIndex, count);
    }

    public CharList(PrimitiveCollection.OfChar coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public CharList(Ordered.OfChar other) {
        this(other.order());
    }

    public CharList(Ordered.OfChar other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(char value) {
        char[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value;
        return true;
    }

    public void add(char value1, char value2) {
        char[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(char value1, char value2, char value3) {
        char[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(char value1, char value2, char value3, char value4) {
        char[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize(Math.max(9, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public boolean addAll(CharList list) {
        return this.addAll(list.items, 0, list.size);
    }

    public boolean addAll(CharList list, int offset, int count) {
        if (offset + count > list.size) {
            throw new IllegalArgumentException("offset + count must be <= list.size: " + offset + " + " + count + " <= " + list.size);
        }
        return this.addAll(list.items, offset, count);
    }

    public boolean addAll(Ordered.OfChar other, int offset, int count) {
        return this.addAll(this.size(), other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered.OfChar other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.insert(insertionIndex++, other.order().get(i));
            changed = true;
        }
        return changed;
    }

    public boolean addAll(char ... array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(char[] array, int offset, int length) {
        int sizeNeeded = this.size + length;
        char[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(array, offset, items, this.size, length);
        this.size += length;
        return true;
    }

    public char get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, char value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void insert(int index, char value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        char[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(items, index, items, index + 1, this.size - index);
        ++this.size;
        items[index] = value;
    }

    public boolean duplicateRange(int index, int count) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, index, this.items, index + count, this.size - index);
        this.size = sizeNeeded;
        return count > 0;
    }

    @Override
    public CharList order() {
        return this;
    }

    @Override
    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        char[] items = this.items;
        char firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    @Override
    public boolean contains(char value) {
        int i = this.size - 1;
        char[] items = this.items;
        while (i >= 0) {
            if (items[i--] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(CharList other) {
        char[] others = other.items;
        int otherSize = other.size;
        for (int i = 0; i < otherSize; ++i) {
            if (this.contains(others[i])) continue;
            return false;
        }
        return true;
    }

    public int indexOf(char value) {
        char[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        char[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(char value) {
        char[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public char removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        char[] items = this.items;
        char value = items[index];
        --this.size;
        System.arraycopy(items, index + 1, items, index, this.size - index);
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        System.arraycopy(this.items, start + count, this.items, start, n - (start + count));
        this.size = n - count;
    }

    @Override
    public boolean removeAll(PrimitiveCollection.OfChar c) {
        int size;
        int startSize = size = this.size;
        char[] items = this.items;
        CharIterator it = c.iterator();
        int n = c.size();
        for (int i = 0; i < n; ++i) {
            char item = it.nextChar();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii--);
                --size;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean removeEach(PrimitiveCollection.OfChar c) {
        int size;
        int startSize = size = this.size;
        char[] items = this.items;
        CharIterator it = c.iterator();
        int n = c.size();
        block0: for (int i = 0; i < n; ++i) {
            char item = it.nextChar();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii);
                --size;
                continue block0;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean retainAll(PrimitiveCollection.OfChar other) {
        int size = this.size;
        char[] items = this.items;
        int w = 0;
        for (int r = 0; r < size; ++r) {
            if (!other.contains(items[r])) continue;
            items[w++] = items[r];
        }
        this.size = w;
        return size != this.size;
    }

    public void replaceAll(CharToCharFunction operator) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.items[i] = operator.applyAsChar(this.items[i]);
        }
    }

    public char pop() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("CharList is empty.");
        }
        return this.items[--this.size];
    }

    public char peek() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("CharList is empty.");
        }
        return this.items[this.size - 1];
    }

    @Override
    public char first() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("CharList is empty.");
        }
        return this.items[0];
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public char[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public char[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public char[] setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected char[] resize(int newSize) {
        char[] newItems = new char[newSize];
        char[] items = this.items;
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    @Override
    public void sort(@Nullable CharComparator c) {
        if (c == null) {
            this.sort();
        } else {
            this.sort(0, this.size, c);
        }
    }

    public void sort(int from, int to, CharComparator c) {
        CharComparators.sort(this.items, from, to, c);
    }

    @Override
    public void reverse() {
        char[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            char temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    @Override
    public void shuffle(Random random) {
        char[] items = this.items;
        for (int i = this.size - 1; i > 0; --i) {
            int ii = random.nextInt(i + 1);
            char temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    @Override
    public char random(Random random) {
        if (this.size == 0) {
            return '\u0000';
        }
        return this.items[random.nextInt(this.size)];
    }

    @Override
    public char[] toArray() {
        char[] array = new char[this.size];
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public char[] toArray(char[] array) {
        if (array.length < this.size) {
            array = new char[this.size];
        }
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public int hashCode() {
        char[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h = h * 31 + items[i];
        }
        return h;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharList)) {
            return false;
        }
        int n = this.size;
        CharList list = (CharList)object;
        if (n != list.size()) {
            return false;
        }
        char[] items1 = this.items;
        char[] items2 = list.items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        char[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("['");
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append("', '");
            buffer.append(items[i]);
        }
        buffer.append("']");
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        char[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items[i]);
        }
        return buffer.toString();
    }

    public String toDenseString() {
        return String.valueOf(this.items, 0, this.size);
    }

    @Override
    public CharListIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new CharListIterator(this);
            this.iterator2 = new CharListIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static CharList with(char item) {
        CharList list = new CharList(1);
        list.add(item);
        return list;
    }

    public static CharList with(char ... array) {
        return new CharList(array);
    }

    public static class CharListIterator
    implements CharIterator {
        protected int index;
        protected int latest = -1;
        protected CharList list;
        protected boolean valid = true;

        public CharListIterator(CharList list) {
            this.list = list;
        }

        public CharListIterator(CharList list, int index) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException("CharListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.list = list;
            this.index = index;
        }

        @Override
        public char nextChar() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index++;
            return this.list.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.list.size();
        }

        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index > 0 && this.list.notEmpty();
        }

        public char previousChar() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index <= 0 || this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.latest = --this.index;
            return this.list.get(this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        public void set(char t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.set(this.latest, t);
        }

        public void add(char t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.insert(this.index, t);
            if (this.list.keepsOrder()) {
                ++this.index;
            }
            this.latest = -1;
        }

        public void reset() {
            this.index = 0;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.list.size()) {
                throw new IndexOutOfBoundsException("CharListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        public CharListIterator iterator() {
            return this;
        }
    }
}

