/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.support.sort.DoubleComparator;
import com.github.tommyettinger.ds.support.sort.DoubleComparators;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.function.DoubleUnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DoubleList
implements PrimitiveCollection.OfDouble,
Ordered.OfDouble,
Arrangeable {
    public double[] items;
    protected int size;
    protected transient @Nullable DoubleListIterator iterator1;
    protected transient @Nullable DoubleListIterator iterator2;

    public boolean keepsOrder() {
        return true;
    }

    public DoubleList() {
        this(10);
    }

    public DoubleList(int capacity) {
        this.items = new double[capacity];
    }

    @Deprecated
    public DoubleList(boolean ordered, int capacity) {
        this(capacity);
    }

    public DoubleList(DoubleList list) {
        this.size = list.size;
        this.items = new double[this.size];
        System.arraycopy(list.items, 0, this.items, 0, this.size);
    }

    public DoubleList(double[] array) {
        this(array, 0, array.length);
    }

    public DoubleList(double[] array, int startIndex, int count) {
        this(count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    @Deprecated
    public DoubleList(boolean ordered, double[] array, int startIndex, int count) {
        this(array, startIndex, count);
    }

    public DoubleList(PrimitiveCollection.OfDouble coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public DoubleList(Ordered.OfDouble other) {
        this(other.order());
    }

    public DoubleList(Ordered.OfDouble other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(double value) {
        double[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value;
        return true;
    }

    public void add(double value1, double value2) {
        double[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(double value1, double value2, double value3) {
        double[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(double value1, double value2, double value3, double value4) {
        double[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize(Math.max(9, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public boolean addAll(DoubleList list) {
        return this.addAll(list.items, 0, list.size);
    }

    public boolean addAll(DoubleList list, int offset, int count) {
        if (offset + count > list.size) {
            throw new IllegalArgumentException("offset + count must be <= list.size: " + offset + " + " + count + " <= " + list.size);
        }
        return this.addAll(list.items, offset, count);
    }

    public boolean addAll(Ordered.OfDouble other, int offset, int count) {
        return this.addAll(this.size(), other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered.OfDouble other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.insert(insertionIndex++, other.order().get(i));
            changed = true;
        }
        return changed;
    }

    public boolean addAll(double ... array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(double[] array, int offset, int length) {
        int sizeNeeded = this.size + length;
        double[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(array, offset, items, this.size, length);
        this.size += length;
        return true;
    }

    public double get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, double value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void plus(int index, double value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] + value;
    }

    public DoubleList plus(double value) {
        double[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] + value;
        }
        return this;
    }

    public void times(int index, double value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] * value;
    }

    public DoubleList times(double value) {
        double[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] * value;
        }
        return this;
    }

    public void minus(int index, double value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] - value;
    }

    public DoubleList minus(double value) {
        double[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] - value;
        }
        return this;
    }

    public void div(int index, double value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] / value;
    }

    public DoubleList div(double value) {
        double[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] / value;
        }
        return this;
    }

    public void rem(int index, double value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] % value;
    }

    public DoubleList rem(double value) {
        double[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] % value;
        }
        return this;
    }

    public void insert(int index, double value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        double[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(items, index, items, index + 1, this.size - index);
        ++this.size;
        items[index] = value;
    }

    public boolean duplicateRange(int index, int count) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, index, this.items, index + count, this.size - index);
        this.size = sizeNeeded;
        return count > 0;
    }

    @Override
    public DoubleList order() {
        return this;
    }

    @Override
    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        double[] items = this.items;
        double firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    @Override
    public boolean contains(double value) {
        int i = this.size - 1;
        double[] items = this.items;
        while (i >= 0) {
            if (items[i--] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(DoubleList other) {
        double[] others = other.items;
        int otherSize = other.size;
        for (int i = 0; i < otherSize; ++i) {
            if (this.contains(others[i])) continue;
            return false;
        }
        return true;
    }

    public int indexOf(double value) {
        double[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double value) {
        double[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(double value) {
        double[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public double removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        double[] items = this.items;
        double value = items[index];
        --this.size;
        System.arraycopy(items, index + 1, items, index, this.size - index);
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        System.arraycopy(this.items, start + count, this.items, start, n - (start + count));
        this.size = n - count;
    }

    @Override
    public boolean removeAll(PrimitiveCollection.OfDouble c) {
        int size;
        int startSize = size = this.size;
        double[] items = this.items;
        PrimitiveIterator.OfDouble it = c.iterator();
        int n = c.size();
        for (int i = 0; i < n; ++i) {
            double item = it.nextDouble();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii--);
                --size;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean removeEach(PrimitiveCollection.OfDouble c) {
        int size;
        int startSize = size = this.size;
        double[] items = this.items;
        PrimitiveIterator.OfDouble it = c.iterator();
        int n = c.size();
        block0: for (int i = 0; i < n; ++i) {
            double item = it.nextDouble();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii);
                --size;
                continue block0;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean retainAll(PrimitiveCollection.OfDouble other) {
        int size = this.size;
        double[] items = this.items;
        int w = 0;
        for (int r = 0; r < size; ++r) {
            if (!other.contains(items[r])) continue;
            items[w++] = items[r];
        }
        this.size = w;
        return size != this.size;
    }

    public void replaceAll(DoubleUnaryOperator operator) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.items[i] = operator.applyAsDouble(this.items[i]);
        }
    }

    public double pop() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("DoubleList is empty.");
        }
        return this.items[--this.size];
    }

    public double peek() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("DoubleList is empty.");
        }
        return this.items[this.size - 1];
    }

    @Override
    public double first() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("DoubleList is empty.");
        }
        return this.items[0];
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public double[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public double[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public double[] setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected double[] resize(int newSize) {
        double[] newItems = new double[newSize];
        double[] items = this.items;
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    @Override
    public void sort(@Nullable DoubleComparator c) {
        if (c == null) {
            this.sort();
        } else {
            this.sort(0, this.size, c);
        }
    }

    public void sort(int from, int to, DoubleComparator c) {
        DoubleComparators.sort(this.items, from, to, c);
    }

    @Override
    public void reverse() {
        double[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            double temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    @Override
    public void shuffle(Random random) {
        double[] items = this.items;
        for (int i = this.size - 1; i > 0; --i) {
            int ii = random.nextInt(i + 1);
            double temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    @Override
    public double random(Random random) {
        if (this.size == 0) {
            return 0.0;
        }
        return this.items[random.nextInt(this.size)];
    }

    @Override
    public double[] toArray() {
        double[] array = new double[this.size];
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public double[] toArray(double[] array) {
        if (array.length < this.size) {
            array = new double[this.size];
        }
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public int hashCode() {
        double[] items = this.items;
        long h = -4521708957497675121L;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h = h * -7046029254386353131L + BitConversion.doubleToRawLongBits((double)items[i]);
        }
        return (int)(h ^ h >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoubleList)) {
            return false;
        }
        int n = this.size;
        DoubleList list = (DoubleList)object;
        if (n != list.size()) {
            return false;
        }
        double[] items1 = this.items;
        double[] items2 = list.items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object, double tolerance) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoubleList)) {
            return false;
        }
        DoubleList array = (DoubleList)object;
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        double[] items1 = this.items;
        double[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(items1[i] - items2[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        double[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        double[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items[i]);
        }
        return buffer.toString();
    }

    @Override
    public DoubleListIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new DoubleListIterator(this);
            this.iterator2 = new DoubleListIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static DoubleList with(double item) {
        DoubleList list = new DoubleList(1);
        list.add(item);
        return list;
    }

    public static DoubleList with(double ... array) {
        return new DoubleList(array);
    }

    public static class DoubleListIterator
    implements PrimitiveIterator.OfDouble {
        protected int index;
        protected int latest = -1;
        protected DoubleList list;
        protected boolean valid = true;

        public DoubleListIterator(DoubleList list) {
            this.list = list;
        }

        public DoubleListIterator(DoubleList list, int index) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException("DoubleListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.list = list;
            this.index = index;
        }

        @Override
        public double nextDouble() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index++;
            return this.list.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.list.size();
        }

        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index > 0 && this.list.notEmpty();
        }

        public double previousDouble() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index <= 0 || this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.latest = --this.index;
            return this.list.get(this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        public void set(double t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.set(this.latest, t);
        }

        public void add(double t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.insert(this.index, t);
            if (this.list.keepsOrder()) {
                ++this.index;
            }
            this.latest = -1;
        }

        public void reset() {
            this.index = 0;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.list.size()) {
                throw new IndexOutOfBoundsException("DoubleListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        public DoubleListIterator iterator() {
            return this;
        }
    }
}

