/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.ds.FloatList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;

public class FloatBag
extends FloatList {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public FloatBag() {
    }

    public FloatBag(int capacity) {
        super(capacity);
    }

    public FloatBag(FloatList list) {
        super(list);
    }

    public FloatBag(float[] array) {
        super(array);
    }

    public FloatBag(float[] array, int startIndex, int count) {
        super(array, startIndex, count);
    }

    public FloatBag(PrimitiveCollection.OfFloat coll) {
        super(coll);
    }

    public FloatBag(Ordered.OfFloat other) {
        super(other);
    }

    public FloatBag(Ordered.OfFloat other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void insert(int index, float element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        float[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = element;
        ++this.size;
    }

    @Override
    public float removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        float[] items = this.items;
        float value = items[index];
        --this.size;
        items[index] = items[this.size];
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        int lastIndex = n - count;
        int i = Math.max(lastIndex, end);
        System.arraycopy(this.items, i, this.items, start, n - i);
        this.size = n - count;
    }

    @Override
    public int hashCode() {
        float[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += BitConversion.floatToRawIntBits((float)items[i]);
        }
        return h ^ h >>> 16;
    }

    public static FloatBag with(float item) {
        FloatBag list = new FloatBag(1);
        list.add(item);
        return list;
    }

    public static FloatBag with(float ... array) {
        return new FloatBag(array);
    }
}

