/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.support.sort.FloatComparator;
import com.github.tommyettinger.ds.support.sort.FloatComparators;
import com.github.tommyettinger.ds.support.util.FloatIterator;
import com.github.tommyettinger.function.FloatToFloatFunction;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FloatList
implements PrimitiveCollection.OfFloat,
Ordered.OfFloat,
Arrangeable {
    public float[] items;
    protected int size;
    protected transient @Nullable FloatListIterator iterator1;
    protected transient @Nullable FloatListIterator iterator2;

    public boolean keepsOrder() {
        return true;
    }

    public FloatList() {
        this(10);
    }

    public FloatList(int capacity) {
        this.items = new float[capacity];
    }

    @Deprecated
    public FloatList(boolean ordered, int capacity) {
        this(capacity);
    }

    public FloatList(FloatList list) {
        this.size = list.size;
        this.items = new float[this.size];
        System.arraycopy(list.items, 0, this.items, 0, this.size);
    }

    public FloatList(float[] array) {
        this(array, 0, array.length);
    }

    public FloatList(float[] array, int startIndex, int count) {
        this(count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    @Deprecated
    public FloatList(boolean ordered, float[] array, int startIndex, int count) {
        this(array, startIndex, count);
    }

    public FloatList(PrimitiveCollection.OfFloat coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public FloatList(Ordered.OfFloat other) {
        this(other.order());
    }

    public FloatList(Ordered.OfFloat other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(float value) {
        float[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value;
        return true;
    }

    public void add(float value1, float value2) {
        float[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(float value1, float value2, float value3) {
        float[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(float value1, float value2, float value3, float value4) {
        float[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize(Math.max(9, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public boolean addAll(FloatList list) {
        return this.addAll(list.items, 0, list.size);
    }

    public boolean addAll(FloatList list, int offset, int count) {
        if (offset + count > list.size) {
            throw new IllegalArgumentException("offset + count must be <= list.size: " + offset + " + " + count + " <= " + list.size);
        }
        return this.addAll(list.items, offset, count);
    }

    public boolean addAll(Ordered.OfFloat other, int offset, int count) {
        return this.addAll(this.size(), other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered.OfFloat other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.insert(insertionIndex++, other.order().get(i));
            changed = true;
        }
        return changed;
    }

    public boolean addAll(float ... array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(float[] array, int offset, int length) {
        int sizeNeeded = this.size + length;
        float[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(array, offset, items, this.size, length);
        this.size += length;
        return true;
    }

    public float get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void plus(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] + value;
    }

    public FloatList plus(float value) {
        float[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] + value;
        }
        return this;
    }

    public void times(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] * value;
    }

    public FloatList times(float value) {
        float[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] * value;
        }
        return this;
    }

    public void minus(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] - value;
    }

    public FloatList minus(float value) {
        float[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] - value;
        }
        return this;
    }

    public void div(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] / value;
    }

    public FloatList div(float value) {
        float[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] / value;
        }
        return this;
    }

    public void rem(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] % value;
    }

    public FloatList rem(float value) {
        float[] items = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items[n2] = items[n2] % value;
        }
        return this;
    }

    public void insert(int index, float value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        float[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(items, index, items, index + 1, this.size - index);
        ++this.size;
        items[index] = value;
    }

    public boolean duplicateRange(int index, int count) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, index, this.items, index + count, this.size - index);
        this.size = sizeNeeded;
        return count > 0;
    }

    @Override
    public FloatList order() {
        return this;
    }

    @Override
    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        float[] items = this.items;
        float firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    @Override
    public boolean contains(float value) {
        int i = this.size - 1;
        float[] items = this.items;
        while (i >= 0) {
            if (items[i--] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(FloatList other) {
        float[] others = other.items;
        int otherSize = other.size;
        for (int i = 0; i < otherSize; ++i) {
            if (this.contains(others[i])) continue;
            return false;
        }
        return true;
    }

    public int indexOf(float value) {
        float[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float value) {
        float[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(float value) {
        float[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public float removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        float[] items = this.items;
        float value = items[index];
        --this.size;
        System.arraycopy(items, index + 1, items, index, this.size - index);
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        System.arraycopy(this.items, start + count, this.items, start, n - (start + count));
        this.size = n - count;
    }

    @Override
    public boolean removeAll(PrimitiveCollection.OfFloat c) {
        int size;
        int startSize = size = this.size;
        float[] items = this.items;
        FloatIterator it = c.iterator();
        int n = c.size();
        for (int i = 0; i < n; ++i) {
            float item = it.nextFloat();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii--);
                --size;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean removeEach(PrimitiveCollection.OfFloat c) {
        int size;
        int startSize = size = this.size;
        float[] items = this.items;
        FloatIterator it = c.iterator();
        int n = c.size();
        block0: for (int i = 0; i < n; ++i) {
            float item = it.nextFloat();
            for (int ii = 0; ii < size; ++ii) {
                if (item != items[ii]) continue;
                this.removeAt(ii);
                --size;
                continue block0;
            }
        }
        return size != startSize;
    }

    @Override
    public boolean retainAll(PrimitiveCollection.OfFloat other) {
        int size = this.size;
        float[] items = this.items;
        int w = 0;
        for (int r = 0; r < size; ++r) {
            if (!other.contains(items[r])) continue;
            items[w++] = items[r];
        }
        this.size = w;
        return size != this.size;
    }

    public void replaceAll(FloatToFloatFunction operator) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.items[i] = operator.applyAsFloat(this.items[i]);
        }
    }

    public float pop() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("FloatList is empty.");
        }
        return this.items[--this.size];
    }

    public float peek() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("FloatList is empty.");
        }
        return this.items[this.size - 1];
    }

    @Override
    public float first() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("FloatList is empty.");
        }
        return this.items[0];
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public float[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public float[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public float[] setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected float[] resize(int newSize) {
        float[] newItems = new float[newSize];
        float[] items = this.items;
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    @Override
    public void sort(@Nullable FloatComparator c) {
        if (c == null) {
            this.sort();
        } else {
            this.sort(0, this.size, c);
        }
    }

    public void sort(int from, int to, FloatComparator c) {
        FloatComparators.sort(this.items, from, to, c);
    }

    @Override
    public void reverse() {
        float[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            float temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    @Override
    public void shuffle(Random random) {
        float[] items = this.items;
        for (int i = this.size - 1; i > 0; --i) {
            int ii = random.nextInt(i + 1);
            float temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    @Override
    public float random(Random random) {
        if (this.size == 0) {
            return 0.0f;
        }
        return this.items[random.nextInt(this.size)];
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.size];
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public float[] toArray(float[] array) {
        if (array.length < this.size) {
            array = new float[this.size];
        }
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    @Override
    public int hashCode() {
        float[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h = h * 31 + BitConversion.floatToRawIntBits((float)items[i]);
        }
        return h ^ h >>> 16;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatList)) {
            return false;
        }
        int n = this.size;
        FloatList list = (FloatList)object;
        if (n != list.size()) {
            return false;
        }
        float[] items1 = this.items;
        float[] items2 = list.items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object, float tolerance) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatList)) {
            return false;
        }
        FloatList array = (FloatList)object;
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        float[] items1 = this.items;
        float[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(items1[i] - items2[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        float[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        float[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items[i]);
        }
        return buffer.toString();
    }

    @Override
    public FloatListIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new FloatListIterator(this);
            this.iterator2 = new FloatListIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static FloatList with(float item) {
        FloatList list = new FloatList(1);
        list.add(item);
        return list;
    }

    public static FloatList with(float ... array) {
        return new FloatList(array);
    }

    public static class FloatListIterator
    implements FloatIterator {
        protected int index;
        protected int latest = -1;
        protected FloatList list;
        protected boolean valid = true;

        public FloatListIterator(FloatList list) {
            this.list = list;
        }

        public FloatListIterator(FloatList list, int index) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException("FloatListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.list = list;
            this.index = index;
        }

        @Override
        public float nextFloat() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index++;
            return this.list.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.list.size();
        }

        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index > 0 && this.list.notEmpty();
        }

        public float previousFloat() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index <= 0 || this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.latest = --this.index;
            return this.list.get(this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        public void set(float t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.set(this.latest, t);
        }

        public void add(float t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.insert(this.index, t);
            if (this.list.keepsOrder()) {
                ++this.index;
            }
            this.latest = -1;
        }

        public void reset() {
            this.index = 0;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.list.size()) {
                throw new IndexOutOfBoundsException("FloatListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        public FloatListIterator iterator() {
            return this;
        }
    }
}

