/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.Utilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HolderSet<T, K>
implements Iterable<T>,
Set<T> {
    protected int size;
    protected T[] keyTable;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable HolderSetIterator<T, K> iterator1;
    protected transient @Nullable HolderSetIterator<T, K> iterator2;
    protected transient @Nullable Function<T, K> extractor;

    public HolderSet() {
        this.loadFactor = Utilities.getDefaultLoadFactor();
        int tableSize = Utilities.tableSize(51, this.loadFactor);
        this.threshold = (int)((float)tableSize * this.loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.extractor = null;
    }

    public HolderSet(Function<T, K> extractor) {
        this(extractor, 51, Utilities.getDefaultLoadFactor());
    }

    public HolderSet(Function<T, K> extractor, int initialCapacity) {
        this(extractor, initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public HolderSet(Function<T, K> extractor, int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.extractor = extractor;
    }

    public HolderSet(HolderSet<T, K> set) {
        this.loadFactor = set.loadFactor;
        this.threshold = set.threshold;
        this.mask = set.mask;
        this.shift = set.shift;
        this.keyTable = Arrays.copyOf(set.keyTable, set.keyTable.length);
        this.size = set.size;
        this.extractor = set.extractor;
        this.hashMultiplier = set.hashMultiplier;
    }

    public HolderSet(Function<T, K> extractor, Collection<? extends T> coll) {
        this(extractor, coll.size());
        this.addAll(coll);
    }

    public HolderSet(Function<T, K> extractor, T[] items) {
        this(extractor, items.length);
        this.addAll(items);
    }

    public @Nullable Function<T, K> getExtractor() {
        return this.extractor;
    }

    public void setExtractor(Function<T, K> extractor) {
        if (this.extractor == null) {
            this.extractor = extractor;
        }
    }

    protected int place(Object item) {
        return (int)((long)item.hashCode() * this.hashMultiplier >>> this.shift);
    }

    protected boolean equate(Object left, @Nullable Object right) {
        return left.equals(right);
    }

    protected int locateKey(Object key) {
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        T other;
        while ((other = keyTable[i]) != null) {
            assert (this.extractor != null);
            if (this.equate(key, this.extractor.apply(other))) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    @Override
    public boolean add(T key) {
        assert (this.extractor != null);
        int i = this.locateKey(this.extractor.apply(key));
        if (i >= 0) {
            return false;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        int length = coll.size();
        this.ensureCapacity(length);
        int oldSize = this.size;
        for (T t : coll) {
            this.add(t);
        }
        return oldSize != this.size;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        boolean modified = false;
        for (T o : this) {
            if (c.contains(o)) continue;
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    public boolean addAll(T[] array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(T[] array, int offset, int length) {
        int i;
        this.ensureCapacity(length);
        int oldSize = this.size;
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
        return oldSize != this.size;
    }

    public boolean addAll(HolderSet<T, ?> set) {
        this.ensureCapacity(set.size);
        T[] keyTable = set.keyTable;
        int oldSize = this.size;
        for (T key : keyTable) {
            if (key == null) continue;
            this.add(key);
        }
        return oldSize != this.size;
    }

    protected void addResize(T key) {
        assert (this.extractor != null);
        T[] keyTable = this.keyTable;
        int i = this.place(this.extractor.apply(key));
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    public boolean remove(Object key) {
        int i = this.locateKey(key);
        if (i < 0) {
            return false;
        }
        assert (this.extractor != null);
        T[] keyTable = this.keyTable;
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != null) {
            Object tk = key;
            int placement = this.place(this.extractor.apply(tk));
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = tk;
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        --this.size;
        return true;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(Math.max(maximumCapacity, this.size), this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    @Override
    public boolean contains(Object key) {
        return this.locateKey(key) >= 0;
    }

    public @Nullable T get(Object key) {
        int i = this.locateKey(key);
        return i < 0 ? null : (T)this.keyTable[i];
    }

    public T first() {
        T[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == null) continue;
            return keyTable[i];
        }
        throw new IllegalStateException("HolderSet is empty.");
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        T[] oldKeyTable = this.keyTable;
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        this.keyTable = new Object[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                T key = oldKeyTable[i];
                if (key == null) continue;
                this.addResize(key);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    @Override
    public Object[] toArray() {
        return this.toArray((E[])new Object[this.size()]);
    }

    @Override
    public <E> E[] toArray(E[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        E[] result = a;
        Iterator<T> it = this.iterator();
        for (int i = 0; i < size; ++i) {
            result[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    @Override
    public int hashCode() {
        int h = this.size;
        for (T key : this.keyTable) {
            if (key == null) continue;
            h += key.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HolderSet)) {
            return false;
        }
        HolderSet other = (HolderSet)obj;
        if (other.size != this.size) {
            return false;
        }
        T[] keyTable = this.keyTable;
        assert (this.extractor != null);
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == null || other.contains(this.extractor.apply(keyTable[i]))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return '{' + this.toString(", ") + '}';
    }

    public String toString(String separator) {
        T key;
        if (this.size == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(32);
        T[] keyTable = this.keyTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append((Object)(key == this ? "(this)" : key));
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append((Object)(key == this ? "(this)" : key));
        }
        return buffer.toString();
    }

    public void truncate(int newSize) {
        T[] keyTable = this.keyTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == null) continue;
            keyTable[i] = null;
            --this.size;
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new HolderSetIterator(this);
            this.iterator2 = new HolderSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static <T, K> HolderSet<T, K> with(Function<T, K> extractor, T item) {
        HolderSet<T, K> set = new HolderSet<T, K>(extractor, 1);
        set.add(item);
        return set;
    }

    @SafeVarargs
    public static <T, K> HolderSet<T, K> with(Function<T, K> extractor, T ... array) {
        return new HolderSet<T, K>(extractor, array);
    }

    public static class HolderSetIterator<T, K>
    implements Iterable<T>,
    Iterator<T> {
        public boolean hasNext;
        final HolderSet<T, K> set;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public HolderSetIterator(HolderSet<T, K> set) {
            this.set = set;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        private void findNextIndex() {
            T[] keyTable = this.set.keyTable;
            int n = this.set.keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object key;
            int i = this.currentIndex;
            if (i < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            T[] keyTable = this.set.keyTable;
            int mask = this.set.mask;
            int next = i + 1 & mask;
            while ((key = keyTable[next]) != null) {
                assert (this.set.extractor != null);
                int placement = this.set.place(this.set.extractor.apply(key));
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            --this.set.size;
            if (i != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object key = this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public HolderSetIterator<T, K> iterator() {
            return this;
        }

        public ObjectList<T> toList() {
            ObjectList list = new ObjectList(this.set.size);
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                list.add(this.next());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return list;
        }
    }
}

