/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectObjectMap;
import com.github.tommyettinger.ds.ObjectObjectOrderedMap;
import java.util.Collection;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IdentityObjectOrderedMap<K, V>
extends ObjectObjectOrderedMap<K, V> {
    public IdentityObjectOrderedMap() {
    }

    public IdentityObjectOrderedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentityObjectOrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentityObjectOrderedMap(ObjectObjectOrderedMap<? extends K, ? extends V> map) {
        super(map);
    }

    public IdentityObjectOrderedMap(ObjectObjectMap<? extends K, ? extends V> map) {
        super(map);
    }

    public IdentityObjectOrderedMap(Map<? extends K, ? extends V> map) {
        super(map);
    }

    public IdentityObjectOrderedMap(K[] keys, V[] values) {
        super(keys, values);
    }

    public IdentityObjectOrderedMap(Collection<? extends K> keys, Collection<? extends V> values) {
        super(keys, values);
    }

    public IdentityObjectOrderedMap(ObjectObjectOrderedMap<? extends K, ? extends V> other, int offset, int count) {
        this(count);
        this.putAll(0, other, offset, count);
    }

    @Override
    protected int place(Object item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    protected boolean equate(Object left, @Nullable Object right) {
        return left == right;
    }

    @Override
    public int hashCode() {
        int h = this.size;
        Object[] keyTable = this.keyTable;
        Object[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            Object key = keyTable[i];
            if (key == null) continue;
            h ^= System.identityHashCode(key);
            Object value = valueTable[i];
            if (value == null) continue;
            h ^= value.hashCode();
        }
        return h;
    }

    @Override
    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    @Override
    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
    }

    public static <K, V> IdentityObjectOrderedMap<K, V> with(K key0, V value0) {
        IdentityObjectOrderedMap<K, V> map = new IdentityObjectOrderedMap<K, V>(1);
        map.put(key0, value0);
        return map;
    }

    public static <K, V> IdentityObjectOrderedMap<K, V> with(K key0, V value0, Object ... rest) {
        IdentityObjectOrderedMap<Object, Object> map = new IdentityObjectOrderedMap<Object, Object>(1 + (rest.length >>> 1));
        map.put(key0, value0);
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put(rest[i - 1], rest[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }
}

