/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectOrderedSet;
import com.github.tommyettinger.ds.Ordered;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IdentityOrderedSet<T>
extends ObjectOrderedSet<T> {
    public IdentityOrderedSet() {
    }

    public IdentityOrderedSet(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentityOrderedSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentityOrderedSet(ObjectOrderedSet<? extends T> set) {
        super(set);
    }

    public IdentityOrderedSet(Collection<? extends T> coll) {
        super(coll);
    }

    public IdentityOrderedSet(T[] array, int offset, int length) {
        super(array, offset, length);
    }

    public IdentityOrderedSet(T[] array) {
        super(array);
    }

    public IdentityOrderedSet(Ordered<T> other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    protected int place(Object item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    protected boolean equate(Object left, @Nullable Object right) {
        return left == right;
    }

    @Override
    public int hashCode() {
        int h = this.size;
        for (Object key : this.keyTable) {
            if (key == null) continue;
            h += System.identityHashCode(key);
        }
        return h;
    }

    @Override
    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    @Override
    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
    }

    public static <T> IdentityOrderedSet<T> with(T item) {
        IdentityOrderedSet<T> set = new IdentityOrderedSet<T>(1);
        set.add(item);
        return set;
    }

    @SafeVarargs
    public static <T> IdentityOrderedSet<T> with(T ... array) {
        return new IdentityOrderedSet<T>(array);
    }
}

