/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectSet;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IdentitySet<T>
extends ObjectSet<T> {
    public IdentitySet() {
    }

    public IdentitySet(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentitySet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentitySet(ObjectSet<? extends T> set) {
        super(set);
    }

    public IdentitySet(Collection<? extends T> coll) {
        super(coll);
    }

    public IdentitySet(T[] array, int offset, int length) {
        super(array, offset, length);
    }

    public IdentitySet(T[] array) {
        super(array);
    }

    @Override
    protected int place(Object item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    protected boolean equate(Object left, @Nullable Object right) {
        return left == right;
    }

    @Override
    public int hashCode() {
        int h = this.size;
        for (Object key : this.keyTable) {
            if (key == null) continue;
            h += System.identityHashCode(key);
        }
        return h;
    }

    @Override
    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    @Override
    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
    }

    public static <T> IdentitySet<T> with(T item) {
        IdentitySet<T> set = new IdentitySet<T>(1);
        set.add(item);
        return set;
    }

    @SafeVarargs
    public static <T> IdentitySet<T> with(T ... array) {
        return new IdentitySet<T>(array);
    }
}

