/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;

public class IntBag
extends IntList {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public IntBag() {
    }

    public IntBag(int capacity) {
        super(capacity);
    }

    public IntBag(IntList list) {
        super(list);
    }

    public IntBag(int[] array) {
        super(array);
    }

    public IntBag(int[] array, int startIndex, int count) {
        super(array, startIndex, count);
    }

    public IntBag(PrimitiveCollection.OfInt coll) {
        super(coll);
    }

    public IntBag(Ordered.OfInt other) {
        super(other);
    }

    public IntBag(Ordered.OfInt other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void insert(int index, int element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = element;
        ++this.size;
    }

    @Override
    public int removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int[] items = this.items;
        int value = items[index];
        --this.size;
        items[index] = items[this.size];
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        int lastIndex = n - count;
        int i = Math.max(lastIndex, end);
        System.arraycopy(this.items, i, this.items, start, n - i);
        this.size = n - count;
    }

    @Override
    public int hashCode() {
        int[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += items[i];
        }
        return h;
    }

    public static IntBag with(int item) {
        IntBag list = new IntBag(1);
        list.add(item);
        return list;
    }

    public static IntBag with(int ... array) {
        return new IntBag(array);
    }
}

