/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.IntIntMap;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import com.github.tommyettinger.ds.support.sort.IntComparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IntIntOrderedMap
extends IntIntMap
implements Ordered.OfInt {
    protected final IntList keys;

    public IntIntOrderedMap() {
        this.keys = new IntList();
    }

    public IntIntOrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.keys = new IntList(initialCapacity);
    }

    public IntIntOrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.keys = new IntList(initialCapacity);
    }

    public IntIntOrderedMap(IntIntOrderedMap map) {
        super(map);
        this.keys = new IntList(map.keys);
    }

    public IntIntOrderedMap(IntIntMap map) {
        this(map.size());
        PrimitiveIterator.OfInt it = map.keySet().iterator();
        while (it.hasNext()) {
            int k = it.nextInt();
            this.put(k, map.get(k));
        }
    }

    public IntIntOrderedMap(int[] keys, int[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    public IntIntOrderedMap(PrimitiveCollection.OfInt keys, PrimitiveCollection.OfInt values) {
        this(Math.min(keys.size(), values.size()));
        this.putAll(keys, values);
    }

    public IntIntOrderedMap(IntIntOrderedMap other, int offset, int count) {
        this(count);
        this.putAll(0, other, offset, count);
    }

    @Override
    public int put(int key, int value) {
        if (key == 0) {
            int oldValue = this.defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                this.keys.add(0);
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return this.defaultValue;
    }

    public int put(int key, int value, int index) {
        if (key == 0) {
            int oldValue = this.defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
                int oldIndex = this.keys.indexOf(key);
                if (oldIndex != index) {
                    this.keys.insert(index, this.keys.removeAt(oldIndex));
                }
            } else {
                this.keys.insert(index, 0);
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            int oldIndex = this.keys.indexOf(key);
            if (oldIndex != index) {
                this.keys.insert(index, this.keys.removeAt(oldIndex));
            }
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.insert(index, key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return this.defaultValue;
    }

    @Override
    public int putOrDefault(int key, int value, int defaultValue) {
        if (key == 0) {
            int oldValue = defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
                this.keys.add(key);
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(IntIntOrderedMap map) {
        this.ensureCapacity(map.size);
        IntList ks = map.keys;
        int kl = ks.size();
        for (int i = 0; i < kl; ++i) {
            int k = ks.get(i);
            this.put(k, map.get(k));
        }
    }

    public void putAll(IntIntOrderedMap other, int offset, int count) {
        this.putAll(this.size, other, offset, count);
    }

    public void putAll(int insertionIndex, IntIntOrderedMap other, int offset, int count) {
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.put(other.keyAt(i), other.getAt(i), insertionIndex++);
        }
    }

    @Override
    public int remove(int key) {
        if (!super.containsKey(key)) {
            return this.defaultValue;
        }
        this.keys.remove(key);
        return super.remove(key);
    }

    public int removeAt(int index) {
        return super.remove(this.keys.removeAt(index));
    }

    @Override
    public void removeRange(int start, int end) {
        start = Math.max(0, start);
        end = Math.min(this.keys.size(), end);
        for (int i = start; i < end; ++i) {
            super.remove(this.keys.get(i));
        }
        this.keys.removeRange(start, end);
    }

    @Override
    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.removeRange(newSize, this.size);
        }
    }

    @Override
    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
        this.keys.ensureCapacity(additionalCapacity);
    }

    @Override
    public int getAndIncrement(int key, int defaultValue, int increment) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            int n = i;
            this.valueTable[n] = this.valueTable[n] + increment;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = defaultValue + increment;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public boolean alter(int before, int after) {
        if (this.containsKey(after)) {
            return false;
        }
        int index = this.keys.indexOf(before);
        if (index == -1) {
            return false;
        }
        super.put(after, super.remove(before));
        this.keys.set(index, after);
        return true;
    }

    public boolean alterAt(int index, int after) {
        if (index < 0 || index >= this.size || this.containsKey(after)) {
            return false;
        }
        super.put(after, super.remove(this.keys.get(index)));
        this.keys.set(index, after);
        return true;
    }

    public int setAt(int index, int v) {
        if (index < 0 || index >= this.size) {
            return this.defaultValue;
        }
        int pos = this.locateKey(this.keys.get(index));
        int oldValue = this.valueTable[pos];
        this.valueTable[pos] = v;
        return oldValue;
    }

    public int getAt(int index) {
        return this.get(this.keys.get(index));
    }

    public int keyAt(int index) {
        return this.keys.get(index);
    }

    @Override
    public void clear(int maximumCapacity) {
        this.keys.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    @Override
    public IntList order() {
        return this.keys;
    }

    public void sort() {
        this.keys.sort();
    }

    @Override
    public void sort(@Nullable IntComparator comp) {
        this.keys.sort(comp);
    }

    public void sortByValue(IntComparator comp) {
        this.keys.sort((a, b) -> comp.compare(this.get(a), this.get(b)));
    }

    @Override
    public IntIntMap.Keys keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new OrderedMapKeys(this);
            this.keys2 = new OrderedMapKeys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    @Override
    public IntIntMap.Values values() {
        if (this.values1 == null || this.values2 == null) {
            this.values1 = new OrderedMapValues(this);
            this.values2 = new OrderedMapValues(this);
        }
        if (!this.values1.iter.valid) {
            this.values1.iter.reset();
            this.values1.iter.valid = true;
            this.values2.iter.valid = false;
            return this.values1;
        }
        this.values2.iter.reset();
        this.values2.iter.valid = true;
        this.values1.iter.valid = false;
        return this.values2;
    }

    @Override
    public IntIntMap.Entries entrySet() {
        if (this.entries1 == null || this.entries2 == null) {
            this.entries1 = new OrderedMapEntries(this);
            this.entries2 = new OrderedMapEntries(this);
        }
        if (!this.entries1.iter.valid) {
            this.entries1.iter.reset();
            this.entries1.iter.valid = true;
            this.entries2.iter.valid = false;
            return this.entries1;
        }
        this.entries2.iter.reset();
        this.entries2.iter.valid = true;
        this.entries1.iter.valid = false;
        return this.entries2;
    }

    @Override
    public Iterator<IntIntMap.Entry> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    protected String toString(String separator, boolean braces) {
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        IntList keys = this.keys;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            int key = keys.get(i);
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(key);
            buffer.append('=');
            int value = this.get(key);
            buffer.append(value);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public static IntIntOrderedMap with(Number key0, Number value0) {
        IntIntOrderedMap map = new IntIntOrderedMap(1);
        map.put(key0.intValue(), value0.intValue());
        return map;
    }

    public static IntIntOrderedMap with(Number key0, Number value0, Number ... rest) {
        IntIntOrderedMap map = new IntIntOrderedMap(1 + (rest.length >>> 1));
        map.put(key0.intValue(), value0.intValue());
        for (int i = 1; i < rest.length; i += 2) {
            map.put(rest[i - 1].intValue(), rest[i].intValue());
        }
        return map;
    }

    public static IntIntOrderedMap with(int key0, int value0) {
        IntIntOrderedMap map = new IntIntOrderedMap(1);
        map.put(key0, value0);
        return map;
    }

    public static IntIntOrderedMap with(int key0, int value0, int ... rest) {
        IntIntOrderedMap map = new IntIntOrderedMap(1 + (rest.length >>> 1));
        map.put(key0, value0);
        for (int i = 1; i < rest.length; i += 2) {
            map.put(rest[i - 1], rest[i]);
        }
        return map;
    }

    public static class OrderedMapKeys
    extends IntIntMap.Keys {
        private final IntList keys;

        public OrderedMapKeys(IntIntOrderedMap map) {
            super(map);
            this.keys = map.keys;
            this.iter = new IntIntMap.KeyIterator(map){

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public int nextInt() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    int key = keys.get(this.nextIndex);
                    this.currentIndex = this.nextIndex++;
                    this.hasNext = this.nextIndex < this.map.size;
                    return key;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(keys.get(this.currentIndex));
                    this.nextIndex = this.currentIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return this.iter;
        }
    }

    public static class OrderedMapValues
    extends IntIntMap.Values {
        private final IntList keys;

        public OrderedMapValues(IntIntOrderedMap map) {
            super(map);
            this.keys = map.keys;
            this.iter = new IntIntMap.ValueIterator(map){

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public int nextInt() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    int value = this.map.get(keys.get(this.nextIndex));
                    this.currentIndex = this.nextIndex++;
                    this.hasNext = this.nextIndex < this.map.size;
                    return value;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(keys.get(this.currentIndex));
                    this.nextIndex = this.currentIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return this.iter;
        }
    }

    public static class OrderedMapEntries
    extends IntIntMap.Entries {
        protected IntList keys;

        public OrderedMapEntries(IntIntOrderedMap map) {
            super(map);
            this.keys = map.keys;
            this.iter = new IntIntMap.EntryIterator(map){

                @Override
                public Iterator<IntIntMap.Entry> iterator() {
                    return this;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public IntIntMap.Entry next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    this.currentIndex = this.nextIndex;
                    this.entry.key = keys.get(this.nextIndex);
                    this.entry.value = this.map.get(this.entry.key);
                    ++this.nextIndex;
                    this.hasNext = this.nextIndex < this.map.size;
                    return this.entry;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(this.entry.key);
                    --this.nextIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public Iterator<IntIntMap.Entry> iterator() {
            return this.iter;
        }
    }
}

