/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import com.github.tommyettinger.function.IntLongBiConsumer;
import com.github.tommyettinger.function.IntLongToLongBiFunction;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntToLongFunction;
import java.util.function.LongBinaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IntLongMap
implements Iterable<Entry> {
    protected int size;
    protected int[] keyTable;
    protected long[] valueTable;
    protected boolean hasZeroValue;
    protected long zeroValue;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable Entries entries1;
    protected transient @Nullable Entries entries2;
    protected transient @Nullable Values values1;
    protected transient @Nullable Values values2;
    protected transient @Nullable Keys keys1;
    protected transient @Nullable Keys keys2;
    public long defaultValue = 0L;

    public IntLongMap() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public IntLongMap(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public IntLongMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[tableSize];
        this.valueTable = new long[tableSize];
    }

    public IntLongMap(IntLongMap map) {
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size = map.size;
        this.defaultValue = map.defaultValue;
        this.zeroValue = map.zeroValue;
        this.hasZeroValue = map.hasZeroValue;
        this.hashMultiplier = map.hashMultiplier;
    }

    public IntLongMap(int[] keys, long[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    public IntLongMap(PrimitiveCollection.OfInt keys, PrimitiveCollection.OfLong values) {
        this(Math.min(keys.size(), values.size()));
        this.putAll(keys, values);
    }

    public void putAll(PrimitiveCollection.OfInt keys, PrimitiveCollection.OfLong values) {
        int length = Math.min(keys.size(), values.size());
        this.ensureCapacity(length);
        PrimitiveIterator.OfInt ki = keys.iterator();
        PrimitiveIterator.OfLong vi = values.iterator();
        while (ki.hasNext() && vi.hasNext()) {
            this.put(ki.next(), vi.next());
        }
    }

    protected int place(int item) {
        return (int)((long)item * this.hashMultiplier >>> this.shift);
    }

    protected int locateKey(int key) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    public long put(int key, long value) {
        if (key == 0) {
            long oldValue = this.defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            long oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return this.defaultValue;
    }

    public long putOrDefault(int key, long value, long defaultValue) {
        if (key == 0) {
            long oldValue = defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            long oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(IntLongMap map) {
        this.ensureCapacity(map.size);
        if (map.hasZeroValue) {
            if (!this.hasZeroValue) {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = map.zeroValue;
        }
        int[] keyTable = map.keyTable;
        long[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0) continue;
            this.put(key, valueTable[i]);
        }
    }

    public void putAll(int[] keys, long[] values) {
        this.putAll(keys, 0, values, 0, Math.min(keys.length, values.length));
    }

    public void putAll(int[] keys, long[] values, int length) {
        this.putAll(keys, 0, values, 0, length);
    }

    public void putAll(int[] keys, int keyOffset, long[] values, int valueOffset, int length) {
        length = Math.min(length, Math.min(keys.length - keyOffset, values.length - valueOffset));
        this.ensureCapacity(length);
        int k = keyOffset;
        int v = valueOffset;
        int i = 0;
        int n = length;
        while (i < n) {
            this.put(keys[k], values[v]);
            ++i;
            ++k;
            ++v;
        }
    }

    protected void putResize(int key, long value) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public long get(int key) {
        if (key == 0) {
            return this.hasZeroValue ? this.zeroValue : this.defaultValue;
        }
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & this.mask;
        }
        return this.defaultValue;
    }

    public long getOrDefault(int key, long defaultValue) {
        if (key == 0) {
            return this.hasZeroValue ? this.zeroValue : defaultValue;
        }
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & this.mask;
        }
        return defaultValue;
    }

    public long getAndIncrement(int key, long defaultValue, long increment) {
        if (key == 0) {
            if (this.hasZeroValue) {
                long old = this.zeroValue;
                this.zeroValue += increment;
                return old;
            }
            this.hasZeroValue = true;
            this.zeroValue = defaultValue + increment;
            ++this.size;
            return defaultValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            long oldValue = this.valueTable[i];
            int n = i;
            this.valueTable[n] = this.valueTable[n] + increment;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = defaultValue + increment;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public long remove(int key) {
        int rem;
        if (key == 0) {
            if (this.hasZeroValue) {
                this.hasZeroValue = false;
                --this.size;
                return this.zeroValue;
            }
            return this.defaultValue;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return this.defaultValue;
        }
        int[] keyTable = this.keyTable;
        long[] valueTable = this.valueTable;
        long oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((rem = keyTable[next]) != 0) {
            int placement = this.place(rem);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = rem;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0;
        --this.size;
        return oldValue;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(Math.max(maximumCapacity, this.size), this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0);
    }

    public boolean containsValue(long value) {
        if (this.hasZeroValue && this.zeroValue == value) {
            return true;
        }
        long[] valueTable = this.valueTable;
        int[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == 0 || valueTable[i] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int key) {
        if (key == 0) {
            return this.hasZeroValue;
        }
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    public int findKey(long value, int defaultKey) {
        if (this.hasZeroValue && this.zeroValue == value) {
            return 0;
        }
        long[] valueTable = this.valueTable;
        int[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == 0 || valueTable[i] != value) continue;
            return keyTable[i];
        }
        return defaultKey;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        int[] oldKeyTable = this.keyTable;
        long[] oldValueTable = this.valueTable;
        this.keyTable = new int[newSize];
        this.valueTable = new long[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                int key = oldKeyTable[i];
                if (key == 0) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    public int hashCode() {
        long h = this.hasZeroValue ? this.zeroValue + (long)this.size : (long)this.size;
        int[] keyTable = this.keyTable;
        long[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0) continue;
            h += (long)key * -7046029254386353131L;
            h += valueTable[i];
        }
        return (int)(h ^ h >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntLongMap)) {
            return false;
        }
        IntLongMap other = (IntLongMap)obj;
        if (other.size != this.size) {
            return false;
        }
        if (other.hasZeroValue != this.hasZeroValue || other.zeroValue != this.zeroValue) {
            return false;
        }
        int[] keyTable = this.keyTable;
        long[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            long value;
            int key = keyTable[i];
            if (key == 0 || (value = valueTable[i]) == other.get(key)) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String separator, boolean braces) {
        long value;
        int key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        if (this.hasZeroValue) {
            buffer.append("0=").append(this.zeroValue);
            if (this.size > 1) {
                buffer.append(separator);
            }
        }
        int[] keyTable = this.keyTable;
        long[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0) continue;
            buffer.append(key);
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0) continue;
            buffer.append(separator);
            buffer.append(key);
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public void forEach(IntLongBiConsumer action) {
        for (Entry entry : this.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public void replaceAll(IntLongToLongBiFunction function) {
        for (Entry entry : this.entrySet()) {
            entry.setValue(function.applyAsLong(entry.getKey(), entry.getValue()));
        }
    }

    public void truncate(int newSize) {
        int[] keyTable = this.keyTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == 0) continue;
            keyTable[i] = 0;
            --this.size;
        }
        if (this.hasZeroValue && this.size > newSize) {
            this.hasZeroValue = false;
            --this.size;
        }
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entrySet().iterator();
    }

    public Keys keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    public Values values() {
        if (this.values1 == null || this.values2 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.iter.valid) {
            this.values1.iter.reset();
            this.values1.iter.valid = true;
            this.values2.iter.valid = false;
            return this.values1;
        }
        this.values2.iter.reset();
        this.values2.iter.valid = true;
        this.values1.iter.valid = false;
        return this.values2;
    }

    public Entries entrySet() {
        if (this.entries1 == null || this.entries2 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.iter.valid) {
            this.entries1.iter.reset();
            this.entries1.iter.valid = true;
            this.entries2.iter.valid = false;
            return this.entries1;
        }
        this.entries2.iter.reset();
        this.entries2.iter.valid = true;
        this.entries1.iter.valid = false;
        return this.entries2;
    }

    public long putIfAbsent(int key, long value) {
        if (key == 0) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return this.put(key, value);
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            return this.valueTable[i];
        }
        return this.put(key, value);
    }

    public boolean replace(int key, long oldValue, long newValue) {
        long curValue = this.get(key);
        if (curValue != oldValue || !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    public long replace(int key, long value) {
        if (key == 0) {
            if (this.hasZeroValue) {
                long oldValue = this.zeroValue;
                this.zeroValue = value;
                return oldValue;
            }
            return this.defaultValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            long oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        return this.defaultValue;
    }

    public long computeIfAbsent(int key, IntToLongFunction mappingFunction) {
        int i = this.locateKey(key);
        if (i < 0) {
            long newValue = mappingFunction.applyAsLong(key);
            this.put(key, newValue);
            return newValue;
        }
        return this.valueTable[i];
    }

    public boolean remove(int key, long value) {
        int i = this.locateKey(key);
        if (i >= 0 && this.valueTable[i] == value) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public long merge(int key, long value, LongBinaryOperator remappingFunction) {
        int i = this.locateKey(key);
        long next = i < 0 ? value : remappingFunction.applyAsLong(this.valueTable[i], value);
        this.put(key, next);
        return next;
    }

    public static IntLongMap with(Number key0, Number value0) {
        IntLongMap map = new IntLongMap(1);
        map.put(key0.intValue(), value0.longValue());
        return map;
    }

    public static IntLongMap with(Number key0, Number value0, Number ... rest) {
        IntLongMap map = new IntLongMap(1 + (rest.length >>> 1));
        map.put(key0.intValue(), value0.longValue());
        for (int i = 1; i < rest.length; i += 2) {
            map.put(rest[i - 1].intValue(), rest[i].longValue());
        }
        return map;
    }

    public static class Entries
    extends AbstractSet<Entry> {
        protected EntryIterator iter;

        public Entries(IntLongMap map) {
            this.iter = new EntryIterator(map);
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public ObjectList<Entry> toList() {
            ObjectList<Entry> list = new ObjectList<Entry>(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(new Entry(this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<Entry> appendInto(Collection<Entry> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(new Entry(this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        public IntLongMap appendInto(IntLongMap coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                this.iter.next();
                coll.put(this.iter.entry.key, this.iter.entry.value);
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    public static class Entry {
        public int key;
        public long value;

        public Entry() {
        }

        public Entry(int key, long value) {
            this.key = key;
            this.value = value;
        }

        public Entry(Entry entry) {
            this.key = entry.key;
            this.value = entry.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public int getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public long setValue(long value) {
            long old = this.value;
            this.value = value;
            return old;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.key != entry.key) {
                return false;
            }
            return this.value == entry.value;
        }

        public int hashCode() {
            return (int)((long)this.key + (this.value ^ this.value >>> 32));
        }
    }

    public static class Keys
    implements PrimitiveCollection.OfInt {
        protected KeyIterator iter;

        public Keys(IntLongMap map) {
            this.iter = new KeyIterator(map);
        }

        @Override
        public boolean add(int item) {
            throw new UnsupportedOperationException("IntLongMap.Keys is read-only");
        }

        @Override
        public boolean remove(int item) {
            throw new UnsupportedOperationException("IntLongMap.Keys is read-only");
        }

        @Override
        public boolean contains(int item) {
            return this.iter.map.containsKey(item);
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return this.iter;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("IntLongMap.Keys is read-only");
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public IntList toList() {
            IntList list = new IntList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.nextInt());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public PrimitiveCollection.OfInt appendInto(PrimitiveCollection.OfInt coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.nextInt());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        @Override
        public boolean equals(Object other) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            boolean eq = PrimitiveCollection.OfInt.super.areEqual(other);
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return eq;
        }
    }

    public static class KeyIterator
    extends MapIterator
    implements PrimitiveIterator.OfInt {
        public KeyIterator(IntLongMap map) {
            super(map);
        }

        @Override
        public int nextInt() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int key = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public IntList toList() {
            IntList list = new IntList(true, this.map.size);
            while (this.hasNext) {
                list.add(this.nextInt());
            }
            return list;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    public static class Values
    implements PrimitiveCollection.OfLong {
        protected ValueIterator iter;

        @Override
        public boolean add(long item) {
            throw new UnsupportedOperationException("IntLongMap.Values is read-only");
        }

        @Override
        public boolean remove(long item) {
            throw new UnsupportedOperationException("IntLongMap.Values is read-only");
        }

        @Override
        public boolean contains(long item) {
            return this.iter.map.containsValue(item);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("IntLongMap.Values is read-only");
        }

        @Override
        public PrimitiveIterator.OfLong iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        public Values(IntLongMap map) {
            this.iter = new ValueIterator(map);
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public LongList toList() {
            LongList list = new LongList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.nextLong());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public PrimitiveCollection.OfLong appendInto(PrimitiveCollection.OfLong coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.nextLong());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        @Override
        public boolean equals(Object other) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            boolean eq = PrimitiveCollection.OfLong.super.areEqual(other);
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return eq;
        }
    }

    public static class ValueIterator
    extends MapIterator
    implements PrimitiveIterator.OfLong {
        public ValueIterator(IntLongMap map) {
            super(map);
        }

        @Override
        public long nextLong() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long value = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return value;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    public static class EntryIterator
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        protected Entry entry = new Entry();

        public EntryIterator(IntLongMap map) {
            super(map);
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int[] keyTable = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = keyTable[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    protected static abstract class MapIterator {
        protected static final int INDEX_ILLEGAL = -2;
        protected static final int INDEX_ZERO = -1;
        public boolean hasNext;
        protected final IntLongMap map;
        protected int nextIndex;
        protected int currentIndex;
        protected boolean valid = true;

        public MapIterator(IntLongMap map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            int[] keyTable = this.map.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == 0) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
            } else {
                int key;
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] keyTable = this.map.keyTable;
                long[] valueTable = this.map.valueTable;
                int mask = this.map.mask;
                int next = i + 1 & mask;
                while ((key = keyTable[next]) != 0) {
                    int placement = this.map.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        valueTable[i] = valueTable[next];
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0;
                if (i != this.currentIndex) {
                    --this.nextIndex;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }
}

