/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.IntObjectMap;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import com.github.tommyettinger.ds.support.sort.IntComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IntObjectOrderedMap<V>
extends IntObjectMap<V>
implements Ordered.OfInt {
    protected final IntList keys;

    public IntObjectOrderedMap() {
        this.keys = new IntList();
    }

    public IntObjectOrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.keys = new IntList(initialCapacity);
    }

    public IntObjectOrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.keys = new IntList(initialCapacity);
    }

    public IntObjectOrderedMap(IntObjectOrderedMap<? extends V> map) {
        super(map);
        this.keys = new IntList(map.keys);
    }

    public IntObjectOrderedMap(int[] keys, V[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    public IntObjectOrderedMap(IntObjectMap<? extends V> map) {
        this(map.size());
        PrimitiveIterator.OfInt it = map.keySet().iterator();
        while (it.hasNext()) {
            int k = it.nextInt();
            this.put(k, map.get(k));
        }
    }

    public IntObjectOrderedMap(PrimitiveCollection.OfInt keys, Collection<? extends V> values) {
        this(Math.min(keys.size(), values.size()));
        this.putAll(keys, values);
    }

    public IntObjectOrderedMap(IntObjectOrderedMap<? extends V> other, int offset, int count) {
        this(count);
        this.putAll(0, other, offset, count);
    }

    @Override
    public V put(int key, @Nullable V value) {
        if (key == 0) {
            Object oldValue = this.defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                this.keys.add(0);
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return (V)oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return (V)oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return (V)this.defaultValue;
    }

    public @Nullable V put(int key, @Nullable V value, int index) {
        if (key == 0) {
            Object oldValue = this.defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
                int oldIndex = this.keys.indexOf(key);
                if (oldIndex != index) {
                    this.keys.insert(index, this.keys.removeAt(oldIndex));
                }
            } else {
                this.keys.insert(index, 0);
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return (V)oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            int oldIndex = this.keys.indexOf(key);
            if (oldIndex != index) {
                this.keys.insert(index, this.keys.removeAt(oldIndex));
            }
            return (V)oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.insert(index, key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    @Override
    public @Nullable V putOrDefault(int key, @Nullable V value, @Nullable V defaultValue) {
        if (key == 0) {
            Object oldValue = defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
                this.keys.add(key);
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return (V)oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    @Override
    public void putAll(IntObjectOrderedMap<? extends V> map) {
        this.ensureCapacity(map.size);
        IntList ks = map.keys;
        int kl = ks.size();
        for (int i = 0; i < kl; ++i) {
            int k = ks.get(i);
            this.put(k, map.get(k));
        }
    }

    public void putAll(IntObjectOrderedMap<? extends V> other, int offset, int count) {
        this.putAll(this.size, other, offset, count);
    }

    public void putAll(int insertionIndex, IntObjectOrderedMap<? extends V> other, int offset, int count) {
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.put(other.keyAt(i), other.getAt(i), insertionIndex++);
        }
    }

    @Override
    public @Nullable V remove(int key) {
        if (!super.containsKey(key)) {
            return (V)this.defaultValue;
        }
        this.keys.remove(key);
        return super.remove(key);
    }

    public @Nullable V removeAt(int index) {
        return super.remove(this.keys.removeAt(index));
    }

    @Override
    public void removeRange(int start, int end) {
        start = Math.max(0, start);
        end = Math.min(this.keys.size(), end);
        for (int i = start; i < end; ++i) {
            super.remove(this.keys.get(i));
        }
        this.keys.removeRange(start, end);
    }

    @Override
    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.removeRange(newSize, this.size);
        }
    }

    @Override
    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
        this.keys.ensureCapacity(additionalCapacity);
    }

    public boolean alter(int before, int after) {
        if (this.containsKey(after)) {
            return false;
        }
        int index = this.keys.indexOf(before);
        if (index == -1) {
            return false;
        }
        super.put(after, super.remove(before));
        this.keys.set(index, after);
        return true;
    }

    public boolean alterAt(int index, int after) {
        if (index < 0 || index >= this.size || this.containsKey(after)) {
            return false;
        }
        super.put(after, super.remove(this.keys.get(index)));
        this.keys.set(index, after);
        return true;
    }

    public @Nullable V setAt(int index, V v) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        int pos = this.locateKey(this.keys.get(index));
        Object oldValue = this.valueTable[pos];
        this.valueTable[pos] = v;
        return (V)oldValue;
    }

    public @Nullable V getAt(int index) {
        return this.get(this.keys.get(index));
    }

    public int keyAt(int index) {
        return this.keys.get(index);
    }

    @Override
    public void clear(int maximumCapacity) {
        this.keys.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    @Override
    public IntList order() {
        return this.keys;
    }

    public void sort() {
        this.keys.sort();
    }

    @Override
    public void sort(@Nullable IntComparator comp) {
        this.keys.sort(comp);
    }

    public void sortByValue(Comparator<V> comp) {
        this.keys.sort((a, b) -> comp.compare(this.get(a), this.get(b)));
    }

    @Override
    public IntObjectMap.Keys<V> keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new OrderedMapKeys(this);
            this.keys2 = new OrderedMapKeys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    @Override
    public IntObjectMap.Values<V> values() {
        if (this.values1 == null || this.values2 == null) {
            this.values1 = new OrderedMapValues(this);
            this.values2 = new OrderedMapValues(this);
        }
        if (!this.values1.iter.valid) {
            this.values1.iter.reset();
            this.values1.iter.valid = true;
            this.values2.iter.valid = false;
            return this.values1;
        }
        this.values2.iter.reset();
        this.values2.iter.valid = true;
        this.values1.iter.valid = false;
        return this.values2;
    }

    @Override
    public IntObjectMap.Entries<V> entrySet() {
        if (this.entries1 == null || this.entries2 == null) {
            this.entries1 = new OrderedMapEntries(this);
            this.entries2 = new OrderedMapEntries(this);
        }
        if (!this.entries1.iter.valid) {
            this.entries1.iter.reset();
            this.entries1.iter.valid = true;
            this.entries2.iter.valid = false;
            return this.entries1;
        }
        this.entries2.iter.reset();
        this.entries2.iter.valid = true;
        this.entries1.iter.valid = false;
        return this.entries2;
    }

    @Override
    public Iterator<IntObjectMap.Entry<V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    protected String toString(String separator, boolean braces) {
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        IntList keys = this.keys;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            int key = keys.get(i);
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(key);
            buffer.append('=');
            Object value = this.get(key);
            buffer.append((Object)(value == this ? "(this)" : value));
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public static <V> IntObjectOrderedMap<V> with(Number key0, V value0) {
        IntObjectOrderedMap<V> map = new IntObjectOrderedMap<V>(1);
        map.put(key0.intValue(), value0);
        return map;
    }

    public static <V> IntObjectOrderedMap<V> with(Number key0, V value0, Object ... rest) {
        IntObjectOrderedMap<Object> map = new IntObjectOrderedMap<Object>(1 + (rest.length >>> 1));
        map.put(key0.intValue(), value0);
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put(((Number)rest[i - 1]).intValue(), rest[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }

    public static class OrderedMapKeys<V>
    extends IntObjectMap.Keys<V> {
        private final IntList keys;

        public OrderedMapKeys(IntObjectOrderedMap<V> map) {
            super(map);
            this.keys = map.keys;
            this.iter = new IntObjectMap.KeyIterator<V>(map){

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public int nextInt() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    int key = keys.get(this.nextIndex);
                    this.currentIndex = this.nextIndex++;
                    this.hasNext = this.nextIndex < this.map.size;
                    return key;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(keys.get(this.currentIndex));
                    this.nextIndex = this.currentIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return this.iter;
        }
    }

    public static class OrderedMapValues<V>
    extends IntObjectMap.Values<V> {
        private final IntList keys;

        public OrderedMapValues(IntObjectOrderedMap<V> map) {
            super(map);
            this.keys = map.keys;
            this.iter = new IntObjectMap.ValueIterator<V>(map){

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public @Nullable V next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    Object value = this.map.get(keys.get(this.nextIndex));
                    this.currentIndex = this.nextIndex++;
                    this.hasNext = this.nextIndex < this.map.size;
                    return value;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(keys.get(this.currentIndex));
                    this.nextIndex = this.currentIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public Iterator<V> iterator() {
            return this.iter;
        }
    }

    public static class OrderedMapEntries<V>
    extends IntObjectMap.Entries<V> {
        protected IntList keys;

        public OrderedMapEntries(IntObjectOrderedMap<V> map) {
            super(map);
            this.keys = map.keys;
            this.iter = new IntObjectMap.EntryIterator<V>(map){

                @Override
                public Iterator<IntObjectMap.Entry<V>> iterator() {
                    return this;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public IntObjectMap.Entry<V> next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    this.currentIndex = this.nextIndex;
                    this.entry.key = keys.get(this.nextIndex);
                    this.entry.value = this.map.get(this.entry.key);
                    ++this.nextIndex;
                    this.hasNext = this.nextIndex < this.map.size;
                    return this.entry;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(this.entry.key);
                    --this.nextIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            return this.iter;
        }
    }
}

