/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IntSet
implements PrimitiveCollection.OfInt {
    protected int size;
    protected int[] keyTable;
    protected boolean hasZeroValue;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable IntSetIterator iterator1;
    protected transient @Nullable IntSetIterator iterator2;

    public IntSet() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public IntSet(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public IntSet(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[tableSize];
    }

    public IntSet(IntSet set) {
        this((int)((float)set.keyTable.length * set.loadFactor), set.loadFactor);
        System.arraycopy(set.keyTable, 0, this.keyTable, 0, set.keyTable.length);
        this.size = set.size;
        this.hasZeroValue = set.hasZeroValue;
        this.hashMultiplier = set.hashMultiplier;
    }

    public IntSet(PrimitiveCollection.OfInt coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public IntSet(int[] array, int offset, int length) {
        this(length);
        this.addAll(array, offset, length);
    }

    public IntSet(int[] array) {
        this(array, 0, array.length);
    }

    protected int place(int item) {
        return (int)((long)item * this.hashMultiplier >>> this.shift);
    }

    protected int locateKey(int key) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    @Override
    public boolean add(int key) {
        if (key == 0) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            ++this.size;
            return true;
        }
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while (key != (other = keyTable[i])) {
            if (other == 0) {
                keyTable[i] = key;
                if (++this.size >= this.threshold) {
                    this.resize(keyTable.length << 1);
                }
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    public boolean addAll(IntList array) {
        return this.addAll(array.items, 0, array.size);
    }

    public boolean addAll(IntList array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        return this.addAll(array.items, offset, length);
    }

    public boolean addAll(int ... array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(int[] array, int offset, int length) {
        int i;
        this.ensureCapacity(length);
        int oldSize = this.size;
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
        return this.size != oldSize;
    }

    public boolean addAll(IntSet set) {
        this.ensureCapacity(set.size);
        int oldSize = this.size;
        if (set.hasZeroValue) {
            this.add(0);
        }
        for (int key : set.keyTable) {
            if (key == 0) continue;
            this.add(key);
        }
        return this.size != oldSize;
    }

    protected void addResize(int key) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0) {
                keyTable[i] = key;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    public boolean remove(int key) {
        if (key == 0) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            --this.size;
            return true;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return false;
        }
        int[] keyTable = this.keyTable;
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != 0) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0;
        --this.size;
        return true;
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.hasZeroValue = false;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0);
        this.hasZeroValue = false;
    }

    @Override
    public boolean contains(int key) {
        if (key == 0) {
            return this.hasZeroValue;
        }
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while (key != (other = keyTable[i])) {
            if (other == 0) {
                return false;
            }
            i = i + 1 & this.mask;
        }
        return true;
    }

    @Override
    public int first() {
        if (this.hasZeroValue) {
            return 0;
        }
        int[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == 0) continue;
            return keyTable[i];
        }
        throw new IllegalStateException("IntSet is empty.");
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        int[] oldKeyTable = this.keyTable;
        this.keyTable = new int[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                int key = oldKeyTable[i];
                if (key == 0) continue;
                this.addResize(key);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    @Override
    public int hashCode() {
        int h = this.size;
        for (int key : this.keyTable) {
            if (key == 0) continue;
            h += key;
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntSet)) {
            return false;
        }
        IntSet s = (IntSet)o;
        if (s.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(s);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int key;
        if (this.size == 0) {
            return builder.append("[]");
        }
        builder.append('[');
        int[] keyTable = this.keyTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            builder.append('0');
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0) continue;
                builder.append(key);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0) continue;
            builder.append(", ");
            builder.append(key);
        }
        builder.append(']');
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(32)).toString();
    }

    public void truncate(int newSize) {
        int[] keyTable = this.keyTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == 0) continue;
            keyTable[i] = 0;
            --this.size;
        }
        if (this.hasZeroValue && this.size > newSize) {
            this.hasZeroValue = false;
            --this.size;
        }
    }

    @Override
    public IntSetIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new IntSetIterator(this);
            this.iterator2 = new IntSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static IntSet with(int item) {
        IntSet set = new IntSet(1);
        set.add(item);
        return set;
    }

    public static IntSet with(int ... array) {
        return new IntSet(array);
    }

    public static class IntSetIterator
    implements PrimitiveIterator.OfInt {
        private static final int INDEX_ILLEGAL = -2;
        private static final int INDEX_ZERO = -1;
        public boolean hasNext;
        protected int nextIndex;
        protected int currentIndex;
        protected boolean valid = true;
        protected final IntSet set;

        public IntSetIterator(IntSet set) {
            this.set = set;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        protected void findNextIndex() {
            int[] keyTable = this.set.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == 0) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.set.hasZeroValue) {
                this.set.hasZeroValue = false;
            } else {
                int key;
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] keyTable = this.set.keyTable;
                int mask = this.set.mask;
                int next = i + 1 & mask;
                while ((key = keyTable[next]) != 0) {
                    int placement = this.set.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0;
                if (i != this.currentIndex) {
                    --this.nextIndex;
                }
            }
            this.currentIndex = -2;
            --this.set.size;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int key = this.nextIndex == -1 ? 0 : this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public IntList toList() {
            IntList list = new IntList(true, this.set.size);
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                list.add(this.nextInt());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return list;
        }

        public PrimitiveCollection.OfInt appendInto(PrimitiveCollection.OfInt coll) {
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                coll.add(this.nextInt());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return coll;
        }
    }
}

