/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;

public class LongBag
extends LongList {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public LongBag() {
    }

    public LongBag(int capacity) {
        super(capacity);
    }

    public LongBag(LongList list) {
        super(list);
    }

    public LongBag(long[] array) {
        super(array);
    }

    public LongBag(long[] array, int startIndex, int count) {
        super(array, startIndex, count);
    }

    public LongBag(PrimitiveCollection.OfLong coll) {
        super(coll);
    }

    public LongBag(Ordered.OfLong other) {
        super(other);
    }

    public LongBag(Ordered.OfLong other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void insert(int index, long element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        long[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = element;
        ++this.size;
    }

    @Override
    public long removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        long[] items = this.items;
        long value = items[index];
        --this.size;
        items[index] = items[this.size];
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        int lastIndex = n - count;
        int i = Math.max(lastIndex, end);
        System.arraycopy(this.items, i, this.items, start, n - i);
        this.size = n - count;
    }

    @Override
    public int hashCode() {
        long[] items = this.items;
        long h = 1L;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += items[i];
        }
        return (int)(h ^ h >>> 32);
    }

    public static LongBag with(long item) {
        LongBag list = new LongBag(1);
        list.add(item);
        return list;
    }

    public static LongBag with(long ... array) {
        return new LongBag(array);
    }
}

