/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.support.sort.LongComparator;
import com.github.tommyettinger.ds.support.sort.LongComparators;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LongDeque
implements PrimitiveCollection.OfLong,
Arrangeable {
    protected long defaultValue = -1L;
    protected long[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;
    protected transient @Nullable LongDequeIterator iterator1;
    protected transient @Nullable LongDequeIterator iterator2;
    protected transient @Nullable LongDequeIterator descendingIterator1;
    protected transient @Nullable LongDequeIterator descendingIterator2;

    public LongDeque() {
        this(16);
    }

    public LongDeque(int initialSize) {
        this.values = new long[initialSize];
    }

    public LongDeque(PrimitiveCollection.OfLong coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public LongDeque(LongDeque deque) {
        this.values = Arrays.copyOf(deque.values, deque.values.length);
        this.size = deque.size;
        this.head = deque.head;
        this.tail = deque.tail;
        this.defaultValue = deque.defaultValue;
    }

    public LongDeque(long[] a) {
        this.tail = a.length;
        this.values = Arrays.copyOf(a, this.tail);
        this.size = this.tail;
    }

    public LongDeque(long[] a, int offset, int count) {
        this.values = Arrays.copyOfRange(a, offset, offset + count);
        this.tail = count;
        this.size = count;
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void addLast(long item) {
        long[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        if (this.tail == values.length) {
            this.tail = 0;
        }
        values[this.tail++] = item;
        ++this.size;
    }

    public void addFirst(long item) {
        long[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        int head = this.head;
        if (--head == -1) {
            head = values.length - 1;
        }
        values[head] = item;
        this.head = head;
        ++this.size;
    }

    public void ensureCapacity(int additional) {
        int needed = this.size + additional;
        if (this.values.length < needed) {
            this.resize(needed);
        }
    }

    protected void resize(int newSize) {
        long[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        long[] newArray = new long[newSize];
        if (head < tail) {
            System.arraycopy(values, head, newArray, 0, tail - head);
        } else if (this.size > 0) {
            int rest = values.length - head;
            System.arraycopy(values, head, newArray, 0, rest);
            System.arraycopy(values, 0, newArray, rest, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    public long removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("LongDeque is empty.");
        }
        long[] values = this.values;
        long result = values[this.head];
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    public long removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("LongDeque is empty.");
        }
        long[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        long result = values[tail];
        this.tail = tail;
        --this.size;
        return result;
    }

    public boolean offerFirst(long t) {
        int oldSize = this.size;
        this.addFirst(t);
        return oldSize != this.size;
    }

    public boolean offerLast(long t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public long pollFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        long[] values = this.values;
        long result = values[this.head];
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    public long pollLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        long[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        long result = values[tail];
        this.tail = tail;
        --this.size;
        return result;
    }

    public long getFirst() {
        return this.first();
    }

    public long getLast() {
        return this.last();
    }

    public long peekFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        return this.values[this.head];
    }

    public long peekLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        long[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public boolean removeFirstOccurrence(long o) {
        return this.removeValue(o);
    }

    public boolean removeLastOccurrence(long o) {
        return this.removeLastValue(o);
    }

    @Override
    public boolean add(long t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public boolean add(int index, long item) {
        int oldSize = this.size;
        if (index <= 0) {
            this.addFirst(item);
        } else if (index >= oldSize) {
            this.addLast(item);
        } else {
            long[] values = this.values;
            if (this.size == values.length) {
                this.resize(values.length << 1);
                values = this.values;
            }
            if (this.head < this.tail) {
                if ((index += this.head) >= values.length) {
                    index -= values.length;
                }
                System.arraycopy(values, index, values, (index + 1) % values.length, this.tail - index);
                values[index] = item;
                ++this.tail;
                if (this.tail > values.length) {
                    this.tail = 1;
                }
            } else if (this.head + index < values.length) {
                System.arraycopy(values, this.head, values, this.head - 1, index);
                values[this.head - 1 + index] = item;
                --this.head;
            } else {
                System.arraycopy(values, this.head + (index -= values.length - 1), values, this.head + index + 1, this.tail - this.head - index);
                values[this.head + index] = item;
                ++this.tail;
            }
            ++this.size;
        }
        return oldSize != this.size;
    }

    public boolean insert(int index, long element) {
        return this.add(index, element);
    }

    public boolean offer(long t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public long remove() {
        return this.removeFirst();
    }

    public long poll() {
        return this.pollFirst();
    }

    public long element() {
        return this.first();
    }

    public long peek() {
        return this.peekFirst();
    }

    @Override
    public boolean addAll(PrimitiveCollection.OfLong c) {
        int oldSize = this.size;
        PrimitiveIterator.OfLong it = c.iterator();
        while (it.hasNext()) {
            this.addLast(it.nextLong());
        }
        return oldSize != this.size;
    }

    public void push(long t) {
        this.addFirst(t);
    }

    public long pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(long o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean contains(long o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long[] toArray() {
        long[] next = new long[this.size];
        if (this.head < this.tail) {
            System.arraycopy(this.values, this.head, next, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.values, this.head, next, 0, this.size - this.head);
            System.arraycopy(this.values, 0, next, this.size - this.head, this.tail);
        }
        return next;
    }

    public int indexOf(long value) {
        if (this.size == 0) {
            return -1;
        }
        long[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = head; i < tail; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
        } else {
            int i;
            int n = values.length;
            for (i = head; i < n; ++i) {
                if (values[i] != value) continue;
                return i - head;
            }
            for (i = 0; i < tail; ++i) {
                if (values[i] != value) continue;
                return i + values.length - head;
            }
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        if (this.size == 0) {
            return -1;
        }
        long[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = tail - 1; i >= head; --i) {
                if (values[i] != value) continue;
                return i - head;
            }
        } else {
            int i;
            for (i = tail - 1; i >= 0; --i) {
                if (values[i] != value) continue;
                return i + values.length - head;
            }
            for (i = values.length - 1; i >= head; --i) {
                if (values[i] != value) continue;
                return i - head;
            }
        }
        return -1;
    }

    public boolean removeValue(long value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public boolean removeLastValue(long value) {
        int index = this.lastIndexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public long removeAt(int index) {
        long value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        long[] values = this.values;
        int head = this.head++;
        int tail = this.tail--;
        index += head;
        if (head < tail) {
            value = values[index];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
        } else if (index >= values.length) {
            value = values[index -= values.length];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
            --this.tail;
        } else {
            value = values[index];
            System.arraycopy(values, head, values, head + 1, index - head);
            if (this.head == values.length) {
                this.head = 0;
            }
        }
        --this.size;
        return value;
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long first() {
        if (this.size == 0) {
            throw new NoSuchElementException("LongDeque is empty.");
        }
        return this.values[this.head];
    }

    public long last() {
        if (this.size == 0) {
            throw new NoSuchElementException("LongDeque is empty.");
        }
        long[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public long get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        long[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        return values[i];
    }

    public long set(int index, long item) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        long[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        long old = values[i];
        values[i] = item;
        return old;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    @Override
    public LongDequeIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new LongDequeIterator(this);
            this.iterator2 = new LongDequeIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public LongDequeIterator descendingIterator() {
        if (this.descendingIterator1 == null || this.descendingIterator2 == null) {
            this.descendingIterator1 = new LongDequeIterator(this, true);
            this.descendingIterator2 = new LongDequeIterator(this, true);
        }
        if (!this.descendingIterator1.valid) {
            this.descendingIterator1.reset();
            this.descendingIterator1.valid = true;
            this.descendingIterator2.valid = false;
            return this.descendingIterator1;
        }
        this.descendingIterator2.reset();
        this.descendingIterator2.valid = true;
        this.descendingIterator1.valid = false;
        return this.descendingIterator2;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        long[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(", ").append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        long[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(separator).append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int size = this.size;
        long[] values = this.values;
        int backingLength = values.length;
        int index = this.head;
        int hash = size + 1;
        for (int s = 0; s < size; ++s) {
            long value = values[index];
            hash *= 421;
            hash = (int)((long)hash + (value ^ value >>> 32));
            if (++index != backingLength) continue;
            index = 0;
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongDeque)) {
            return false;
        }
        LongDeque q = (LongDeque)o;
        int size = this.size;
        if (q.size != size) {
            return false;
        }
        long[] myValues = this.values;
        int myBackingLength = myValues.length;
        long[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size; ++s) {
            long myValue = myValues[myIndex];
            long itsValue = itsValues[itsIndex];
            if (myValue != itsValue) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    @Override
    public void swap(int first, int second) {
        int s;
        if (first < 0) {
            throw new IndexOutOfBoundsException("first index can't be < 0: " + first);
        }
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first index can't be >= size: " + first + " >= " + this.size);
        }
        if (second < 0) {
            throw new IndexOutOfBoundsException("second index can't be < 0: " + second);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second index can't be >= size: " + second + " >= " + this.size);
        }
        int f = this.head + first;
        long[] values = this.values;
        if (f >= values.length) {
            f -= values.length;
        }
        if ((s = this.head + second) >= values.length) {
            s -= values.length;
        }
        long fv = values[f];
        values[f] = values[s];
        values[s] = fv;
    }

    @Override
    public void reverse() {
        long[] values = this.values;
        int len = values.length;
        int n = this.size >> 1;
        int b = 0;
        for (int t = this.size - 1; b <= n && b != t; ++b, --t) {
            int s;
            int f = this.head + b;
            if (f >= len) {
                f -= len;
            }
            if ((s = this.head + t) >= len) {
                s -= len;
            }
            long fv = values[f];
            values[f] = values[s];
            values[s] = fv;
        }
    }

    public void sort() {
        if (this.head <= this.tail) {
            Arrays.sort(this.values, this.head, this.tail);
        } else {
            System.arraycopy(this.values, this.head, this.values, this.tail, this.values.length - this.head);
            Arrays.sort(this.values, 0, this.size);
            this.tail = this.size;
            this.head = 0;
        }
    }

    public void sort(@Nullable LongComparator c) {
        if (this.head <= this.tail) {
            LongComparators.sort(this.values, this.head, this.tail, c);
        } else {
            System.arraycopy(this.values, this.head, this.values, this.tail, this.values.length - this.head);
            LongComparators.sort(this.values, 0, this.size, c);
            this.tail = this.size;
            this.head = 0;
        }
    }

    public long random(Random random) {
        if (this.size <= 0) {
            throw new NoSuchElementException("LongDeque is empty.");
        }
        return this.get(random.nextInt(this.size));
    }

    public static LongDeque with(long item) {
        LongDeque deque = new LongDeque();
        deque.add(item);
        return deque;
    }

    public static LongDeque with(long ... items) {
        return new LongDeque(items);
    }

    public static class LongDequeIterator
    implements PrimitiveIterator.OfLong {
        protected int index;
        protected int latest = -1;
        protected LongDeque deque;
        protected boolean valid = true;
        private final int direction;

        public LongDequeIterator(LongDeque deque) {
            this(deque, false);
        }

        public LongDequeIterator(LongDeque deque, boolean descendingOrder) {
            this.deque = deque;
            this.direction = descendingOrder ? -1 : 1;
        }

        public LongDequeIterator(LongDeque deque, int index, boolean descendingOrder) {
            if (index < 0 || index >= deque.size()) {
                throw new IndexOutOfBoundsException("LongDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.deque = deque;
            this.index = index;
            this.direction = descendingOrder ? -1 : 1;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index;
            this.index += this.direction;
            return this.deque.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == 1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == -1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index -= this.direction;
            return this.deque.get(this.index);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        public void set(long t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.set(this.latest, t);
        }

        public void add(long t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.insert(this.index, t);
            this.index += this.direction;
            this.latest = -1;
        }

        public void reset() {
            this.index = this.deque.size - 1 & this.direction >> 31;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.deque.size()) {
                throw new IndexOutOfBoundsException("LongDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        public LongDequeIterator iterator() {
            return this;
        }
    }
}

