/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import com.github.tommyettinger.function.LongObjBiConsumer;
import com.github.tommyettinger.function.LongObjToObjBiFunction;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.BiFunction;
import java.util.function.LongFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LongObjectMap<V>
implements Iterable<Entry<V>> {
    protected int size;
    protected long[] keyTable;
    protected V[] valueTable;
    protected boolean hasZeroValue;
    protected @Nullable V zeroValue;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable Entries<V> entries1;
    protected transient @Nullable Entries<V> entries2;
    protected transient @Nullable Values<V> values1;
    protected transient @Nullable Values<V> values2;
    protected transient @Nullable Keys<V> keys1;
    protected transient @Nullable Keys<V> keys2;
    public @Nullable V defaultValue = null;

    public LongObjectMap() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public LongObjectMap(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public LongObjectMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[tableSize];
        this.valueTable = new Object[tableSize];
    }

    public LongObjectMap(LongObjectMap<? extends V> map) {
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size = map.size;
        this.defaultValue = map.defaultValue;
        this.zeroValue = map.zeroValue;
        this.hasZeroValue = map.hasZeroValue;
        this.hashMultiplier = map.hashMultiplier;
    }

    public LongObjectMap(long[] keys, V[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    protected int place(long item) {
        return (int)((item ^ item >>> 32) * this.hashMultiplier >>> this.shift);
    }

    protected int locateKey(long key) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    public @Nullable V put(long key, @Nullable V value) {
        if (key == 0L) {
            V oldValue = this.defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return this.defaultValue;
    }

    public @Nullable V putOrDefault(long key, @Nullable V value, @Nullable V defaultValue) {
        if (key == 0L) {
            V oldValue = defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(LongObjectMap<? extends V> map) {
        this.ensureCapacity(map.size);
        if (map.hasZeroValue) {
            if (!this.hasZeroValue) {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = map.zeroValue;
        }
        long[] keyTable = map.keyTable;
        V[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            long key = keyTable[i];
            if (key == 0L) continue;
            this.put(key, valueTable[i]);
        }
    }

    public void putAll(long[] keys, V[] values) {
        this.putAll(keys, 0, values, 0, Math.min(keys.length, values.length));
    }

    public void putAll(long[] keys, V[] values, int length) {
        this.putAll(keys, 0, values, 0, length);
    }

    public void putAll(long[] keys, int keyOffset, V[] values, int valueOffset, int length) {
        length = Math.min(length, Math.min(keys.length - keyOffset, values.length - valueOffset));
        this.ensureCapacity(length);
        int k = keyOffset;
        int v = valueOffset;
        int i = 0;
        int n = length;
        while (i < n) {
            this.put(keys[k], values[v]);
            ++i;
            ++k;
            ++v;
        }
    }

    public LongObjectMap(PrimitiveCollection.OfLong keys, Collection<? extends V> values) {
        this(Math.min(keys.size(), values.size()));
        this.putAll(keys, values);
    }

    public void putAll(PrimitiveCollection.OfLong keys, Collection<? extends V> values) {
        int length = Math.min(keys.size(), values.size());
        this.ensureCapacity(length);
        PrimitiveIterator.OfLong ki = keys.iterator();
        Iterator<V> vi = values.iterator();
        while (ki.hasNext() && vi.hasNext()) {
            this.put(ki.next(), vi.next());
        }
    }

    protected void putResize(long key, @Nullable V value) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0L) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public @Nullable V get(long key) {
        if (key == 0L) {
            return this.hasZeroValue ? this.zeroValue : this.defaultValue;
        }
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & this.mask;
        }
        return this.defaultValue;
    }

    public @Nullable V getOrDefault(long key, @Nullable V defaultValue) {
        if (key == 0L) {
            return this.hasZeroValue ? this.zeroValue : defaultValue;
        }
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & this.mask;
        }
        return defaultValue;
    }

    public @Nullable V remove(long key) {
        long rem;
        if (key == 0L) {
            if (this.hasZeroValue) {
                this.hasZeroValue = false;
                --this.size;
                return this.zeroValue;
            }
            return this.defaultValue;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return this.defaultValue;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((rem = keyTable[next]) != 0L) {
            int placement = this.place(rem);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = rem;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0L;
        valueTable[i] = null;
        --this.size;
        return oldValue;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public @Nullable V getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(Math.max(maximumCapacity, this.size), this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0L);
    }

    public boolean containsValue(@Nullable Object value) {
        if (this.hasZeroValue) {
            return Objects.equals(this.zeroValue, value);
        }
        V[] valueTable = this.valueTable;
        long[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == 0L || !Objects.equals(valueTable[i], value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long key) {
        if (key == 0L) {
            return this.hasZeroValue;
        }
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    public long findKey(@Nullable V value, long defaultKey) {
        if (this.hasZeroValue && Objects.equals(this.zeroValue, value)) {
            return 0L;
        }
        V[] valueTable = this.valueTable;
        long[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == 0L || !Objects.equals(valueTable[i], value)) continue;
            return keyTable[i];
        }
        return defaultKey;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        long[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new long[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                long key = oldKeyTable[i];
                if (key == 0L) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    public int hashCode() {
        long h = this.hasZeroValue && this.zeroValue != null ? (long)this.zeroValue.hashCode() * -7046029254386353131L + (long)this.size : (long)this.size;
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            long key = keyTable[i];
            if (key == 0L) continue;
            h += key ^ key >>> 32;
            V v = valueTable[i];
            if (v == null) continue;
            h += (long)v.hashCode() * -7046029254386353131L;
        }
        return (int)(h ^ h >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongObjectMap)) {
            return false;
        }
        LongObjectMap other = (LongObjectMap)obj;
        if (other.size != this.size) {
            return false;
        }
        if (other.hasZeroValue != this.hasZeroValue || !Objects.equals(other.zeroValue, this.zeroValue)) {
            return false;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            V value;
            long key = keyTable[i];
            if (key == 0L || !((value = valueTable[i]) == null ? other.getOrDefault(key, Utilities.neverIdentical) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String separator, boolean braces) {
        V value;
        long key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        if (this.hasZeroValue) {
            buffer.append("0=").append(this.zeroValue);
            if (this.size > 1) {
                buffer.append(separator);
            }
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0L) continue;
            buffer.append(key);
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0L) continue;
            buffer.append(separator);
            buffer.append(key);
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    @Override
    public void forEach(LongObjBiConsumer<? super V> action) {
        for (Entry<V> entry : this.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public void replaceAll(LongObjToObjBiFunction<? super V, ? extends V> function) {
        for (Entry<Object> entry : this.entrySet()) {
            entry.setValue(function.apply(entry.getKey(), entry.getValue()));
        }
    }

    public void truncate(int newSize) {
        long[] keyTable = this.keyTable;
        V[] valTable = this.valueTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == 0L) continue;
            keyTable[i] = 0L;
            valTable[i] = null;
            --this.size;
        }
        if (this.hasZeroValue && this.size > newSize) {
            this.hasZeroValue = false;
            this.zeroValue = null;
            --this.size;
        }
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entrySet().iterator();
    }

    public Keys<V> keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    public Values<V> values() {
        if (this.values1 == null || this.values2 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.iter.valid) {
            this.values1.iter.reset();
            this.values1.iter.valid = true;
            this.values2.iter.valid = false;
            return this.values1;
        }
        this.values2.iter.reset();
        this.values2.iter.valid = true;
        this.values1.iter.valid = false;
        return this.values2;
    }

    public Entries<V> entrySet() {
        if (this.entries1 == null || this.entries2 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.iter.valid) {
            this.entries1.iter.reset();
            this.entries1.iter.valid = true;
            this.entries2.iter.valid = false;
            return this.entries1;
        }
        this.entries2.iter.reset();
        this.entries2.iter.valid = true;
        this.entries1.iter.valid = false;
        return this.entries2;
    }

    public @Nullable V putIfAbsent(long key, V value) {
        if (key == 0L) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return this.put(key, value);
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            return this.valueTable[i];
        }
        return this.put(key, value);
    }

    public boolean replace(long key, V oldValue, V newValue) {
        V curValue = this.get(key);
        if (!Objects.equals(curValue, oldValue) || !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    public @Nullable V replace(long key, V value) {
        if (key == 0L) {
            if (this.hasZeroValue) {
                V oldValue = this.zeroValue;
                this.zeroValue = value;
                return oldValue;
            }
            return this.defaultValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        return this.defaultValue;
    }

    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        int i = this.locateKey(key);
        if (i < 0) {
            V newValue = mappingFunction.apply(key);
            this.put(key, newValue);
            return newValue;
        }
        return this.valueTable[i];
    }

    public boolean remove(long key, Object value) {
        int i = this.locateKey(key);
        if (i >= 0 && Objects.equals(this.valueTable[i], value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public @Nullable V merge(long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V next;
        int i = this.locateKey(key);
        V v = next = i < 0 ? value : remappingFunction.apply(this.valueTable[i], value);
        if (next == null) {
            this.remove(key);
        } else {
            this.put(key, next);
        }
        return next;
    }

    public static <V> LongObjectMap<V> with(Number key0, V value0) {
        LongObjectMap<V> map = new LongObjectMap<V>(1);
        map.put(key0.longValue(), value0);
        return map;
    }

    public static <V> LongObjectMap<V> with(Number key0, V value0, Object ... rest) {
        LongObjectMap<Object> map = new LongObjectMap<Object>(1 + (rest.length >>> 1));
        map.put(key0.longValue(), value0);
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put(((Number)rest[i - 1]).longValue(), rest[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }

    public static class Entries<V>
    extends AbstractSet<Entry<V>> {
        protected EntryIterator<V> iter;

        public Entries(LongObjectMap<V> map) {
            this.iter = new EntryIterator<V>(map);
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public ObjectList<Entry<V>> toList() {
            ObjectList<Entry<V>> list = new ObjectList<Entry<V>>(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(new Entry(this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<Entry<V>> appendInto(Collection<Entry<V>> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(new Entry(this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        public LongObjectMap<V> appendInto(LongObjectMap<V> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                this.iter.next();
                coll.put(this.iter.entry.key, this.iter.entry.value);
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    public static class Entry<V> {
        public long key;
        public @Nullable V value;

        public Entry() {
        }

        public Entry(long key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }

        public Entry(Entry<V> entry) {
            this.key = entry.key;
            this.value = entry.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public long getKey() {
            return this.key;
        }

        public @Nullable V getValue() {
            return this.value;
        }

        public @Nullable V setValue(@Nullable V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.key != entry.key) {
                return false;
            }
            return Objects.equals(this.value, entry.value);
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    public static class Keys<V>
    implements PrimitiveCollection.OfLong {
        protected KeyIterator<V> iter;

        public Keys(LongObjectMap<V> map) {
            this.iter = new KeyIterator<V>(map);
        }

        @Override
        public boolean add(long item) {
            throw new UnsupportedOperationException("LongObjectMap.Keys is read-only");
        }

        @Override
        public boolean remove(long item) {
            throw new UnsupportedOperationException("LongObjectMap.Keys is read-only");
        }

        @Override
        public boolean contains(long item) {
            return this.iter.map.containsKey(item);
        }

        @Override
        public PrimitiveIterator.OfLong iterator() {
            return this.iter;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("LongObjectMap.Keys is read-only");
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public LongList toList() {
            LongList list = new LongList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.nextLong());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public PrimitiveCollection.OfLong appendInto(PrimitiveCollection.OfLong coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.nextLong());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        @Override
        public boolean equals(Object other) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            boolean eq = PrimitiveCollection.OfLong.super.areEqual(other);
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return eq;
        }
    }

    public static class KeyIterator<V>
    extends MapIterator<V>
    implements PrimitiveIterator.OfLong {
        public KeyIterator(LongObjectMap<V> map) {
            super(map);
        }

        @Override
        public long nextLong() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long key = this.nextIndex == -1 ? 0L : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public LongList toList() {
            LongList list = new LongList(true, this.map.size);
            while (this.hasNext) {
                list.add(this.nextLong());
            }
            return list;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    public static class Values<V>
    extends AbstractCollection<V> {
        protected ValueIterator<V> iter;

        @Override
        public boolean add(@Nullable V item) {
            throw new UnsupportedOperationException("LongObjectMap.Values is read-only");
        }

        @Override
        public boolean remove(@Nullable Object item) {
            throw new UnsupportedOperationException("LongObjectMap.Values is read-only");
        }

        @Override
        public boolean contains(@Nullable Object item) {
            return this.iter.map.containsValue(item);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("LongObjectMap.Values is read-only");
        }

        @Override
        public Iterator<V> iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        public Values(LongObjectMap<V> map) {
            this.iter = new ValueIterator<V>(map);
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public ObjectList<V> toList() {
            ObjectList list = new ObjectList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<V> appendInto(Collection<V> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    public static class ValueIterator<V>
    extends MapIterator<V>
    implements Iterator<V> {
        public ValueIterator(LongObjectMap<V> map) {
            super(map);
        }

        @Override
        public @Nullable V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object value = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return value;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    public static class EntryIterator<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        protected Entry<V> entry = new Entry();

        public EntryIterator(LongObjectMap<V> map) {
            super(map);
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long[] keyTable = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0L;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = keyTable[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    protected static abstract class MapIterator<V> {
        protected static final int INDEX_ILLEGAL = -2;
        protected static final int INDEX_ZERO = -1;
        public boolean hasNext;
        protected final LongObjectMap<V> map;
        protected int nextIndex;
        protected int currentIndex;
        protected boolean valid = true;

        public MapIterator(LongObjectMap<V> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            long[] keyTable = this.map.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == 0L) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
                this.map.zeroValue = null;
            } else {
                long key;
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                long[] keyTable = this.map.keyTable;
                V[] valueTable = this.map.valueTable;
                int mask = this.map.mask;
                int next = i + 1 & mask;
                while ((key = keyTable[next]) != 0L) {
                    int placement = this.map.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        valueTable[i] = valueTable[next];
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0L;
                valueTable[i] = null;
                if (i != this.currentIndex) {
                    --this.nextIndex;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }
}

