/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.LongSet;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import java.util.NoSuchElementException;

public class LongOrderedSet
extends LongSet
implements Ordered.OfLong {
    protected final LongList items;

    public LongOrderedSet() {
        this.items = new LongList();
    }

    public LongOrderedSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.items = new LongList(initialCapacity);
    }

    public LongOrderedSet(int initialCapacity) {
        super(initialCapacity);
        this.items = new LongList(initialCapacity);
    }

    public LongOrderedSet(LongOrderedSet set) {
        super(set);
        this.items = new LongList(set.items);
    }

    public LongOrderedSet(PrimitiveCollection.OfLong coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public LongOrderedSet(long[] array, int offset, int length) {
        this(length);
        this.addAll(array, offset, length);
    }

    public LongOrderedSet(long[] items) {
        this(items.length);
        this.addAll(items);
    }

    public LongOrderedSet(Ordered.OfLong other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    public boolean add(long key) {
        return super.add(key) && this.items.add(key);
    }

    public boolean add(int index, long key) {
        if (!super.add(key)) {
            int oldIndex = this.items.indexOf(key);
            if (oldIndex != index) {
                this.items.insert(index, this.items.removeAt(oldIndex));
            }
            return false;
        }
        this.items.insert(index, key);
        return true;
    }

    public boolean addAll(Ordered.OfLong other, int offset, int count) {
        return this.addAll(this.size, other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered.OfLong other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.add(insertionIndex++, other.order().get(i));
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean remove(long key) {
        return super.remove(key) && this.items.remove(key);
    }

    public long removeAt(int index) {
        long key = this.items.removeAt(index);
        super.remove(key);
        return key;
    }

    @Override
    public void removeRange(int start, int end) {
        start = Math.max(0, start);
        end = Math.min(this.items.size(), end);
        for (int i = start; i < end; ++i) {
            super.remove(this.items.get(i));
        }
        this.items.removeRange(start, end);
    }

    @Override
    public long first() {
        if (this.size == 0) {
            throw new IllegalStateException("Cannot get the first() item of an empty LongOrderedSet.");
        }
        return this.items.items[0];
    }

    @Override
    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
        this.items.ensureCapacity(additionalCapacity);
    }

    public boolean alter(long before, long after) {
        if (this.contains(after)) {
            return false;
        }
        if (!super.remove(before)) {
            return false;
        }
        super.add(after);
        this.items.set(this.items.indexOf(before), after);
        return true;
    }

    public boolean alterAt(int index, long after) {
        if (index < 0 || index >= this.size || this.contains(after)) {
            return false;
        }
        super.remove(this.items.get(index));
        super.add(after);
        this.items.set(index, after);
        return true;
    }

    public long getAt(int index) {
        return this.items.get(index);
    }

    @Override
    public void clear(int maximumCapacity) {
        this.items.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    @Override
    public LongList order() {
        return this.items;
    }

    public void sort() {
        this.items.sort();
    }

    @Override
    public LongSet.LongSetIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new LongOrderedSetIterator(this);
            this.iterator2 = new LongOrderedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "{}";
        }
        LongList items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        buffer.append(items.get(0));
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items.get(i));
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.removeRange(newSize, this.size);
        }
    }

    public static LongOrderedSet with(long item) {
        LongOrderedSet set = new LongOrderedSet(1);
        set.add(item);
        return set;
    }

    public static LongOrderedSet with(long ... array) {
        return new LongOrderedSet(array);
    }

    public static class LongOrderedSetIterator
    extends LongSet.LongSetIterator {
        private final LongList items;

        public LongOrderedSetIterator(LongOrderedSet set) {
            super(set);
            this.items = set.items;
        }

        @Override
        public void reset() {
            this.nextIndex = 0;
            this.hasNext = this.set.size > 0;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long key = this.items.get(this.nextIndex);
            ++this.nextIndex;
            this.hasNext = this.nextIndex < this.set.size;
            return key;
        }

        @Override
        public void remove() {
            if (this.nextIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            --this.nextIndex;
            this.set.remove(this.items.get(this.nextIndex));
        }
    }
}

