/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LongSet
implements PrimitiveCollection.OfLong {
    protected int size;
    protected long[] keyTable;
    protected boolean hasZeroValue;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable LongSetIterator iterator1;
    protected transient @Nullable LongSetIterator iterator2;

    public LongSet() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public LongSet(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public LongSet(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[tableSize];
    }

    public LongSet(LongSet set) {
        this((int)((float)set.keyTable.length * set.loadFactor), set.loadFactor);
        System.arraycopy(set.keyTable, 0, this.keyTable, 0, set.keyTable.length);
        this.size = set.size;
        this.hasZeroValue = set.hasZeroValue;
        this.hashMultiplier = set.hashMultiplier;
    }

    public LongSet(PrimitiveCollection.OfLong coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public LongSet(long[] array, int offset, int length) {
        this(length);
        this.addAll(array, offset, length);
    }

    public LongSet(long[] array) {
        this(array, 0, array.length);
    }

    protected int place(long item) {
        return (int)((item ^ item >>> 32) * this.hashMultiplier >>> this.shift);
    }

    protected int locateKey(long key) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    @Override
    public boolean add(long key) {
        if (key == 0L) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            ++this.size;
            return true;
        }
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while (key != (other = keyTable[i])) {
            if (other == 0L) {
                keyTable[i] = key;
                if (++this.size >= this.threshold) {
                    this.resize(keyTable.length << 1);
                }
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    public boolean addAll(LongList array) {
        return this.addAll(array.items, 0, array.size);
    }

    public boolean addAll(LongList array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        return this.addAll(array.items, offset, length);
    }

    public boolean addAll(long ... array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(long[] array, int offset, int length) {
        int i;
        this.ensureCapacity(length);
        int oldSize = this.size;
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
        return this.size != oldSize;
    }

    public boolean addAll(LongSet set) {
        this.ensureCapacity(set.size);
        int oldSize = this.size;
        if (set.hasZeroValue) {
            this.add(0L);
        }
        for (long key : set.keyTable) {
            if (key == 0L) continue;
            this.add(key);
        }
        return this.size != oldSize;
    }

    protected void addResize(long key) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0L) {
                keyTable[i] = key;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    public boolean remove(long key) {
        if (key == 0L) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            --this.size;
            return true;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return false;
        }
        long[] keyTable = this.keyTable;
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != 0L) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0L;
        --this.size;
        return true;
    }

    @Override
    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(Math.max(maximumCapacity, this.size), this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.hasZeroValue = false;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0L);
        this.hasZeroValue = false;
    }

    @Override
    public boolean contains(long key) {
        if (key == 0L) {
            return this.hasZeroValue;
        }
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while (key != (other = keyTable[i])) {
            if (other == 0L) {
                return false;
            }
            i = i + 1 & this.mask;
        }
        return true;
    }

    @Override
    public long first() {
        if (this.hasZeroValue) {
            return 0L;
        }
        long[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == 0L) continue;
            return keyTable[i];
        }
        throw new IllegalStateException("IntSet is empty.");
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        long[] oldKeyTable = this.keyTable;
        this.keyTable = new long[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                long key = oldKeyTable[i];
                if (key == 0L) continue;
                this.addResize(key);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    @Override
    public int hashCode() {
        long h = this.size;
        for (long key : this.keyTable) {
            if (key == 0L) continue;
            h += key;
        }
        return (int)(h ^ h >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongSet)) {
            return false;
        }
        LongSet s = (LongSet)o;
        if (s.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(s);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    public StringBuilder appendTo(StringBuilder builder) {
        long key;
        if (this.size == 0) {
            return builder.append("[]");
        }
        builder.append('[');
        long[] keyTable = this.keyTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            builder.append('0');
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0L) continue;
                builder.append(key);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0L) continue;
            builder.append(", ");
            builder.append(key);
        }
        builder.append(']');
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(32)).toString();
    }

    public void truncate(int newSize) {
        long[] keyTable = this.keyTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == 0L) continue;
            keyTable[i] = 0L;
            --this.size;
        }
        if (this.hasZeroValue && this.size > newSize) {
            this.hasZeroValue = false;
            --this.size;
        }
    }

    @Override
    public LongSetIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new LongSetIterator(this);
            this.iterator2 = new LongSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static LongSet with(long item) {
        LongSet set = new LongSet(1);
        set.add(item);
        return set;
    }

    public static LongSet with(long ... array) {
        return new LongSet(array);
    }

    public static class LongSetIterator
    implements PrimitiveIterator.OfLong {
        private static final int INDEX_ILLEGAL = -2;
        private static final int INDEX_ZERO = -1;
        public boolean hasNext;
        protected int nextIndex;
        protected int currentIndex;
        protected boolean valid = true;
        protected final LongSet set;

        public LongSetIterator(LongSet set) {
            this.set = set;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        protected void findNextIndex() {
            long[] keyTable = this.set.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == 0L) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.set.hasZeroValue) {
                this.set.hasZeroValue = false;
            } else {
                long key;
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                long[] keyTable = this.set.keyTable;
                int mask = this.set.mask;
                int next = i + 1 & mask;
                while ((key = keyTable[next]) != 0L) {
                    int placement = this.set.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0L;
                if (i != this.currentIndex) {
                    --this.nextIndex;
                }
            }
            this.currentIndex = -2;
            --this.set.size;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long key = this.nextIndex == -1 ? 0L : this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public LongList toList() {
            LongList list = new LongList(true, this.set.size);
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                list.add(this.nextLong());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return list;
        }

        public PrimitiveCollection.OfLong appendInto(PrimitiveCollection.OfLong coll) {
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                coll.add(this.nextLong());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return coll;
        }
    }
}

