/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectIntMap;
import com.github.tommyettinger.ds.ObjectIntOrderedMap;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NumberedSet<T>
implements Set<T>,
Ordered<T> {
    protected transient InternalMap map;
    protected transient @Nullable NumberedSetIterator<T> iterator1;
    protected transient @Nullable NumberedSetIterator<T> iterator2;

    public NumberedSet() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public NumberedSet(int initialCapacity, float loadFactor) {
        this.map = new InternalMap(initialCapacity, loadFactor);
        this.map.setDefaultValue(-1);
    }

    public NumberedSet(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public NumberedSet(NumberedSet<? extends T> other) {
        this.map = new InternalMap(other.map);
    }

    public NumberedSet(Ordered<? extends T> ordered) {
        this(ordered.size());
        this.addAll((Collection<? extends T>)ordered.order());
    }

    public NumberedSet(Collection<? extends T> coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public NumberedSet(T[] items) {
        this(items.length);
        this.addAll(items);
    }

    public NumberedSet(Ordered<T> other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    protected int place(Object item) {
        return (int)((long)item.hashCode() * this.map.hashMultiplier >>> this.map.shift);
    }

    protected boolean equate(Object left, @Nullable Object right) {
        return left.equals(right);
    }

    @Override
    public ObjectList<T> order() {
        return this.map.keys;
    }

    public void renumber() {
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            this.map.valueTable[this.map.locateKey(this.map.keys.get((int)i))] = i;
        }
    }

    public void renumber(int start) {
        int s = this.size();
        for (int i = start; i < s; ++i) {
            this.map.valueTable[this.map.locateKey(this.map.keys.get((int)i))] = i;
        }
    }

    @Override
    public boolean remove(Object item) {
        int prev = this.size();
        int oldIndex = this.map.remove(item);
        if (this.size() != prev) {
            this.renumber(oldIndex);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.map.containsKey(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T t : c) {
            modified |= this.add(t);
        }
        return modified;
    }

    public boolean addAll(Ordered<T> other, int offset, int count) {
        return this.addAll(this.map.size, other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered<T> other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.add(insertionIndex++, other.order().get(i));
            changed = true;
        }
        return changed;
    }

    public boolean addAll(T[] array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(T[] array, int offset, int length) {
        int i;
        this.ensureCapacity(length);
        int oldSize = this.size();
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
        return oldSize != this.size();
    }

    public boolean addAll(int insertionIndex, T[] array, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, array.length);
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.add(insertionIndex++, array[i]);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        if (modified) {
            this.renumber();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        if (modified) {
            this.renumber();
            return true;
        }
        return false;
    }

    public boolean removeAll(T[] arr) {
        int prevSize = this.size();
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            this.map.remove(arr[i]);
        }
        if (prevSize != this.size()) {
            this.renumber();
            return true;
        }
        return false;
    }

    public T removeAt(int index) {
        Object old = this.map.keyAt(index);
        this.map.removeAt(index);
        this.renumber(index);
        return (T)old;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.map.ensureCapacity(additionalCapacity);
    }

    public long getHashMultiplier() {
        return this.map.getHashMultiplier();
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.map.setHashMultiplier(hashMultiplier);
    }

    public boolean alter(T before, T after) {
        return this.map.alter(before, after);
    }

    public boolean alterAt(int index, T after) {
        return this.map.alterAt(index, after);
    }

    public T getAt(int index) {
        return (T)this.map.keyAt(index);
    }

    public void clear(int maximumCapacity) {
        this.map.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString(String separator, boolean braces) {
        return this.map.toString(separator, braces);
    }

    public int indexOf(Object item) {
        return this.map.get(item);
    }

    public int indexOfOrDefault(Object item, int defaultValue) {
        return this.map.getOrDefault(item, defaultValue);
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getDefaultValue() {
        return this.map.getDefaultValue();
    }

    public void setDefaultValue(int defaultValue) {
        this.map.setDefaultValue(defaultValue);
    }

    public void shrink(int maximumCapacity) {
        this.map.shrink(maximumCapacity);
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    public void truncate(int newSize) {
        if (this.size() > newSize) {
            this.removeRange(newSize, this.size());
        }
    }

    @Override
    public NumberedSetIterator<T> iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new NumberedSetIterator(this);
            this.iterator2 = new NumberedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public NumberedSetIterator<T> listIterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new NumberedSetIterator(this);
            this.iterator2 = new NumberedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public NumberedSetIterator<T> listIterator(int index) {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new NumberedSetIterator(this, index);
            this.iterator2 = new NumberedSetIterator(this, index);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset(index);
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset(index);
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public void removeRange(int start, int end) {
        this.map.removeRange(start, end);
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(T t) {
        int s = this.size();
        this.map.putIfAbsent(t, s);
        return s != this.size();
    }

    public int addOrIndex(T t) {
        return this.map.putIfAbsent(t, this.size());
    }

    public boolean add(int index, T key) {
        int old = this.map.get(key);
        if (old != -1) {
            if (old != index) {
                this.map.remove(key);
                this.map.put(key, index, index);
                this.renumber(index);
            }
            return false;
        }
        this.map.put(key, index, index);
        this.renumber(index);
        return true;
    }

    public void resize(int newSize) {
        this.map.resize(newSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberedSet that = (NumberedSet)o;
        return this.map.equals(that.map);
    }

    public float getLoadFactor() {
        return this.map.getLoadFactor();
    }

    public void setLoadFactor(float loadFactor) {
        this.map.setLoadFactor(loadFactor);
    }

    public T first() {
        if (this.size() == 0) {
            throw new IllegalStateException("Cannot get the first() item of an empty NumberedSet.");
        }
        return (T)this.map.keyAt(0);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString(String separator) {
        return this.map.toString(separator);
    }

    public String toString() {
        return this.map.toString();
    }

    public static <T> NumberedSet<T> with(T item) {
        NumberedSet<T> set = new NumberedSet<T>(1);
        set.add(item);
        return set;
    }

    @SafeVarargs
    public static <T> NumberedSet<T> with(T ... array) {
        return new NumberedSet<T>(array);
    }

    protected class InternalMap
    extends ObjectIntOrderedMap<T> {
        public InternalMap() {
        }

        public InternalMap(int initialCapacity) {
            super(initialCapacity);
        }

        public InternalMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public InternalMap(ObjectIntOrderedMap<? extends T> map) {
            super(map);
        }

        public InternalMap(ObjectIntMap<? extends T> map) {
            super(map);
        }

        public InternalMap(T[] keys, int[] values) {
            super(keys, values);
        }

        public InternalMap(Collection<? extends T> keys, PrimitiveCollection.OfInt values) {
            super(keys, values);
        }

        @Override
        protected int place(Object item) {
            return NumberedSet.this.place(item);
        }

        @Override
        protected boolean equate(Object left, @Nullable Object right) {
            return NumberedSet.this.equate(left, right);
        }
    }

    public static class NumberedSetIterator<T>
    implements Iterable<T>,
    ListIterator<T> {
        protected int index;
        protected int latest = -1;
        protected NumberedSet<T> ns;
        protected boolean valid = true;

        public NumberedSetIterator(NumberedSet<T> ns) {
            this.ns = ns;
        }

        public NumberedSetIterator(NumberedSet<T> ns, int index) {
            if (index < 0 || index >= ns.size()) {
                throw new IndexOutOfBoundsException("NumberedSetIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.ns = ns;
            this.index = index;
        }

        @Override
        public @Nullable T next() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index >= this.ns.size()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index++;
            return this.ns.getAt(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.ns.size();
        }

        @Override
        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index > 0 && this.ns.notEmpty();
        }

        @Override
        public @Nullable T previous() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index <= 0 || this.ns.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.latest = --this.index;
            return this.ns.getAt(this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.ns.size()) {
                throw new NoSuchElementException();
            }
            this.ns.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        @Override
        public void set(T t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.ns.size()) {
                throw new NoSuchElementException();
            }
            this.ns.alterAt(this.latest, t);
        }

        @Override
        public void add(@Nullable T t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.ns.size()) {
                throw new NoSuchElementException();
            }
            this.ns.add(this.index++, t);
            this.latest = -1;
        }

        public void reset() {
            this.index = 0;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.ns.size()) {
                throw new IndexOutOfBoundsException("NumberedSetIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        @Override
        public NumberedSetIterator<T> iterator() {
            return this;
        }
    }
}

