/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.Ordered;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectBag<T>
extends ObjectList<T> {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public ObjectBag(int initialCapacity) {
        super(initialCapacity);
    }

    public ObjectBag() {
    }

    public ObjectBag(Collection<? extends T> c) {
        super(c);
    }

    public ObjectBag(T[] a) {
        super(a);
    }

    public ObjectBag(T[] a, int offset, int count) {
        super(a, offset, count);
    }

    public ObjectBag(Ordered<T> other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void add(int index, @Nullable T element) {
        super.add(element);
    }

    @Override
    public void insert(int index, @Nullable T element) {
        super.add(element);
    }

    @Override
    public @Nullable T remove(int index) {
        int size = this.size();
        Object value = super.set(index, this.get(size - 1));
        super.remove(size - 1);
        return (T)value;
    }

    @Override
    public @Nullable T removeAt(int index) {
        int size = this.size();
        Object value = super.set(index, this.get(size - 1));
        super.remove(size - 1);
        return (T)value;
    }

    @Override
    public boolean equalsIdentity(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            h += this.get(i).hashCode();
        }
        return h;
    }

    public static <T> ObjectBag<T> with(T item) {
        ObjectBag<T> list = new ObjectBag<T>(1);
        list.add(item);
        return list;
    }

    @SafeVarargs
    public static <T> ObjectBag<T> with(T ... varargs) {
        return new ObjectBag<T>(varargs);
    }
}

