/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Arrangeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectDeque<T>
implements Deque<T>,
Arrangeable {
    protected @Nullable T defaultValue = null;
    protected T[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;
    protected transient @Nullable ObjectDequeIterator<T> iterator1;
    protected transient @Nullable ObjectDequeIterator<T> iterator2;
    protected transient @Nullable ObjectDequeIterator<T> descendingIterator1;
    protected transient @Nullable ObjectDequeIterator<T> descendingIterator2;

    public ObjectDeque() {
        this(16);
    }

    public ObjectDeque(int initialSize) {
        this.values = new Object[initialSize];
    }

    public ObjectDeque(Collection<? extends T> coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public ObjectDeque(ObjectDeque<? extends T> deque) {
        this.values = Arrays.copyOf(deque.values, deque.values.length);
        this.size = deque.size;
        this.head = deque.head;
        this.tail = deque.tail;
        this.defaultValue = deque.defaultValue;
    }

    public ObjectDeque(T[] a) {
        this.tail = a.length;
        this.values = Arrays.copyOf(a, this.tail);
        this.size = this.tail;
    }

    public ObjectDeque(T[] a, int offset, int count) {
        this.values = Arrays.copyOfRange(a, offset, offset + count);
        this.tail = count;
        this.size = count;
    }

    public @Nullable T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void addLast(@Nullable T object) {
        T[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        if (this.tail == values.length) {
            this.tail = 0;
        }
        values[this.tail++] = object;
        ++this.size;
    }

    @Override
    public void addFirst(@Nullable T object) {
        T[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        int head = this.head;
        if (--head == -1) {
            head = values.length - 1;
        }
        values[head] = object;
        this.head = head;
        ++this.size;
    }

    public void ensureCapacity(int additional) {
        int needed = this.size + additional;
        if (this.values.length < needed) {
            this.resize(needed);
        }
    }

    protected void resize(int newSize) {
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        Object[] newArray = new Object[newSize];
        if (head < tail) {
            System.arraycopy(values, head, newArray, 0, tail - head);
        } else if (this.size > 0) {
            int rest = values.length - head;
            System.arraycopy(values, head, newArray, 0, rest);
            System.arraycopy(values, 0, newArray, rest, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    @Override
    public @Nullable T removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("ObjectDeque is empty.");
        }
        T[] values = this.values;
        T result = values[this.head];
        values[this.head] = null;
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    @Override
    public @Nullable T removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("ObjectDeque is empty.");
        }
        T[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        T result = values[tail];
        values[tail] = null;
        this.tail = tail;
        --this.size;
        return result;
    }

    @Override
    public boolean offerFirst(@Nullable T t) {
        int oldSize = this.size;
        this.addFirst(t);
        return oldSize != this.size;
    }

    @Override
    public boolean offerLast(@Nullable T t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    @Override
    public @Nullable T pollFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        T[] values = this.values;
        T result = values[this.head];
        values[this.head] = null;
        ++this.head;
        if (this.head == values.length) {
            this.head = 0;
        }
        --this.size;
        return result;
    }

    @Override
    public @Nullable T pollLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        T[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        T result = values[tail];
        values[tail] = null;
        this.tail = tail;
        --this.size;
        return result;
    }

    @Override
    public @Nullable T getFirst() {
        return this.first();
    }

    @Override
    public @Nullable T getLast() {
        return this.last();
    }

    @Override
    public @Nullable T peekFirst() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        return this.values[this.head];
    }

    @Override
    public @Nullable T peekLast() {
        if (this.size == 0) {
            return this.defaultValue;
        }
        T[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    @Override
    public boolean removeFirstOccurrence(@Nullable Object o) {
        return this.removeValue(o, false);
    }

    @Override
    public boolean removeLastOccurrence(@Nullable Object o) {
        return this.removeLastValue(o, false);
    }

    @Override
    public boolean add(@Nullable T t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    public boolean add(int index, @Nullable T item) {
        int oldSize = this.size;
        if (index <= 0) {
            this.addFirst(item);
        } else if (index >= oldSize) {
            this.addLast(item);
        } else {
            T[] values = this.values;
            if (this.size == values.length) {
                this.resize(values.length << 1);
                values = this.values;
            }
            if (this.head < this.tail) {
                if ((index += this.head) >= values.length) {
                    index -= values.length;
                }
                System.arraycopy(values, index, values, (index + 1) % values.length, this.tail - index);
                values[index] = item;
                ++this.tail;
                if (this.tail > values.length) {
                    this.tail = 1;
                }
            } else if (this.head + index < values.length) {
                System.arraycopy(values, this.head, values, this.head - 1, index);
                values[this.head - 1 + index] = item;
                --this.head;
            } else {
                System.arraycopy(values, this.head + (index -= values.length - 1), values, this.head + index + 1, this.tail - this.head - index);
                values[this.head + index] = item;
                ++this.tail;
            }
            ++this.size;
        }
        return oldSize != this.size;
    }

    public boolean insert(int index, @Nullable T element) {
        return this.add(index, element);
    }

    @Override
    public boolean offer(@Nullable T t) {
        int oldSize = this.size;
        this.addLast(t);
        return oldSize != this.size;
    }

    @Override
    public @Nullable T remove() {
        return this.removeFirst();
    }

    @Override
    public @Nullable T poll() {
        return this.pollFirst();
    }

    @Override
    public @Nullable T element() {
        return this.first();
    }

    @Override
    public @Nullable T peek() {
        return this.peekFirst();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int oldSize = this.size;
        for (T t : c) {
            this.addLast(t);
        }
        return oldSize != this.size;
    }

    @Override
    public void push(@Nullable T t) {
        this.addFirst(t);
    }

    @Override
    public @Nullable T pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o, false) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        Object[] next = new Object[this.size];
        if (this.head < this.tail) {
            System.arraycopy(this.values, this.head, next, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.values, this.head, next, 0, this.size - this.head);
            System.arraycopy(this.values, 0, next, this.size - this.head, this.tail);
        }
        return next;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        int oldSize = this.size;
        if (a.length < oldSize) {
            a = Arrays.copyOf(a, oldSize);
        }
        E[] result = a;
        Iterator it = this.iterator();
        for (int i = 0; i < oldSize; ++i) {
            result[i] = it.next();
        }
        if (a.length > oldSize) {
            a[oldSize] = null;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int oldSize = this.size;
        for (Object o : c) {
            this.remove(o);
        }
        return oldSize != this.size;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int oldSize = this.size;
        for (Object o : c) {
            int idx;
            do {
                if ((idx = this.indexOf(o, false)) == -1) continue;
                this.removeAt(idx);
            } while (idx == -1);
        }
        return oldSize != this.size;
    }

    public int indexOf(@Nullable Object value) {
        return this.indexOf(value, false);
    }

    public int indexOf(@Nullable Object value, boolean identity) {
        if (this.size == 0) {
            return -1;
        }
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (identity || value == null) {
            if (head < tail) {
                for (int i = head; i < tail; ++i) {
                    if (values[i] != value) continue;
                    return i - head;
                }
            } else {
                int i;
                int n = values.length;
                for (i = head; i < n; ++i) {
                    if (values[i] != value) continue;
                    return i - head;
                }
                for (i = 0; i < tail; ++i) {
                    if (values[i] != value) continue;
                    return i + values.length - head;
                }
            }
        } else if (head < tail) {
            for (int i = head; i < tail; ++i) {
                if (!value.equals(values[i])) continue;
                return i - head;
            }
        } else {
            int i;
            int n = values.length;
            for (i = head; i < n; ++i) {
                if (!value.equals(values[i])) continue;
                return i - head;
            }
            for (i = 0; i < tail; ++i) {
                if (!value.equals(values[i])) continue;
                return i + values.length - head;
            }
        }
        return -1;
    }

    public int lastIndexOf(@Nullable Object value) {
        return this.lastIndexOf(value, false);
    }

    public int lastIndexOf(@Nullable Object value, boolean identity) {
        if (this.size == 0) {
            return -1;
        }
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (identity || value == null) {
            if (head < tail) {
                for (int i = tail - 1; i >= head; --i) {
                    if (values[i] != value) continue;
                    return i - head;
                }
            } else {
                int i;
                for (i = tail - 1; i >= 0; --i) {
                    if (values[i] != value) continue;
                    return i + values.length - head;
                }
                for (i = values.length - 1; i >= head; --i) {
                    if (values[i] != value) continue;
                    return i - head;
                }
            }
        } else if (head < tail) {
            for (int i = tail - 1; i >= head; --i) {
                if (!value.equals(values[i])) continue;
                return i - head;
            }
        } else {
            int i;
            for (i = tail - 1; i >= 0; --i) {
                if (!value.equals(values[i])) continue;
                return i + values.length - head;
            }
            for (i = values.length - 1; i >= head; --i) {
                if (!value.equals(values[i])) continue;
                return i - head;
            }
        }
        return -1;
    }

    public boolean removeValue(@Nullable Object value, boolean identity) {
        int index = this.indexOf(value, identity);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public boolean removeLastValue(@Nullable Object value, boolean identity) {
        int index = this.lastIndexOf(value, identity);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public @Nullable T removeAt(int index) {
        T value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail--;
        index += head;
        if (head < tail) {
            value = values[index];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
            values[this.tail] = null;
        } else if (index >= values.length) {
            value = values[index -= values.length];
            System.arraycopy(values, index + 1, values, index, tail - index - 1);
            --this.tail;
            values[this.tail] = null;
        } else {
            value = values[index];
            System.arraycopy(values, head, values, head + 1, index - head);
            values[this.head] = null;
            ++this.head;
            if (this.head == values.length) {
                this.head = 0;
            }
        }
        --this.size;
        return value;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public @Nullable T first() {
        if (this.size == 0) {
            throw new NoSuchElementException("ObjectDeque is empty.");
        }
        return this.values[this.head];
    }

    public @Nullable T last() {
        if (this.size == 0) {
            throw new NoSuchElementException("ObjectDeque is empty.");
        }
        T[] values = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values.length - 1;
        }
        return values[tail];
    }

    public @Nullable T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        T[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        return values[i];
    }

    public @Nullable T set(int index, @Nullable T item) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        T[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        T old = values[i];
        values[i] = item;
        return old;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        if (head < tail) {
            for (int i = head; i < tail; ++i) {
                values[i] = null;
            }
        } else {
            int i;
            for (i = head; i < values.length; ++i) {
                values[i] = null;
            }
            for (i = 0; i < tail; ++i) {
                values[i] = null;
            }
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    @Override
    public ObjectDequeIterator<T> iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new ObjectDequeIterator(this);
            this.iterator2 = new ObjectDequeIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public ObjectDequeIterator<T> descendingIterator() {
        if (this.descendingIterator1 == null || this.descendingIterator2 == null) {
            this.descendingIterator1 = new ObjectDequeIterator(this, true);
            this.descendingIterator2 = new ObjectDequeIterator(this, true);
        }
        if (!this.descendingIterator1.valid) {
            this.descendingIterator1.reset();
            this.descendingIterator1.valid = true;
            this.descendingIterator2.valid = false;
            return this.descendingIterator1;
        }
        this.descendingIterator2.reset();
        this.descendingIterator2.valid = true;
        this.descendingIterator1.valid = false;
        return this.descendingIterator2;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(", ").append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(separator).append(values[i]);
            if (++i == tail) break;
            if (i != values.length) continue;
            i = 0;
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int size = this.size;
        T[] values = this.values;
        int backingLength = values.length;
        int index = this.head;
        int hash = size + 1;
        for (int s = 0; s < size; ++s) {
            T value = values[index];
            hash *= 31;
            if (value != null) {
                hash += value.hashCode();
            }
            if (++index != backingLength) continue;
            index = 0;
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectDeque)) {
            return false;
        }
        ObjectDeque q = (ObjectDeque)o;
        int size = this.size;
        if (q.size != size) {
            return false;
        }
        T[] myValues = this.values;
        int myBackingLength = myValues.length;
        T[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size; ++s) {
            T myValue = myValues[myIndex];
            T itsValue = itsValues[itsIndex];
            if (!Objects.equals(myValue, itsValue)) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    public boolean equalsIdentity(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectDeque)) {
            return false;
        }
        ObjectDeque q = (ObjectDeque)o;
        int size = this.size;
        if (q.size != size) {
            return false;
        }
        T[] myValues = this.values;
        int myBackingLength = myValues.length;
        T[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size; ++s) {
            if (myValues[myIndex] != itsValues[itsIndex]) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    @Override
    public void swap(int first, int second) {
        int s;
        if (first < 0) {
            throw new IndexOutOfBoundsException("first index can't be < 0: " + first);
        }
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first index can't be >= size: " + first + " >= " + this.size);
        }
        if (second < 0) {
            throw new IndexOutOfBoundsException("second index can't be < 0: " + second);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second index can't be >= size: " + second + " >= " + this.size);
        }
        int f = this.head + first;
        T[] values = this.values;
        if (f >= values.length) {
            f -= values.length;
        }
        if ((s = this.head + second) >= values.length) {
            s -= values.length;
        }
        T fv = values[f];
        values[f] = values[s];
        values[s] = fv;
    }

    @Override
    public void reverse() {
        T[] values = this.values;
        int len = values.length;
        int n = this.size >> 1;
        int b = 0;
        for (int t = this.size - 1; b <= n && b != t; ++b, --t) {
            int s;
            int f = this.head + b;
            if (f >= len) {
                f -= len;
            }
            if ((s = this.head + t) >= len) {
                s -= len;
            }
            T fv = values[f];
            values[f] = values[s];
            values[s] = fv;
        }
    }

    public void sort() {
        this.sort(null);
    }

    public void sort(@Nullable Comparator<? super T> comparator) {
        if (this.head <= this.tail) {
            Arrays.sort(this.values, this.head, this.tail, comparator);
        } else {
            System.arraycopy(this.values, this.head, this.values, this.tail, this.values.length - this.head);
            Arrays.sort(this.values, 0, this.tail + this.values.length - this.head, comparator);
            this.tail = this.tail + this.values.length - this.head;
            this.head = 0;
        }
    }

    public @Nullable T random(Random random) {
        if (this.size <= 0) {
            throw new NoSuchElementException("ObjectDeque is empty.");
        }
        return this.get(random.nextInt(this.size));
    }

    public static <T> ObjectDeque<T> with(T item) {
        ObjectDeque<T> deque = new ObjectDeque<T>();
        deque.add(item);
        return deque;
    }

    @SafeVarargs
    public static <T> ObjectDeque<T> with(T ... items) {
        return new ObjectDeque<T>(items);
    }

    public static class ObjectDequeIterator<T>
    implements Iterable<T>,
    ListIterator<T> {
        protected int index;
        protected int latest = -1;
        protected ObjectDeque<T> deque;
        protected boolean valid = true;
        private final int direction;

        public ObjectDequeIterator(ObjectDeque<T> deque) {
            this(deque, false);
        }

        public ObjectDequeIterator(ObjectDeque<T> deque, boolean descendingOrder) {
            this.deque = deque;
            this.direction = descendingOrder ? -1 : 1;
        }

        public ObjectDequeIterator(ObjectDeque<T> deque, int index, boolean descendingOrder) {
            if (index < 0 || index >= deque.size()) {
                throw new IndexOutOfBoundsException("ObjectDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.deque = deque;
            this.index = index;
            this.direction = descendingOrder ? -1 : 1;
        }

        @Override
        public @Nullable T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index;
            this.index += this.direction;
            return this.deque.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == 1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        @Override
        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.direction == -1 ? this.index < this.deque.size() : this.index > 0 && this.deque.notEmpty();
        }

        @Override
        public @Nullable T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index -= this.direction;
            return this.deque.get(this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        @Override
        public void set(@Nullable T t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.set(this.latest, t);
        }

        @Override
        public void add(@Nullable T t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.deque.size()) {
                throw new NoSuchElementException();
            }
            this.deque.insert(this.index, t);
            this.index += this.direction;
            this.latest = -1;
        }

        public void reset() {
            this.index = this.deque.size - 1 & this.direction >> 31;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.deque.size()) {
                throw new IndexOutOfBoundsException("ObjectDequeIterator does not satisfy index >= 0 && index < deque.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        @Override
        public ObjectDequeIterator<T> iterator() {
            return this;
        }
    }
}

