/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.Utilities;
import com.github.tommyettinger.function.ObjIntToIntBiFunction;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntBinaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectIntMap<K>
implements Iterable<Entry<K>> {
    protected int size;
    protected K[] keyTable;
    protected int[] valueTable;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable Entries<K> entries1;
    protected transient @Nullable Entries<K> entries2;
    protected transient @Nullable Values<K> values1;
    protected transient @Nullable Values<K> values2;
    protected transient @Nullable Keys<K> keys1;
    protected transient @Nullable Keys<K> keys2;
    public int defaultValue = 0;

    public ObjectIntMap() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public ObjectIntMap(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public ObjectIntMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.valueTable = new int[tableSize];
    }

    public ObjectIntMap(ObjectIntMap<? extends K> map) {
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size = map.size;
        this.defaultValue = map.defaultValue;
        this.hashMultiplier = map.hashMultiplier;
    }

    public ObjectIntMap(K[] keys, int[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    public ObjectIntMap(Collection<? extends K> keys, PrimitiveCollection.OfInt values) {
        this(Math.min(keys.size(), values.size()));
        this.putAll(keys, values);
    }

    public void putAll(Collection<? extends K> keys, PrimitiveCollection.OfInt values) {
        int length = Math.min(keys.size(), values.size());
        this.ensureCapacity(length);
        Iterator<K> ki = keys.iterator();
        PrimitiveIterator.OfInt vi = values.iterator();
        while (ki.hasNext() && vi.hasNext()) {
            K key = ki.next();
            if (key == null) continue;
            this.put(key, vi.next());
        }
    }

    protected int place(Object item) {
        return (int)((long)item.hashCode() * this.hashMultiplier >>> this.shift);
    }

    protected boolean equate(Object left, @Nullable Object right) {
        return left.equals(right);
    }

    protected int locateKey(Object key) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return ~i;
            }
            i = i + 1 & this.mask;
        }
        return i;
    }

    public int put(K key, int value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return this.defaultValue;
    }

    public int putOrDefault(K key, int value, int defaultValue) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(ObjectIntMap<? extends K> map) {
        this.ensureCapacity(map.size);
        K[] keyTable = map.keyTable;
        int[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            this.put(key, valueTable[i]);
        }
    }

    public void putAll(K[] keys, int[] values) {
        this.putAll(keys, 0, values, 0, Math.min(keys.length, values.length));
    }

    public void putAll(K[] keys, int[] values, int length) {
        this.putAll(keys, 0, values, 0, length);
    }

    public void putAll(K[] keys, int keyOffset, int[] values, int valueOffset, int length) {
        length = Math.min(length, Math.min(keys.length - keyOffset, values.length - valueOffset));
        this.ensureCapacity(length);
        int k = keyOffset;
        int v = valueOffset;
        int i = 0;
        int n = length;
        while (i < n) {
            K key = keys[k];
            if (key != null) {
                this.put(key, values[v]);
            }
            ++i;
            ++k;
            ++v;
        }
    }

    protected void putResize(K key, int value) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public int get(Object key) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return this.defaultValue;
            }
            i = i + 1 & this.mask;
        }
        return this.valueTable[i];
    }

    public int getOrDefault(Object key, int defaultValue) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return defaultValue;
            }
            i = i + 1 & this.mask;
        }
        return this.valueTable[i];
    }

    public int getAndIncrement(K key, int defaultValue, int increment) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            int n = i;
            this.valueTable[n] = this.valueTable[n] + increment;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = defaultValue + increment;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public int remove(Object key) {
        K rem;
        int i = this.locateKey(key);
        if (i < 0) {
            return this.defaultValue;
        }
        K[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((rem = keyTable[next]) != null) {
            int placement = this.place(rem);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = rem;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        --this.size;
        return oldValue;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(Math.max(maximumCapacity, this.size), this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean containsValue(int value) {
        int[] valueTable = this.valueTable;
        K[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == null || valueTable[i] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return false;
            }
            i = i + 1 & this.mask;
        }
        return true;
    }

    public @Nullable K findKey(int value) {
        int[] valueTable = this.valueTable;
        K[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == null || valueTable[i] != value) continue;
            return keyTable[i];
        }
        return null;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        K[] oldKeyTable = this.keyTable;
        int[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize];
        this.valueTable = new int[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                K key = oldKeyTable[i];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    public int hashCode() {
        int h = this.size;
        K[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            h ^= key.hashCode();
            h ^= valueTable[i];
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectIntMap)) {
            return false;
        }
        ObjectIntMap other = (ObjectIntMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int value;
            K key = keyTable[i];
            if (key == null || (value = valueTable[i]) == other.get(key)) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String separator, boolean braces) {
        int value;
        K key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        K[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    @Override
    public void forEach(ObjIntConsumer<? super K> action) {
        for (Entry<K> entry : this.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public void replaceAll(ObjIntToIntBiFunction<? super K> function) {
        for (Entry<K> entry : this.entrySet()) {
            entry.setValue(function.applyAsInt(entry.getKey(), entry.getValue()));
        }
    }

    public void truncate(int newSize) {
        K[] keyTable = this.keyTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == null) continue;
            keyTable[i] = null;
            --this.size;
        }
    }

    @Override
    public Iterator<Entry<K>> iterator() {
        return this.entrySet().iterator();
    }

    public Keys<K> keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    public Values<K> values() {
        if (this.values1 == null || this.values2 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.iter.valid) {
            this.values1.iter.reset();
            this.values1.iter.valid = true;
            this.values2.iter.valid = false;
            return this.values1;
        }
        this.values2.iter.reset();
        this.values2.iter.valid = true;
        this.values1.iter.valid = false;
        return this.values2;
    }

    public Entries<K> entrySet() {
        if (this.entries1 == null || this.entries2 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.iter.valid) {
            this.entries1.iter.reset();
            this.entries1.iter.valid = true;
            this.entries2.iter.valid = false;
            return this.entries1;
        }
        this.entries2.iter.reset();
        this.entries2.iter.valid = true;
        this.entries1.iter.valid = false;
        return this.entries2;
    }

    public int putIfAbsent(K key, int value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            return this.valueTable[i];
        }
        return this.put(key, value);
    }

    public boolean replace(K key, int oldValue, int newValue) {
        int curValue = this.get(key);
        if (curValue != oldValue || !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    public int replace(K key, int value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        return this.defaultValue;
    }

    public int computeIfAbsent(K key, ToIntFunction<? super K> mappingFunction) {
        int i = this.locateKey(key);
        if (i < 0) {
            int newValue = mappingFunction.applyAsInt(key);
            this.put(key, newValue);
            return newValue;
        }
        return this.valueTable[i];
    }

    public boolean remove(Object key, int value) {
        int i = this.locateKey(key);
        if (i >= 0 && this.valueTable[i] == value) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public int merge(K key, int value, IntBinaryOperator remappingFunction) {
        int i = this.locateKey(key);
        int next = i < 0 ? value : remappingFunction.applyAsInt(this.valueTable[i], value);
        this.put(key, next);
        return next;
    }

    public static <K> ObjectIntMap<K> with(K key0, Number value0) {
        ObjectIntMap<K> map = new ObjectIntMap<K>(1);
        map.put(key0, value0.intValue());
        return map;
    }

    public static <K> ObjectIntMap<K> with(K key0, Number value0, Object ... rest) {
        ObjectIntMap<Object> map = new ObjectIntMap<Object>(1 + (rest.length >>> 1));
        map.put(key0, value0.intValue());
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put(rest[i - 1], ((Number)rest[i]).intValue());
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }

    public static class Entries<K>
    extends AbstractSet<Entry<K>> {
        protected EntryIterator<K> iter;

        public Entries(ObjectIntMap<K> map) {
            this.iter = new EntryIterator<K>(map);
        }

        @Override
        public Iterator<Entry<K>> iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public ObjectList<Entry<K>> toList() {
            ObjectList<Entry<K>> list = new ObjectList<Entry<K>>(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(new Entry(this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<Entry<K>> appendInto(Collection<Entry<K>> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(new Entry(this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        public ObjectIntMap<K> appendInto(ObjectIntMap<K> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                this.iter.next();
                assert (this.iter.entry.key != null);
                coll.put(this.iter.entry.key, this.iter.entry.value);
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    public static class Entry<K> {
        public @Nullable K key;
        public int value;

        public Entry() {
        }

        public Entry(@Nullable K key, int value) {
            this.key = key;
            this.value = value;
        }

        public Entry(Entry<K> entry) {
            this.key = entry.key;
            this.value = entry.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public K getKey() {
            assert (this.key != null);
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int old = this.value;
            this.value = value;
            return old;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || this.key == null) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.key.equals(entry.key)) {
                return false;
            }
            return this.value == entry.value;
        }

        public int hashCode() {
            assert (this.key != null);
            return this.key.hashCode() * 31 + this.value;
        }
    }

    public static class Keys<K>
    extends AbstractSet<K> {
        protected KeyIterator<K> iter;

        public Keys(ObjectIntMap<K> map) {
            this.iter = new KeyIterator<K>(map);
        }

        @Override
        public boolean contains(Object o) {
            return this.iter.map.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public ObjectList<K> toList() {
            ObjectList list = new ObjectList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<K> appendInto(Collection<K> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    public static class KeyIterator<K>
    extends MapIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public KeyIterator(ObjectIntMap<K> map) {
            super(map);
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object key = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }
    }

    public static class Values<K>
    implements PrimitiveCollection.OfInt {
        protected ValueIterator<K> iter;

        @Override
        public boolean add(int item) {
            throw new UnsupportedOperationException("ObjectIntMap.Values is read-only");
        }

        @Override
        public boolean remove(int item) {
            throw new UnsupportedOperationException("ObjectIntMap.Values is read-only");
        }

        @Override
        public boolean contains(int item) {
            return this.iter.map.containsValue(item);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("ObjectIntMap.Values is read-only");
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        public Values(ObjectIntMap<K> map) {
            this.iter = new ValueIterator<K>(map);
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public IntList toList() {
            IntList list = new IntList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.nextInt());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public PrimitiveCollection.OfInt appendInto(PrimitiveCollection.OfInt coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.nextInt());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        @Override
        public boolean equals(Object other) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            boolean eq = PrimitiveCollection.OfInt.super.areEqual(other);
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return eq;
        }
    }

    public static class ValueIterator<K>
    extends MapIterator<K>
    implements PrimitiveIterator.OfInt {
        public ValueIterator(ObjectIntMap<K> map) {
            super(map);
        }

        @Override
        public int nextInt() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return value;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    public static class EntryIterator<K>
    extends MapIterator<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        protected Entry<K> entry = new Entry();

        public EntryIterator(ObjectIntMap<K> map) {
            super(map);
        }

        @Override
        public Iterator<Entry<K>> iterator() {
            return this;
        }

        @Override
        public Entry<K> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K[] keyTable = this.map.keyTable;
            this.entry.key = keyTable[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }
    }

    protected static abstract class MapIterator<K> {
        public boolean hasNext;
        protected final ObjectIntMap<K> map;
        protected int nextIndex;
        protected int currentIndex;
        protected boolean valid = true;

        public MapIterator(ObjectIntMap<K> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            K[] keyTable = this.map.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public void remove() {
            Object key;
            int i = this.currentIndex;
            if (i < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            K[] keyTable = this.map.keyTable;
            int[] valueTable = this.map.valueTable;
            int mask = this.map.mask;
            int next = i + 1 & mask;
            while ((key = keyTable[next]) != null) {
                int placement = this.map.place(key);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    valueTable[i] = valueTable[next];
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            --this.map.size;
            if (i != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }
    }
}

